/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveFileSystem
extends NewVirtualFileSystem {
    private static final Key<VirtualFile> LOCAL_FILE = Key.create("vfs.archive.local.file");
    private final Function<VirtualFile, FileAttributes> myAttrGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file2 -> this.getHandler((VirtualFile)file2).getAttributes(this.getRelativePath((VirtualFile)file2)));
    private final Function<VirtualFile, String[]> myChildrenGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file2 -> this.getHandler((VirtualFile)file2).list(this.getRelativePath((VirtualFile)file2)));
    private final Function<VirtualFile, Pair<byte[], IOException>> myContentGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file2 -> {
        try {
            return Pair.pair(this.getHandler((VirtualFile)file2).contentsToByteArray(this.getRelativePath((VirtualFile)file2)), null);
        }
        catch (IOException e) {
            return Pair.pair(null, e);
        }
    });

    @Nullable
    public VirtualFile getRootByLocal(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(0);
        }
        return this.isCorrectFileType(file2) ? this.findFileByPath(this.getRootPathByLocal(file2)) : null;
    }

    @NotNull
    public String getRootPathByLocal(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(1);
        }
        String string2 = this.composeRootPath(file2.getPath());
        if (string2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    public VirtualFile getRootByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(3);
        }
        return entry.getFileSystem() == this ? VfsUtilCore.getRootFile(entry) : null;
    }

    @Nullable
    public VirtualFile getLocalByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(4);
        }
        if (entry.getFileSystem() != this) {
            return null;
        }
        VirtualFile root = this.getRootByEntry(entry);
        assert (root != null) : entry;
        VirtualFile local = LOCAL_FILE.get(root);
        if (local == null) {
            String localPath = this.extractLocalPath(root.getPath());
            local = StandardFileSystems.local().findFileByPath(localPath);
            if (local != null) {
                LOCAL_FILE.set(root, local);
            }
        }
        return local;
    }

    @NotNull
    protected abstract String extractLocalPath(@NotNull String var1);

    @NotNull
    protected abstract String composeRootPath(@NotNull String var1);

    @NotNull
    protected abstract ArchiveHandler getHandler(@NotNull VirtualFile var1);

    @Override
    public int getRank() {
        return LocalFileSystem.getInstance().getRank() + 1;
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(5);
        }
        if (newParent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(6);
        }
        if (copyName == null) {
            ArchiveFileSystem.$$$reportNull$$$0(7);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file2.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(8);
        }
        if (dir == null) {
            ArchiveFileSystem.$$$reportNull$$$0(9);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        if (parent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(11);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(12);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file2.getUrl()));
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(13);
        }
        if (newParent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(14);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file2.getUrl()));
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName2) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(15);
        }
        if (newName2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(16);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file2.getUrl()));
    }

    @NotNull
    protected String getRelativePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(17);
        }
        String relativePath = file2.getPath().substring(VfsUtilCore.getRootFile(file2).getPath().length());
        String string2 = StringUtil.trimLeading(relativePath, '/');
        if (string2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @Override
    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(19);
        }
        return this.myAttrGetter.apply(file2);
    }

    @ApiStatus.Internal
    @NotNull
    public FileAttributes getArchiveRootAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(20);
        }
        this.getHandler(file2);
        FileAttributes fileAttributes = ArchiveHandler.DIRECTORY_ATTRIBUTES;
        if (fileAttributes == null) {
            ArchiveFileSystem.$$$reportNull$$$0(21);
        }
        return fileAttributes;
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(22);
        }
        String[] stringArray = this.myChildrenGetter.apply(file2);
        if (stringArray == null) {
            ArchiveFileSystem.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    @Override
    public boolean exists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(24);
        }
        if (file2.getParent() == null) {
            return this.getLocalByEntry(file2) != null;
        }
        return this.getAttributes(file2) != null;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(25);
        }
        if (file2.getParent() == null) {
            return true;
        }
        FileAttributes attributes = this.getAttributes(file2);
        return attributes == null || attributes.isDirectory();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(26);
        }
        return false;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(27);
        }
        if (file2.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file2);
            if (host != null) {
                return host.getTimeStamp();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file2);
            if (attributes != null) {
                return attributes.lastModified;
            }
        }
        return -1L;
    }

    @Override
    public long getLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(28);
        }
        if (file2.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file2);
            if (host != null) {
                return host.getLength();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file2);
            if (attributes != null) {
                return attributes.length;
            }
        }
        return 0L;
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(29);
        }
        Pair<byte[], IOException> pair = this.myContentGetter.apply(file2);
        IOException exception = (IOException)pair.second;
        if (exception != null) {
            exception.addSuppressed(new Throwable("Caller thread's stacktrace"));
            throw exception;
        }
        byte[] byArray = (byte[])pair.first;
        if (byArray == null) {
            ArchiveFileSystem.$$$reportNull$$$0(30);
        }
        return byArray;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(31);
        }
        InputStream inputStream = this.getHandler(file2).getInputStream(this.getRelativePath(file2));
        if (inputStream == null) {
            ArchiveFileSystem.$$$reportNull$$$0(32);
        }
        return inputStream;
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(33);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file2.getUrl()));
    }

    @Override
    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(34);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file2.getUrl()));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, long l) throws IOException {
        if (file2 == null) {
            ArchiveFileSystem.$$$reportNull$$$0(35);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file2.getUrl()));
    }

    @Nullable
    public VirtualFile findLocalByRootPath(@NotNull String rootPath) {
        if (rootPath == null) {
            ArchiveFileSystem.$$$reportNull$$$0(36);
        }
        String localPath = this.extractLocalPath(rootPath);
        VirtualFile local = StandardFileSystems.local().findFileByPath(localPath);
        return local != null && this.isCorrectFileType(local) ? local : null;
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            ArchiveFileSystem.$$$reportNull$$$0(37);
        }
        return FileTypeRegistry.getInstance().getFileTypeByFileName(local.getNameSequence()) == ArchiveFileType.INSTANCE;
    }

    @ApiStatus.Internal
    public final void clearArchiveCache(@NotNull VirtualFile sampleEntry) {
        if (sampleEntry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(38);
        }
        this.getHandler(sampleEntry).clearCaches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 23: 
            case 30: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 23: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 23: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPathByLocal";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchiveRootAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootByLocal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRootPathByLocal";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 23: 
            case 30: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootByEntry";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalByEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getArchiveRootAttributes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findLocalByRootPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "clearArchiveCache";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 23: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

