/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.ResourceHandle;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    private static final Logger LOG = Logger.getInstance(ZipHandlerBase.class);

    @NotNull
    public Map<String, Long> getArchiveCrcHashes() throws IOException {
        @NotNull ResourceHandle<ZipFile> handle2 = this.acquireZipHandle();
        ZipFile file2 = handle2.get();
        Enumeration<? extends ZipEntry> entries2 = file2.entries();
        Object2LongOpenHashMap<String> result2 = new Object2LongOpenHashMap<String>();
        while (entries2.hasMoreElements()) {
            ZipEntry entry = entries2.nextElement();
            result2.put(this.normalizeName(entry.getName()), Long.valueOf(entry.getCrc()));
        }
        Object2LongOpenHashMap<String> object2LongOpenHashMap = result2;
        Object2LongOpenHashMap<String> object2LongOpenHashMap2 = object2LongOpenHashMap;
        if (object2LongOpenHashMap2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(0);
        }
        return object2LongOpenHashMap2;
        finally {
            if (handle2 != null) {
                handle2.close();
            }
        }
    }

    @ApiStatus.Internal
    public static boolean getUseCrcInsteadOfTimestampPropertyValue() {
        return Boolean.getBoolean("zip.handler.uses.crc.instead.of.timestamp");
    }

    public ZipHandlerBase(@NotNull String path2) {
        if (path2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(1);
        }
        super(path2);
    }

    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
        Map<String, ArchiveHandler.EntryInfo> map2 = this.buildEntryMapForZipFile(zipRef.get());
        Map<String, ArchiveHandler.EntryInfo> map3 = map2;
        if (map3 == null) {
            ZipHandlerBase.$$$reportNull$$$0(2);
        }
        return map3;
        finally {
            if (zipRef != null) {
                zipRef.close();
            }
        }
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(@NotNull ZipFile zip2) {
        if (zip2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(3);
        }
        ZipEntryMap map2 = new ZipEntryMap(zip2.size());
        Enumeration<? extends ZipEntry> entries2 = zip2.entries();
        while (entries2.hasMoreElements()) {
            ZipEntry ze = entries2.nextElement();
            this.processEntry(map2, LOG, ze.getName(), ze.isDirectory() ? null : (parent, name2) -> {
                long fileStamp = ZipHandlerBase.getUseCrcInsteadOfTimestampPropertyValue() ? ze.getCrc() : this.getEntryFileStamp();
                return new ArchiveHandler.EntryInfo((CharSequence)name2, false, ze.getSize(), fileStamp, (ArchiveHandler.EntryInfo)parent);
            });
        }
        ZipEntryMap zipEntryMap = map2;
        if (zipEntryMap == null) {
            ZipHandlerBase.$$$reportNull$$$0(4);
        }
        return zipEntryMap;
    }

    public long getEntryCrc(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            ZipHandlerBase.$$$reportNull$$$0(5);
        }
        try (ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();){
            ZipFile zip2 = zipRef.get();
            ZipEntry entry = zip2.getEntry(relativePath);
            if (entry != null) {
                long l = entry.getCrc();
                return l;
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block15: {
            byte[] byArray;
            InputStream stream;
            ResourceHandle<ZipFile> zipRef;
            block16: {
                if (relativePath == null) {
                    ZipHandlerBase.$$$reportNull$$$0(6);
                }
                zipRef = this.acquireZipHandle();
                ZipFile zip2 = zipRef.get();
                ZipEntry entry = zip2.getEntry(relativePath);
                if (entry == null) break block15;
                long length = entry.getSize();
                if (FileUtilRt.isTooLarge(length)) {
                    throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                }
                stream = zip2.getInputStream(entry);
                if (stream == null) break block15;
                byArray = FileUtil.loadBytes(stream, (int)length);
                if (byArray != null) break block16;
                ZipHandlerBase.$$$reportNull$$$0(7);
            }
            return byArray;
            {
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            finally {
                if (zipRef != null) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        block12: {
            InputStream stream;
            if (relativePath == null) {
                ZipHandlerBase.$$$reportNull$$$0(8);
            }
            boolean release = true;
            ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
            ZipFile zip2 = zipRef.get();
            ZipEntry entry = zip2.getEntry(relativePath);
            if (entry == null || (stream = zip2.getInputStream(entry)) == null) break block12;
            long length = entry.getSize();
            if (!FileUtilRt.isTooLarge(length)) {
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(FileUtil.loadBytes(stream, (int)length));
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream2 = bufferExposingByteArrayInputStream;
                if (bufferExposingByteArrayInputStream2 == null) {
                    ZipHandlerBase.$$$reportNull$$$0(9);
                }
                return bufferExposingByteArrayInputStream2;
                finally {
                    stream.close();
                }
            }
            release = false;
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(stream, zipRef);
            InputStreamWrapper inputStreamWrapper2 = inputStreamWrapper;
            if (inputStreamWrapper2 == null) {
                ZipHandlerBase.$$$reportNull$$$0(10);
            }
            return inputStreamWrapper2;
            finally {
                if (release) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<ZipFile> acquireZipHandle() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchiveCrcHashes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntryMapForZipFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildEntryMapForZipFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEntryCrc";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream myStream;
        private final ResourceHandle<ZipFile> myZipRef;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        InputStreamWrapper(InputStream stream, ResourceHandle<ZipFile> zipRef) {
            this.myStream = stream;
            this.myZipRef = zipRef;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(0);
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.myStream.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                try {
                    this.myStream.close();
                }
                finally {
                    this.myZipRef.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/openapi/vfs/impl/ZipHandlerBase$InputStreamWrapper", "read"));
        }
    }
}

