/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance(DefaultJDOMExternalizer.class);
    private static final ClassValue<Map<String, Field>> fieldCache = new DefaultJDOMExternalizerMapClassValue();

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode) throws WriteExternalException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(1);
        }
        DefaultJDOMExternalizer.write(data2, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") JDOMFilter filter2) throws WriteExternalException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(2);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(3);
        }
        if (filter2 instanceof Predicate) {
            DefaultJDOMExternalizer.write(data2, parentNode, (Predicate)((Object)filter2));
        } else {
            DefaultJDOMExternalizer.write(data2, parentNode, filter2 == null ? null : field -> filter2.isAccept((Field)field));
        }
    }

    public static void write(@NotNull Object data2, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") Predicate<? super Field> filter2) throws WriteExternalException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(5);
        }
        for (Field field : fieldCache.get(data2.getClass()).values()) {
            Element element2;
            String value;
            block25: {
                if (filter2 != null && !filter2.test(field)) continue;
                Class<?> type = field.getType();
                value = null;
                try {
                    if (type.isPrimitive()) {
                        if (type.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data2));
                        } else if (type.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data2));
                        } else if (type.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data2));
                        } else if (type.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data2));
                        } else if (type.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data2));
                        } else if (type.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data2));
                        } else if (type.equals(Character.TYPE)) {
                            value = String.valueOf(field.getChar(data2));
                        } else {
                            if (!type.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field.getBoolean(data2));
                        }
                        break block25;
                    }
                    if (type.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data2));
                        break block25;
                    }
                    if (type.isEnum()) {
                        value = field.get(data2).toString();
                        break block25;
                    }
                    if (type.equals(Color.class)) {
                        Color color = (Color)field.get(data2);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block25;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                        element2 = new Element("option");
                        parentNode.addContent(element2);
                        element2.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data2);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element2.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element2 = new Element("option");
            parentNode.addContent(element2);
            element2.setAttribute("name", field.getName());
            if (value == null) continue;
            element2.setAttribute("value", value);
        }
    }

    @Nullable
    static String filterXMLCharacters(@Nullable String value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder2 = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Verifier.isXMLCharacter(c)) {
                if (builder2 == null) continue;
                builder2.append(c);
                continue;
            }
            if (builder2 != null) continue;
            builder2 = new StringBuilder(value.length() + 5);
            builder2.append(value, 0, i);
        }
        if (builder2 != null) {
            value = builder2.toString();
        }
        return value;
    }

    public static void readExternal(@NotNull Object data2, Element parentNode) throws InvalidDataException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(6);
        }
        if (parentNode == null) {
            return;
        }
        Map<String, Field> fields = fieldCache.get(data2.getClass());
        block12: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Object value;
                Field field = fields.get(fieldName);
                if (field == null) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    value = field.get(data2);
                    if (!(value instanceof JDOMExternalizable)) continue;
                    List<Element> children2 = e.getChildren("value");
                    Iterator<Element> iterator = children2.iterator();
                    while (iterator.hasNext()) {
                        Element child;
                        Element valueTag = child = iterator.next();
                        ((JDOMExternalizable)value).readExternal(valueTag);
                    }
                    continue;
                }
                value = e.getAttributeValue("value");
                Class<?> type = field.getType();
                if (type.isPrimitive()) {
                    if (value == null) continue;
                    if (type.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data2, Byte.parseByte((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Short.TYPE)) {
                        try {
                            field.setShort(data2, Short.parseShort((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value);
                        field.setInt(data2, i);
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        try {
                            field.setLong(data2, Long.parseLong((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data2, Float.parseFloat((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data2, Double.parseDouble((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Character.TYPE)) {
                        if (((String)value).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data2, ((String)value).charAt(0));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        if (((String)value).equals("true")) {
                            field.setBoolean(data2, true);
                            continue;
                        }
                        if (((String)value).equals("false")) {
                            field.setBoolean(data2, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type.isEnum()) {
                    for (Object enumValue : type.getEnumConstants()) {
                        if (!enumValue.toString().equals(value)) continue;
                        field.set(data2, enumValue);
                        continue block12;
                    }
                    continue;
                }
                if (type.equals(String.class)) {
                    field.set(data2, value);
                    continue;
                }
                if (type.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value);
                    field.set(data2, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                    List<Element> children3 = e.getChildren("value");
                    if (children3.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element2 : children3) {
                        object = (JDOMExternalizable)type.newInstance();
                        object.readExternal(element2);
                    }
                    field.set(data2, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException ex) {
                throw new InvalidDataException(ex);
            }
        }
    }

    public static int toInt(@NotNull String value) throws InvalidDataException {
        int i;
        if (value == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(7);
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidDataException(value, e);
        }
        return i;
    }

    public static Color toColor(@Nullable String value) {
        Color color;
        if (value == null) {
            return null;
        }
        try {
            int rgb = Integer.parseInt(value, 16);
            color = new Color(rgb);
        }
        catch (NumberFormatException e) {
            LOG.debug("Wrong color value: " + value, e);
            throw new InvalidDataException("Wrong color value: " + value, e);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/DefaultJDOMExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "toInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DefaultJDOMExternalizerMapClassValue
    extends ClassValue<Map<String, Field>> {
        private DefaultJDOMExternalizerMapClassValue() {
        }

        @Override
        protected Map<String, Field> computeValue(Class<?> type) {
            LinkedHashMap<String, Field> result2 = new LinkedHashMap<String, Field>();
            for (Field field : type.getFields()) {
                int modifiers;
                String name2 = field.getName();
                if (name2.indexOf(36) >= 0 || result2.containsKey(name2) || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.isAnnotationPresent(Transient.class)) continue;
                field.setAccessible(true);
                if (field.getDeclaringClass().isAnnotationPresent(Transient.class)) continue;
                result2.put(name2, field);
            }
            return result2;
        }
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

