/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ImageDataByUrlLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J*\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/ui/ImageDataByPathLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "original", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lcom/intellij/openapi/ui/ImageDataByPathLoader;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "getPath", "()Ljava/lang/String;", "equals", "", "other", "", "getURL", "Ljava/net/URL;", "hashCode", "", "isMyClassLoader", "loadImage", "Ljava/awt/Image;", "filters", "", "Ljava/awt/image/ImageFilter;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "isDark", "patch", "originalPath", "transform", "Lcom/intellij/ui/icons/IconTransform;", "toString", "Companion", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class ImageDataByPathLoader
implements ImageDataLoader {
    @NotNull
    private final String path;
    @NotNull
    private final ClassLoader classLoader;
    private final ImageDataByPathLoader original;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Image loadImage(@NotNull List<? extends ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        int flags = 3;
        if (isDark) {
            flags |= 4;
        }
        return ImageLoader.loadImage(this.path, filters, null, this.classLoader, flags, scaleContext, !StringsKt.endsWith$default((String)this.path, (String)".svg", (boolean)false, (int)2, null));
    }

    @Override
    @Nullable
    public URL getURL() {
        return this.classLoader.getResource(this.path);
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        boolean isOriginal = this.original == null;
        ImageDataByPathLoader imageDataByPathLoader = isOriginal ? this : this.original;
        Intrinsics.checkNotNull((Object)imageDataByPathLoader);
        return ImageDataByPathLoader.Companion.doPatch(imageDataByPathLoader, transform2, isOriginal);
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoader == classLoader || this.original != null && this.original.classLoader == classLoader;
    }

    @NotNull
    public String toString() {
        return "ImageDataByPathLoader(classLoader=" + this.classLoader + ", path=" + this.path + ", original=" + this.original + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImageDataByPathLoader)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.path, (Object)((ImageDataByPathLoader)other).path) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.classLoader, (Object)((ImageDataByPathLoader)other).classLoader) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.original, (Object)((ImageDataByPathLoader)other).original) ^ true);
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = 31 * result2 + this.classLoader.hashCode();
        ImageDataByPathLoader imageDataByPathLoader = this.original;
        result2 = 31 * result2 + (imageDataByPathLoader != null ? imageDataByPathLoader.hashCode() : 0);
        return result2;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private ImageDataByPathLoader(String path2, ClassLoader classLoader, ImageDataByPathLoader original) {
        this.path = path2;
        this.classLoader = classLoader;
        this.original = original;
    }

    public /* synthetic */ ImageDataByPathLoader(String path2, ClassLoader classLoader, ImageDataByPathLoader original, DefaultConstructorMarker $constructor_marker) {
        this(path2, classLoader, original);
    }

    @JvmStatic
    @Nullable
    public static final Icon findIcon(@NonNls @NotNull String originalPath, @NotNull ClassLoader originalClassLoader, @Nullable Map<Pair<String, ClassLoader>, IconLoader.CachedImageIcon> cache2) {
        return Companion.findIcon(originalPath, originalClassLoader, cache2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0003\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J>\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2 \u0010\u0018\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/ui/ImageDataByPathLoader$Companion;", "", "()V", "createIcon", "Lcom/intellij/openapi/util/IconLoader$CachedImageIcon;", "originalPath", "", "Lorg/jetbrains/annotations/NonNls;", "originalClassLoader", "Ljava/lang/ClassLoader;", "patched", "Lcom/intellij/openapi/util/Pair;", "path", "classLoader", "doPatch", "Lcom/intellij/ui/icons/ImageDataLoader;", "originalLoader", "Lcom/intellij/openapi/ui/ImageDataByPathLoader;", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isOriginal", "", "findIcon", "Ljavax/swing/Icon;", "cache", "", "normalizePath", "patchedPath", "intellij.platform.util.ui"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Icon findIcon(@NonNls @NotNull String originalPath, @NotNull ClassLoader originalClassLoader, @Nullable Map<Pair<String, ClassLoader>, IconLoader.CachedImageIcon> cache2) {
            Icon icon2;
            Object object;
            Pair<String, ClassLoader> path2;
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)originalClassLoader, (String)"originalClassLoader");
            long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
            String originalPath2 = this.normalizePath(originalPath);
            Pair<String, ClassLoader> patched = IconLoader.patchPath(originalPath2, originalClassLoader);
            Pair<String, ClassLoader> pair = patched;
            if (pair == null || (pair = (String)pair.first) == null) {
                pair = path2 = originalPath2;
            }
            if ((object = patched) == null || (object = (ClassLoader)((Pair)object).second) == null) {
                object = originalClassLoader;
            }
            Object classLoader = object;
            Icon icon3 = IconLoader.isReflectivePath((String)((Object)path2)) ? IconLoader.getReflectiveIcon((String)((Object)path2), (ClassLoader)classLoader) : (icon2 = cache2 == null ? (Icon)this.createIcon(originalPath2, originalClassLoader, patched, (String)((Object)path2), (ClassLoader)classLoader) : (Icon)cache2.computeIfAbsent(new Pair<String, ClassLoader>(originalPath2, originalClassLoader), new Function(patched, (String)((Object)path2), (ClassLoader)classLoader){
                final /* synthetic */ Pair $patched;
                final /* synthetic */ String $path;
                final /* synthetic */ ClassLoader $classLoader;

                @NotNull
                public final IconLoader.CachedImageIcon apply(@NotNull Pair<String, ClassLoader> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    A a = it.first;
                    Intrinsics.checkNotNullExpressionValue(a, (String)"it.first");
                    String string2 = (String)a;
                    B b = it.second;
                    Intrinsics.checkNotNullExpressionValue(b, (String)"it.second");
                    return com.intellij.openapi.ui.ImageDataByPathLoader$Companion.access$createIcon(ImageDataByPathLoader.Companion, string2, (ClassLoader)b, this.$patched, this.$path, this.$classLoader);
                }
                {
                    this.$patched = pair;
                    this.$path = string2;
                    this.$classLoader = classLoader;
                }
            }));
            if (startTime != -1L) {
                IconLoadMeasurer.findIcon.end(startTime);
            }
            return icon2;
        }

        private final IconLoader.CachedImageIcon createIcon(String originalPath, ClassLoader originalClassLoader, Pair<String, ClassLoader> patched, String path2, ClassLoader classLoader) {
            ImageDataByPathLoader loader = new ImageDataByPathLoader(originalPath, originalClassLoader, null, null);
            ImageDataByPathLoader resolver = patched == null ? loader : new ImageDataByPathLoader(path2, classLoader, loader, null);
            return new IconLoader.CachedImageIcon(null, resolver, null, null);
        }

        private final String normalizePath(String patchedPath) {
            String string2;
            if (patchedPath.charAt(0) == '/') {
                String string3 = patchedPath;
                int n = 1;
                String string4 = string3.substring(n);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string2 = patchedPath;
            }
            return string2;
        }

        private final ImageDataLoader doPatch(ImageDataByPathLoader originalLoader, IconTransform transform2, boolean isOriginal) {
            ImageDataLoader imageDataLoader;
            ClassLoader classLoader;
            Pair<String, ClassLoader> pair = transform2.patchPath(originalLoader.getPath(), originalLoader.getClassLoader());
            if (pair == null) {
                return isOriginal ? null : (ImageDataLoader)originalLoader;
            }
            Intrinsics.checkNotNullExpressionValue(pair, (String)"transform.patchPath(orig\u2026 null else originalLoader");
            Pair<String, ClassLoader> patched = pair;
            if (patched.second == null) {
                classLoader = originalLoader.getClassLoader();
            } else {
                Object b = patched.second;
                Intrinsics.checkNotNull(b);
                classLoader = (ClassLoader)b;
            }
            ClassLoader classLoader2 = classLoader;
            Object a = patched.first;
            Intrinsics.checkNotNullExpressionValue(a, (String)"patched.first");
            if (StringsKt.startsWith$default((String)((String)a), (String)"file:/", (boolean)false, (int)2, null)) {
                imageDataLoader = new ImageDataByUrlLoader(new URL((String)patched.first), (String)patched.first, classLoader2, false);
            } else {
                Object a2 = patched.first;
                Intrinsics.checkNotNullExpressionValue(a2, (String)"patched.first");
                imageDataLoader = new ImageDataByPathLoader(this.normalizePath((String)a2), classLoader2, originalLoader, null);
            }
            return imageDataLoader;
        }

        private Companion() {
        }

        public static final /* synthetic */ IconLoader.CachedImageIcon access$createIcon(Companion $this, String originalPath, ClassLoader originalClassLoader, Pair patched, String path2, ClassLoader classLoader) {
            return $this.createIcon(originalPath, originalClassLoader, patched, path2, classLoader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

