/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeleteProvider
implements DeleteProvider,
TitledHandler {
    public static ModuleDeleteProvider getInstance() {
        return ApplicationManager.getApplication().getService(ModuleDeleteProvider.class);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(1);
        }
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        List unloadedModules = (List)ProjectView.UNLOADED_MODULES_CONTEXT_KEY.getData(dataContext);
        return modules2 != null && !ModuleDeleteProvider.containsPrimaryModule(modules2) || unloadedModules != null && !unloadedModules.isEmpty();
    }

    private static boolean containsPrimaryModule(Module[] modules2) {
        if (!ProjectAttachProcessor.canAttachToProject()) {
            return !PlatformUtils.isIntelliJ();
        }
        for (Module module : modules2) {
            Path ideaDir;
            String moduleFile = module.getModuleFilePath();
            Project project2 = module.getProject();
            if (!ProjectKt.isDirectoryBased(project2) || (ideaDir = ProjectKt.getStateStore(project2).getDirectoryStorePath()) == null || !PathUtilRt.getParentPath(moduleFile).equals(FileUtil.toSystemIndependentName(ideaDir.toString()))) continue;
            return true;
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        List unloadedModules;
        if (dataContext == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(2);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project2 != null);
        ArrayList<LoadedModuleDescriptionImpl> moduleDescriptions = new ArrayList<LoadedModuleDescriptionImpl>();
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules2 != null) {
            moduleDescriptions.addAll(ContainerUtil.map(modules2, LoadedModuleDescriptionImpl::new));
        }
        if ((unloadedModules = (List)ProjectView.UNLOADED_MODULES_CONTEXT_KEY.getData(dataContext)) != null) {
            moduleDescriptions.addAll(unloadedModules);
        }
        String names = StringUtil.join(moduleDescriptions, description -> "'" + description.getName() + "'", ", ");
        String dialogTitle = StringUtil.trimEnd(this.getActionTitle(), "...");
        int ret = Messages.showOkCancelDialog((String)this.getConfirmationText(names, moduleDescriptions.size()), (String)dialogTitle, (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            Runnable action2 = () -> ModuleDeleteProvider.detachModules(project2, moduleDescriptions, modules2, unloadedModules);
            ApplicationManager.getApplication().runWriteAction(action2);
        }, ProjectBundle.message((String)"module.remove.command", (Object[])new Object[0]), null);
    }

    public static void detachModules(@NotNull Project project2, @NotNull List<ModuleDescription> moduleDescriptions, Module @Nullable [] modules2, @Nullable List<UnloadedModuleDescription> unloadedModules) {
        if (project2 == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(3);
        }
        if (moduleDescriptions == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(4);
        }
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        Module[] currentModules = moduleManager.getModules();
        ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
        HashMap<Module, ModifiableRootModel> otherModuleRootModels = new HashMap<Module, ModifiableRootModel>();
        Set<String> moduleNamesToDelete = moduleDescriptions.stream().map(ModuleDescription::getName).collect(Collectors.toSet());
        for (Module otherModule : currentModules) {
            if (moduleNamesToDelete.contains(otherModule.getName())) continue;
            otherModuleRootModels.put(otherModule, ModuleRootManager.getInstance(otherModule).getModifiableModel());
        }
        ModuleDeleteProvider.removeDependenciesOnModules(moduleNamesToDelete, otherModuleRootModels.values());
        if (modules2 != null) {
            for (Module module : modules2) {
                for (ProjectAttachProcessor processor : ProjectAttachProcessor.EP_NAME.getExtensionList()) {
                    processor.beforeDetach(module);
                }
                modifiableModuleModel.disposeModule(module);
            }
        }
        ModifiableRootModel[] modifiableRootModels = otherModuleRootModels.values().toArray(new ModifiableRootModel[0]);
        ModifiableModelCommitter.multiCommit(modifiableRootModels, modifiableModuleModel);
        if (unloadedModules != null) {
            moduleManager.removeUnloadedModules(unloadedModules);
        }
    }

    @NlsContexts.DialogMessage
    protected String getConfirmationText(String names, int numberOfModules) {
        if (ProjectAttachProcessor.canAttachToProject()) {
            return ProjectBundle.message((String)"project.remove.confirmation.prompt", (Object[])new Object[]{names, numberOfModules});
        }
        return ProjectBundle.message((String)"module.remove.confirmation.prompt", (Object[])new Object[]{names, numberOfModules});
    }

    @Override
    public String getActionTitle() {
        return ProjectAttachProcessor.canAttachToProject() ? ProjectBundle.message((String)"action.text.remove.from.project.view", (Object[])new Object[0]) : ProjectBundle.message((String)"action.text.remove.module", (Object[])new Object[0]);
    }

    public static void removeModule(@NotNull Module moduleToRemove, @NotNull Collection<? extends ModifiableRootModel> otherModuleRootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (moduleToRemove == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(5);
        }
        if (otherModuleRootModels == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(6);
        }
        if (moduleModel == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(7);
        }
        ModuleDeleteProvider.removeDependenciesOnModules(Collections.singleton(moduleToRemove.getName()), otherModuleRootModels);
        moduleModel.disposeModule(moduleToRemove);
    }

    private static void removeDependenciesOnModules(@NotNull Set<String> moduleNamesToRemove, @NotNull Collection<? extends ModifiableRootModel> otherModuleRootModels) {
        if (moduleNamesToRemove == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(8);
        }
        if (otherModuleRootModels == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(9);
        }
        for (ModifiableRootModel modifiableRootModel : otherModuleRootModels) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = modifiableRootModel.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !moduleNamesToRemove.contains(((ModuleOrderEntry)orderEntry).getModuleName())) continue;
                modifiableRootModel.removeOrderEntry(orderEntry);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleToRemove";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherModuleRootModels";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNamesToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detachModules";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeModule";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDependenciesOnModules";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

