/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.SdkAppearanceService;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.Producer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkListPresenter
extends ColoredListCellRenderer<SdkListItem> {
    private static final Icon EMPTY_ICON = EmptyIcon.create(1, 16);
    @NotNull
    private final Producer<SdkListModel> myGetModel;

    public SdkListPresenter(@NotNull Producer<SdkListModel> getSdkListModel) {
        if (getSdkListModel == null) {
            SdkListPresenter.$$$reportNull$$$0(0);
        }
        this.myGetModel = getSdkListModel;
    }

    @NotNull
    public <T> ListCellRenderer<T> forType(final @NotNull Function<? super T, ? extends SdkListItem> unwrap) {
        if (unwrap == null) {
            SdkListPresenter.$$$reportNull$$$0(1);
        }
        return new ListCellRenderer<T>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends T> list2, @Nullable T value, int index, boolean selected, boolean focused) {
                SdkListItem item = value == null ? null : (SdkListItem)unwrap.fun(value);
                JList cast = list2;
                return SdkListPresenter.this.getListCellRendererComponent(cast, item, index, selected, focused);
            }
        };
    }

    public Component getListCellRendererComponent(@NotNull JList<? extends SdkListItem> list2, @Nullable SdkListItem value, int index, boolean selected, boolean hasFocus) {
        String separatorTextAbove;
        if (list2 == null) {
            SdkListPresenter.$$$reportNull$$$0(2);
        }
        final SimpleColoredComponent component2 = (SimpleColoredComponent)super.getListCellRendererComponent(list2, (Object)value, index, selected, hasFocus);
        CellRendererPanel panel2 = new CellRendererPanel(new BorderLayout()){
            private final AccessibleContext myContext;
            {
                super(arg0);
                this.myContext = component2.getAccessibleContext();
            }

            public AccessibleContext getAccessibleContext() {
                return this.myContext;
            }

            public void setBorder(Border border) {
                component2.setBorder(border);
            }
        };
        panel2.add((Component)component2, "Center");
        SdkListModel model2 = this.myGetModel.produce();
        if (index == -1) {
            component2.setOpaque(false);
            panel2.setOpaque(false);
            if (model2.isSearching()) {
                JBLabel progressIcon = new JBLabel((Icon)AnimatedIcon.Default.INSTANCE);
                panel2.add((Component)progressIcon, "East");
            }
            return panel2;
        }
        component2.setOpaque(true);
        panel2.setOpaque(true);
        panel2.setBackground(list2.getBackground());
        if (value instanceof SdkListItem.GroupItem) {
            JBLabel toggle = new JBLabel(selected ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow);
            toggle.setOpaque(true);
            toggle.setBorder((Border)JBUI.Borders.emptyRight(JBUI.scale(5)));
            toggle.setBackground(selected ? list2.getSelectionBackground() : list2.getBackground());
            panel2.add((Component)toggle, "East");
        }
        String string2 = separatorTextAbove = value != null ? model2.getSeparatorTextAbove(value) : null;
        if (separatorTextAbove != null) {
            SeparatorWithText separator = new SeparatorWithText();
            if (!separatorTextAbove.isEmpty()) {
                separator.setCaption(separatorTextAbove);
            }
            OpaquePanel wrapper2 = new OpaquePanel((LayoutManager)new BorderLayout());
            wrapper2.add((Component)separator, (Object)"Center");
            wrapper2.setBackground(list2.getBackground());
            panel2.add((Component)wrapper2, "North");
        }
        return panel2;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends SdkListItem> list2, @Nullable SdkListItem value, int index, boolean selected, boolean hasFocus) {
        if (list2 == null) {
            SdkListPresenter.$$$reportNull$$$0(3);
        }
        this.setIcon(EMPTY_ICON);
        this.getAccessibleContext().setAccessibleName(null);
        if (value instanceof SdkListItem.InvalidSdkItem) {
            SdkListItem.InvalidSdkItem item = (SdkListItem.InvalidSdkItem)value;
            String str = ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{item.sdkName});
            this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (value instanceof SdkListItem.ProjectSdkItem) {
            Sdk sdk2 = this.myGetModel.produce().resolveProjectSdk();
            if (sdk2 != null) {
                this.setIcon(((SdkType)sdk2.getSdkType()).getIcon());
                this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(" ");
                this.append(sdk2.getName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                this.append(ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else if (value instanceof SdkListItem.SuggestedItem) {
            SdkListItem.SuggestedItem item = (SdkListItem.SuggestedItem)value;
            SdkType type = item.sdkType;
            String home2 = item.homePath;
            String version = item.version;
            Icon icon2 = type.getIcon();
            if (icon2 == null) {
                icon2 = IconUtil.getAddIcon();
            }
            this.setIcon(icon2);
            this.append(SdkListPresenter.presentDetectedSdkPath(home2));
            this.append(" ");
            this.append(version, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (value instanceof SdkListItem.ActionItem) {
            SdkListItem.ActionItem item = (SdkListItem.ActionItem)value;
            Presentation template = item.action.getTemplatePresentation();
            SdkType sdkType = item.action.getSdkType();
            if (item.group != null) {
                switch (item.role) {
                    case ADD: {
                        Icon icon3 = sdkType.getIcon();
                        if (icon3 == null) {
                            icon3 = AllIcons.General.Add;
                        }
                        this.setIcon(icon3);
                        break;
                    }
                    case DOWNLOAD: {
                        this.setIcon(template.getIcon());
                    }
                }
                this.append(item.action.getListSubItemText());
            } else {
                this.setIcon(template.getIcon());
                this.append(item.action.getListItemText());
            }
        } else if (value instanceof SdkListItem.GroupItem) {
            SdkListItem.GroupItem item = (SdkListItem.GroupItem)value;
            this.setIcon(item.icon);
            this.append(item.caption);
        } else if (value instanceof SdkListItem.SdkItem) {
            Sdk sdk3 = ((SdkListItem.SdkItem)value).sdk;
            SdkAppearanceService.getInstance().forSdk(sdk3, false, selected, false).customize((SimpleColoredComponent)this);
            String version = sdk3.getVersionString();
            if (version == null) {
                version = ((SdkType)sdk3.getSdkType()).getPresentableName();
            }
            this.append(" ");
            this.append(version, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (value instanceof SdkListItem.NoneSdkItem) {
            SdkAppearanceService.getInstance().forNullSdk(selected).customize((SimpleColoredComponent)this);
            this.getAccessibleContext().setAccessibleName(ProjectBundle.message((String)"jdk.combo.box.no.sdk.item.accessibility", (Object[])new Object[0]));
            this.setIcon(null);
        } else if (value instanceof SdkListItem.SdkReferenceItem) {
            SdkListItem.SdkReferenceItem item = (SdkListItem.SdkReferenceItem)value;
            SdkAppearanceService.getInstance().forSdk((SdkTypeId)item.sdkType, item.name, null, item.hasValidPath, false, selected).customize((SimpleColoredComponent)this);
            String version = item.versionString;
            if (version == null) {
                version = item.sdkType.getPresentableName();
            }
            this.append(" ");
            this.append(version, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            SdkAppearanceService.getInstance().forNullSdk(selected).customize((SimpleColoredComponent)this);
        }
    }

    @NotNull
    @NlsSafe
    public static String presentDetectedSdkPath(@NotNull String home2) {
        if (home2 == null) {
            SdkListPresenter.$$$reportNull$$$0(4);
        }
        return SdkListPresenter.presentDetectedSdkPath(home2, 50, 30);
    }

    @NlsSafe
    @NotNull
    public static String presentDetectedSdkPath(@NotNull String home2, int maxLength, int suffixLength) {
        if (home2 == null) {
            SdkListPresenter.$$$reportNull$$$0(5);
        }
        home2 = StringUtil.trimEnd(home2, "/Contents/Home");
        home2 = StringUtil.trimEnd(home2, "/Contents/MacOS");
        home2 = FileUtil.getLocationRelativeToUserHome(home2, false);
        String string2 = home2 = StringUtil.shortenTextWithEllipsis(home2, maxLength, suffixLength);
        if (string2 == null) {
            SdkListPresenter.$$$reportNull$$$0(6);
        }
        return string2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSdkListPresenter(super.getAccessibleContext());
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getSdkListModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unwrap";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListPresenter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "presentDetectedSdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getListCellRendererComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "presentDetectedSdkPath";
                break;
            }
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AccessibleSdkListPresenter
    extends AccessibleContextDelegate {
        @Nls
        private String myAccessibleString = null;

        AccessibleSdkListPresenter(AccessibleContext context2) {
            super(context2);
        }

        @Override
        protected Container getDelegateParent() {
            return null;
        }

        @Override
        public String getAccessibleName() {
            return this.myAccessibleString == null ? super.getDelegate().getAccessibleName() : this.myAccessibleString;
        }

        @Override
        public void setAccessibleName(String s) {
            this.myAccessibleString = s;
        }
    }
}

