/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance(ProjectFileIndexImpl.class);
    private final Project myProject;

    public ProjectFileIndexImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(0);
        }
        super(DirectoryIndex.getInstance(project2));
        this.myProject = project2;
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter2) {
        Module[] modules2;
        if (processor == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(1);
        }
        for (Module module : modules2 = ReadAction.compute(() -> ModuleManager.getInstance(this.myProject).getModules())) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module)) {
                if (this.iterateContentUnderDirectory(contentRoot, processor, filter2)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<VirtualFile> getRootsToIterate(@NotNull Module module) {
        if (module == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(2);
        }
        Set set2 = ReadAction.compute(() -> {
            if (module.isDisposed()) {
                return Collections.emptySet();
            }
            ModuleFileIndexImpl moduleFileIndex = (ModuleFileIndexImpl)ModuleRootManager.getInstance(module).getFileIndex();
            Set<VirtualFile> result2 = moduleFileIndex.getModuleRootsToIterate();
            Iterator<VirtualFile> iterator = result2.iterator();
            while (iterator.hasNext()) {
                VirtualFile root = iterator.next();
                DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                if (!module.equals(info.getModule())) {
                    iterator.remove();
                    continue;
                }
                VirtualFile parent = root.getParent();
                if (parent == null || !this.isInContent(parent)) continue;
                iterator.remove();
            }
            return result2;
        });
        if (set2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(4);
        }
        return (info = this.getInfoForFileOrDirectory(file2)).isIgnored() || info.isExcluded(file2);
    }

    @Override
    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(5);
        }
        return this.getInfoForFileOrDirectory(file2).isIgnored();
    }

    @Override
    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(6);
        }
        return this.getModuleForFile(file2, true);
    }

    @Override
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        DirectoryInfo info;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(7);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        if ((info = this.getInfoForFileOrDirectory(file2 = BackedVirtualFile.getOriginFileIfBacked(file2))).isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getModule();
        }
        return null;
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(8);
        }
        List<OrderEntry> list2 = this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(file2));
        if (list2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    public VirtualFile getClassRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(10);
        }
        return ProjectFileIndexImpl.getClassRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Nullable
    public static VirtualFile getClassRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(11);
        }
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(12);
        }
        return info.isInProject(file2) ? info.getLibraryClassRoot() : null;
    }

    @Override
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(13);
        }
        return ProjectFileIndexImpl.getSourceRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Nullable
    public static VirtualFile getSourceRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(14);
        }
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(15);
        }
        return info.isInProject(file2) ? info.getSourceRoot() : null;
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(16);
        }
        return this.getContentRootForFile(file2, true);
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(17);
        }
        return ProjectFileIndexImpl.getContentRootForFile(this.getInfoForFileOrDirectory(file2), file2, honorExclusion);
    }

    @Nullable
    public static VirtualFile getContentRootForFile(@NotNull DirectoryInfo info, @NotNull VirtualFile file2, boolean honorExclusion) {
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(19);
        }
        if (info.isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getContentRoot();
        }
        return null;
    }

    @Override
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(20);
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myDirectoryIndex.getPackageName(dir);
    }

    @Override
    public boolean isLibraryClassFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(21);
        }
        if (file2.isDirectory()) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file2);
        return parentInfo.isInProject(file2) && parentInfo.hasLibraryClassRoot();
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(22);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) || info.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(23);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.hasLibraryClassRoot();
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(24);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(25);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && (info.hasLibraryClassRoot() || info.isInLibrarySource(fileOrDir));
    }

    @Override
    public boolean isIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(26);
        }
        return this.isExcluded(file2);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(27);
        }
        return ProjectFileIndexImpl.isFileInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    public static boolean isFileInContent(@NotNull VirtualFile fileOrDir, @NotNull DirectoryInfo info) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(28);
        }
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(29);
        }
        return info.isInProject(fileOrDir) && info.getModule() != null;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(30);
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource(fileOrDir);
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(31);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.isTestSourcesRoot(info);
    }

    @Override
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(32);
        }
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(33);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    @Nullable
    public SourceFolder getSourceFolder(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(34);
        }
        return this.myDirectoryIndex.getSourceRootFolder(this.getInfoForFileOrDirectory(fileOrDir));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myProject.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToIterate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToIterate";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnderIgnored";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassRootForFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootForFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryClassFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInSource";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isFileInContent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolder";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

