/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.util.indexing.roots.kind.SdkOrigin;
import com.intellij.util.indexing.roots.kind.SyntheticLibraryOrigin;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FilesScanExecutor {
    private static final Logger LOG = Logger.getInstance(FilesScanExecutor.class);
    private static final int THREAD_COUNT = Math.max(UnindexedFilesUpdater.getNumberOfScanningThreads() - 1, 1);
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor("Scanning", THREAD_COUNT);

    public static void runOnAllThreads(@NotNull Runnable runnable) {
        if (runnable == null) {
            FilesScanExecutor.$$$reportNull$$$0(0);
        }
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ArrayList results = new ArrayList();
        for (int i = 0; i < THREAD_COUNT; ++i) {
            results.add(ourExecutor.submit(() -> ProgressManager.getInstance().runProcess(runnable, (ProgressIndicator)ProgressWrapper.wrap(progress))));
        }
        runnable.run();
        for (Future future2 : results) {
            ((FutureTask)future2).run();
            ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future2);
        }
    }

    public static <T> boolean processOnAllThreadsInReadActionWithRetries(@NotNull ConcurrentLinkedDeque<T> deque, @NotNull Processor<? super T> consumer) {
        if (deque == null) {
            FilesScanExecutor.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            FilesScanExecutor.$$$reportNull$$$0(2);
        }
        return FilesScanExecutor.doProcessOnAllThreadsInReadAction(deque, consumer, true);
    }

    public static <T> boolean processOnAllThreadsInReadActionNoRetries(@NotNull ConcurrentLinkedDeque<T> deque, @NotNull Processor<? super T> consumer) {
        if (deque == null) {
            FilesScanExecutor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            FilesScanExecutor.$$$reportNull$$$0(4);
        }
        return FilesScanExecutor.doProcessOnAllThreadsInReadAction(deque, consumer, false);
    }

    private static <T> boolean doProcessOnAllThreadsInReadAction(@NotNull ConcurrentLinkedDeque<T> deque, @NotNull Processor<? super T> consumer, boolean retryCanceled) {
        if (deque == null) {
            FilesScanExecutor.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            FilesScanExecutor.$$$reportNull$$$0(6);
        }
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        return FilesScanExecutor.processOnAllThreads(deque, o -> {
            ProgressIndicator indicator;
            if (application.isReadAccessAllowed()) {
                return consumer.process(o);
            }
            Ref<Boolean> result2 = Ref.create(true);
            if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> result2.set(consumer.process(o)), (ProgressIndicator)((indicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) == null ? null : new SensitiveProgressWrapper(indicator)))) {
                throw retryCanceled ? new ProcessCanceledException() : new StopWorker();
            }
            return result2.get();
        });
    }

    public static <T> boolean processOnAllThreads(@NotNull ConcurrentLinkedDeque<T> deque, @NotNull Processor<? super T> processor) {
        if (deque == null) {
            FilesScanExecutor.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            FilesScanExecutor.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        if (deque.isEmpty()) {
            return true;
        }
        AtomicInteger runnersCount = new AtomicInteger();
        AtomicInteger idleCount = new AtomicInteger();
        AtomicReference error = new AtomicReference();
        AtomicBoolean stopped = new AtomicBoolean();
        AtomicBoolean exited = new AtomicBoolean();
        FilesScanExecutor.runOnAllThreads(() -> {
            runnersCount.incrementAndGet();
            boolean idle = false;
            while (!stopped.get()) {
                ProgressManager.checkCanceled();
                if (deque.peek() == null) {
                    if (!idle) {
                        idle = true;
                        idleCount.incrementAndGet();
                    }
                } else if (idle) {
                    idle = false;
                    idleCount.decrementAndGet();
                }
                if (idle) {
                    if (idleCount.get() == runnersCount.get() && deque.isEmpty()) break;
                    TimeoutUtil.sleep(1L);
                    continue;
                }
                Object item = deque.poll();
                if (item == null) continue;
                try {
                    if (!processor.process((Object)item)) {
                        stopped.set(true);
                    }
                    if (exited.get() && !stopped.get()) {
                        throw new AssertionError((Object)"early exit");
                    }
                }
                catch (StopWorker ex) {
                    deque.addFirst(item);
                    runnersCount.decrementAndGet();
                    return;
                }
                catch (ProcessCanceledException ex) {
                    deque.addFirst(item);
                }
                catch (Throwable ex) {
                    error.compareAndSet(null, ex);
                }
            }
            exited.set(true);
            if (!deque.isEmpty() && !stopped.get()) {
                throw new AssertionError((Object)"early exit");
            }
        });
        ExceptionUtil.rethrowAllAsUnchecked((Throwable)error.get());
        return !stopped.get();
    }

    private static boolean isLibOrigin(@NotNull IndexableSetOrigin origin) {
        if (origin == null) {
            FilesScanExecutor.$$$reportNull$$$0(9);
        }
        return origin instanceof LibraryOrigin || origin instanceof SyntheticLibraryOrigin || origin instanceof SdkOrigin;
    }

    public static boolean processFilesInScope(boolean includingBinary, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Processor<? super VirtualFile> processor) {
        if (scope == null) {
            FilesScanExecutor.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            FilesScanExecutor.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = scope.getProject();
        if (project2 == null) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        boolean searchInLibs = scope.isSearchInLibraries();
        ConcurrentLinkedDeque deque = new ConcurrentLinkedDeque();
        ModelBranchImpl.processModifiedFilesInScope(scope, deque::add);
        if (scope instanceof VirtualFileEnumeration) {
            ContainerUtil.addAll(deque, FileBasedIndexEx.toFileIterable((int[])((VirtualFileEnumeration)((Object)scope)).asArray()));
        } else {
            deque.addAll(((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndexableFilesProviders(project2));
        }
        AtomicInteger skippedCount = new AtomicInteger();
        AtomicInteger processedCount = new AtomicInteger();
        ConcurrentBitSet visitedFiles = ConcurrentBitSet.create();
        VirtualFileFilter fileFilter = file2 -> {
            boolean result2;
            int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
            if (visitedFiles.set(fileId)) {
                return false;
            }
            boolean bl = result2 = !(idFilter != null && !idFilter.containsFileId(fileId) || fileIndex.isExcluded(file2) || !scope.contains(file2) || !includingBinary && !file2.isDirectory() && file2.getFileType().isBinary());
            if (!result2) {
                skippedCount.incrementAndGet();
            }
            return result2;
        };
        Processor<Object> consumer = obj -> {
            ProgressManager.checkCanceled();
            if (obj instanceof IndexableFilesIterator) {
                IndexableSetOrigin origin = ((IndexableFilesIterator)obj).getOrigin();
                if (!searchInLibs && FilesScanExecutor.isLibOrigin(origin)) {
                    return true;
                }
            } else {
                if (obj instanceof VirtualFile) {
                    VirtualFile file3 = (VirtualFile)obj;
                    processedCount.incrementAndGet();
                    if (!file3.isValid()) {
                        return true;
                    }
                    return processor.process(file3);
                }
                throw new AssertionError((Object)("unknown item: " + obj));
            }
            ((IndexableFilesIterator)obj).iterateFiles(project2, file2 -> {
                if (file2.isDirectory()) {
                    return true;
                }
                deque.add(file2);
                return true;
            }, fileFilter);
            return true;
        };
        long start2 = System.nanoTime();
        boolean result2 = FilesScanExecutor.processOnAllThreadsInReadActionNoRetries(deque, consumer);
        if (LOG.isDebugEnabled()) {
            LOG.debug(processedCount.get() + " files processed (" + skippedCount.get() + " skipped) in " + TimeoutUtil.getDurationMillis(start2) + " ms");
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deque";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/FilesScanExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runOnAllThreads";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processOnAllThreadsInReadActionWithRetries";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processOnAllThreadsInReadActionNoRetries";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doProcessOnAllThreadsInReadAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processOnAllThreads";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isLibOrigin";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processFilesInScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StopWorker
    extends ProcessCanceledException {
        private StopWorker() {
        }
    }
}

