/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListenerHelper;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexImpl;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.roots.AdditionalLibraryRootsContributor;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdditionalLibraryRootsListenerHelperImpl
implements AdditionalLibraryRootsListenerHelper {
    @Override
    public void handleAdditionalLibraryRootsChanged(@NotNull Project project2, @Nls @Nullable String presentableLibraryName, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, @NotNull String libraryNameForDebug) {
        DirectoryIndex directoryIndex;
        if (project2 == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(0);
        }
        if (oldRoots == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(1);
        }
        if (newRoots == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(2);
        }
        if (libraryNameForDebug == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(3);
        }
        if ((directoryIndex = DirectoryIndex.getInstance(project2)) instanceof DirectoryIndexImpl) {
            ((DirectoryIndexImpl)directoryIndex).reset();
        }
        AdditionalLibraryRootsListenerHelperImpl.additionalLibraryRootsChanged(project2, presentableLibraryName, oldRoots, newRoots, libraryNameForDebug);
    }

    private static void additionalLibraryRootsChanged(@NotNull Project project2, @Nls @Nullable String presentableLibraryName, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, @NotNull String libraryNameForDebug) {
        if (project2 == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(4);
        }
        if (oldRoots == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(5);
        }
        if (newRoots == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(6);
        }
        if (libraryNameForDebug == null) {
            AdditionalLibraryRootsListenerHelperImpl.$$$reportNull$$$0(7);
        }
        if (!(FileBasedIndex.getInstance() instanceof FileBasedIndexImpl)) {
            return;
        }
        ArrayList<VirtualFile> rootsToIndex = new ArrayList<VirtualFile>(newRoots.size());
        for (VirtualFile virtualFile2 : newRoots) {
            boolean shouldIndex = true;
            for (VirtualFile virtualFile3 : oldRoots) {
                if (!VfsUtilCore.isAncestor(virtualFile3, virtualFile2, false)) continue;
                shouldIndex = false;
                break;
            }
            if (!shouldIndex) continue;
            rootsToIndex.add(virtualFile2);
        }
        if (rootsToIndex.isEmpty()) {
            return;
        }
        List<IndexableFilesIterator> indexableFilesIterators = Collections.singletonList(AdditionalLibraryRootsContributor.createIndexingIterator(presentableLibraryName, rootsToIndex, libraryNameForDebug));
        new UnindexedFilesUpdater(project2, indexableFilesIterators, "On updated roots of library '" + presentableLibraryName + "'").queue(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoots";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoots";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryNameForDebug";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/AdditionalLibraryRootsListenerHelperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleAdditionalLibraryRootsChanged";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "additionalLibraryRootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

