/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.projectModel.ProjectModelBundle;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum DependencyScope {
    COMPILE(ProjectModelBundle.messagePointer("dependency.scope.compile", new Object[0]), true, true, true, true),
    TEST(ProjectModelBundle.messagePointer("dependency.scope.test", new Object[0]), false, false, true, true),
    RUNTIME(ProjectModelBundle.messagePointer("dependency.scope.runtime", new Object[0]), false, true, false, true),
    PROVIDED(ProjectModelBundle.messagePointer("dependency.scope.provided", new Object[0]), true, false, true, true);

    private final @NotNull Supplier<@NlsContexts.ListItem String> myDisplayName;
    private final boolean myForProductionCompile;
    private final boolean myForProductionRuntime;
    private final boolean myForTestCompile;
    private final boolean myForTestRuntime;
    @NonNls
    public static final String SCOPE_ATTR = "scope";

    private DependencyScope(Supplier<String> displayName, boolean forProductionCompile, boolean forProductionRuntime, boolean forTestCompile, boolean forTestRuntime) {
        if (displayName == null) {
            DependencyScope.$$$reportNull$$$0(0);
        }
        this.myDisplayName = displayName;
        this.myForProductionCompile = forProductionCompile;
        this.myForProductionRuntime = forProductionRuntime;
        this.myForTestCompile = forTestCompile;
        this.myForTestRuntime = forTestRuntime;
    }

    @NotNull
    public static DependencyScope readExternal(@NotNull Element element2) {
        String scope;
        if (element2 == null) {
            DependencyScope.$$$reportNull$$$0(1);
        }
        if ((scope = element2.getAttributeValue(SCOPE_ATTR)) != null) {
            DependencyScope dependencyScope;
            try {
                dependencyScope = DependencyScope.valueOf(scope);
            }
            catch (IllegalArgumentException e) {
                DependencyScope dependencyScope2 = COMPILE;
                if (dependencyScope2 == null) {
                    DependencyScope.$$$reportNull$$$0(3);
                }
                return dependencyScope2;
            }
            if (dependencyScope == null) {
                DependencyScope.$$$reportNull$$$0(2);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = COMPILE;
        if (dependencyScope == null) {
            DependencyScope.$$$reportNull$$$0(4);
        }
        return dependencyScope;
    }

    public void writeExternal(Element element2) {
        if (this != COMPILE) {
            element2.setAttribute(SCOPE_ATTR, this.name());
        }
    }

    @NotNull
    @NlsContexts.ListItem
    public String getDisplayName() {
        String string2 = this.myDisplayName.get();
        if (string2 == null) {
            DependencyScope.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public boolean isForProductionCompile() {
        return this.myForProductionCompile;
    }

    public boolean isForProductionRuntime() {
        return this.myForProductionRuntime;
    }

    public boolean isForTestCompile() {
        return this.myForTestCompile;
    }

    public boolean isForTestRuntime() {
        return this.myForTestRuntime;
    }

    @NlsContexts.ListItem
    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/DependencyScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/DependencyScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

