/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerBase;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJbrInstaller;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase;", "()V", "defaultInstallDir", "Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
public final class RuntimeChooserJbrInstaller
extends JdkInstallerBase {
    @Override
    @NotNull
    public Path defaultInstallDir() {
        Path path2;
        String explicitHome = System.getProperty("jbr.downloader.home");
        if (explicitHome != null) {
            Path path3 = Paths.get(explicitHome, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Paths.get(explicitHome)");
            return path3;
        }
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            string2 = ".";
        }
        Path home2 = Paths.get(FileUtil.toCanonicalPath(string2), new String[0]);
        if (SystemInfo.isLinux) {
            Path path4 = home2.resolve(".jbr");
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"home.resolve(\".jbr\")");
        } else if (SystemInfo.isMac) {
            Path path5 = home2.resolve("Library/Java/JetBrainsRuntime");
            path2 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"home.resolve(\"Library/Java/JetBrainsRuntime\")");
        } else if (SystemInfo.isWindows) {
            Path path6 = home2.resolve(".jbr");
            path2 = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"home.resolve(\".jbr\")");
        } else {
            String string3 = "Unsupported OS: " + SystemInfo.getOsNameAndVersion();
            throw new IllegalStateException(string3.toString());
        }
        return path2;
    }
}

