/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.Decompressor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType;", "", "type", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "openDecompressor", "Lcom/intellij/util/io/Decompressor;", "archiveFile", "Ljava/nio/file/Path;", "ZIP", "TAR_GZ", "Companion", "intellij.platform.lang.impl"})
public abstract class JdkPackageType
extends Enum<JdkPackageType> {
    public static final /* enum */ JdkPackageType ZIP;
    public static final /* enum */ JdkPackageType TAR_GZ;
    private static final /* synthetic */ JdkPackageType[] $VALUES;
    @NotNull
    private final String type;
    @NotNull
    public static final Companion Companion;

    static {
        JdkPackageType[] jdkPackageTypeArray = new JdkPackageType[2];
        JdkPackageType[] jdkPackageTypeArray2 = jdkPackageTypeArray;
        jdkPackageTypeArray[0] = ZIP = new ZIP("ZIP", 0);
        jdkPackageTypeArray[1] = TAR_GZ = new TAR_GZ("TAR_GZ", 1);
        $VALUES = jdkPackageTypeArray;
        Companion = new Companion(null);
    }

    @NotNull
    public abstract Decompressor openDecompressor(@NotNull Path var1);

    @NotNull
    public final String getType() {
        return this.type;
    }

    private JdkPackageType(String type) {
        this.type = type;
    }

    public /* synthetic */ JdkPackageType(String $enum$name, int $enum$ordinal, String type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    public static JdkPackageType[] values() {
        return (JdkPackageType[])$VALUES.clone();
    }

    public static JdkPackageType valueOf(String string2) {
        return Enum.valueOf(JdkPackageType.class, string2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType$ZIP;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType;", "openDecompressor", "Lcom/intellij/util/io/Decompressor;", "archiveFile", "Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
    static final class ZIP
    extends JdkPackageType {
        @Override
        @NotNull
        public Decompressor openDecompressor(@NotNull Path archiveFile) {
            Decompressor decompressor;
            Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
            Decompressor.Zip decompressor2 = new Decompressor.Zip(archiveFile);
            if (SystemInfo.isWindows) {
                decompressor = decompressor2;
            } else {
                Decompressor decompressor3 = decompressor2.withZipExtensions();
                decompressor = decompressor3;
                Intrinsics.checkNotNullExpressionValue((Object)decompressor3, (String)"decompressor.withZipExtensions()");
            }
            return decompressor;
        }

        /*
         * WARNING - void declaration
         */
        ZIP() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType$TAR_GZ;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType;", "openDecompressor", "Lcom/intellij/util/io/Decompressor$Tar;", "archiveFile", "Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
    static final class TAR_GZ
    extends JdkPackageType {
        @Override
        @NotNull
        public Decompressor.Tar openDecompressor(@NotNull Path archiveFile) {
            Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
            return new Decompressor.Tar(archiveFile);
        }

        /*
         * WARNING - void declaration
         */
        TAR_GZ() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType$Companion;", "", "()V", "findType", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType;", "jsonText", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @Nullable
        public final JdkPackageType findType(@NotNull String jsonText) {
            JdkPackageType jdkPackageType;
            block1: {
                Intrinsics.checkNotNullParameter((Object)jsonText, (String)"jsonText");
                JdkPackageType[] $this$firstOrNull$iv = JdkPackageType.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    JdkPackageType element$iv;
                    JdkPackageType it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getType(), (String)jsonText, (boolean)true)) continue;
                    jdkPackageType = element$iv;
                    break block1;
                }
                jdkPackageType = null;
            }
            return jdkPackageType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

