/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPackageType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkProduct;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListParser;", "", "()V", "parseJdkItem", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "item", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "filters", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "parseJdkList", "tree", "readTree", "rawData", "", "intellij.platform.lang.impl"})
public final class JdkListParser {
    @NotNull
    public static final JdkListParser INSTANCE;

    @NotNull
    public final ObjectNode readTree(@NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        if (!(jsonNode instanceof ObjectNode)) {
            jsonNode = null;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        if (objectNode == null) {
            String string2 = "Unexpected JSON data";
            throw new IllegalStateException(string2.toString());
        }
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> parseJdkList(@NotNull ObjectNode tree, @NotNull JdkPredicate filters) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        JsonNode jsonNode = tree.get("jdks");
        if (!(jsonNode instanceof ArrayNode)) {
            jsonNode = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode == null) {
            String string2 = "`jdks` element is missing";
            throw new IllegalStateException(string2.toString());
        }
        ArrayNode items = arrayNode;
        List result2 = new ArrayList();
        Iterable $this$filterIsInstance$iv = (Iterable)items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ObjectNode item : (List)destination$iv$iv) {
            Collection collection = result2;
            Iterable iterable2 = this.parseJdkItem(item, filters);
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> parseJdkItem(@NotNull ObjectNode item, @NotNull JdkPredicate filters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ObjectNode p1;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        if (!filters.testJdkProduct(item)) {
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode = item.get("packages");
        if (!(jsonNode instanceof ArrayNode)) {
            jsonNode = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode == null) {
            return CollectionsKt.emptyList();
        }
        ArrayNode packages = arrayNode;
        Object object = item.get("vendor");
        if (object == null || (object = object.asText()) == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode2 = item.get("product");
        JsonNode jsonNode3 = item.get("flavour");
        JdkProduct product = new JdkProduct((String)object, jsonNode2 != null ? jsonNode2.asText() : null, jsonNode3 != null ? jsonNode3.asText() : null);
        byte[] contents = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)item);
        Iterable $this$filterIsInstance$iv = (Iterable)packages;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p1 = (ObjectNode)element$iv$iv;
            boolean bl = false;
            if (!filters.testJdkPackage(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2;
            Object object2;
            JdkPackageType jdkPackageType;
            void p12;
            int n;
            Object object3;
            String string2;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            void pkg;
            Object object10;
            String string3;
            Object object11;
            int n2;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            JdkProduct jdkProduct;
            Object object12;
            Object object13;
            JdkProduct jdkProduct2;
            Collection collection;
            block33: {
                block32: {
                    Object it;
                    p1 = (ObjectNode)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    jdkProduct2 = product;
                    JsonNode jsonNode4 = item.get("default");
                    if (jsonNode4 != null) {
                        object12 = object13 = jsonNode4;
                        jdkProduct = jdkProduct2;
                        boolean bl6 = false;
                        bl4 = Intrinsics.areEqual((Object)filters.testPredicate((JsonNode)it), (Object)true);
                        jdkProduct2 = jdkProduct;
                        bl3 = bl4;
                    } else {
                        bl3 = false;
                    }
                    JsonNode jsonNode5 = item.get("listed");
                    if (jsonNode5 != null) {
                        object13 = jsonNode5;
                        it = object13;
                        bl4 = bl3;
                        jdkProduct = jdkProduct2;
                        boolean bl7 = false;
                        bl2 = Intrinsics.areEqual((Object)filters.testPredicate((JsonNode)it), (Object)true);
                        jdkProduct2 = jdkProduct;
                        bl3 = bl4;
                        bl = bl2;
                    } else {
                        bl = true;
                    }
                    JsonNode jsonNode6 = item.get("jdk_version_major");
                    if (jsonNode6 == null) {
                        return CollectionsKt.emptyList();
                    }
                    n2 = jsonNode6.asInt();
                    object11 = item.get("jdk_version");
                    if (object11 == null || (object11 = object11.asText()) == null) {
                        return CollectionsKt.emptyList();
                    }
                    JsonNode jsonNode7 = item.get("jdk_vendor_version");
                    string3 = jsonNode7 != null ? jsonNode7.asText() : null;
                    object10 = item.get("suggested_sdk_name");
                    if (object10 == null || (object10 = object10.asText()) == null) {
                        return CollectionsKt.emptyList();
                    }
                    object9 = pkg.get("os");
                    if (object9 == null || (object9 = object9.asText()) == null) {
                        return CollectionsKt.emptyList();
                    }
                    object8 = pkg.get("arch");
                    if (object8 == null || (object8 = object8.asText()) == null) {
                        return CollectionsKt.emptyList();
                    }
                    object7 = pkg.get("package_type");
                    if (object7 == null || (object7 = object7.asText()) == null) break block32;
                    object13 = object7;
                    it = JdkPackageType.Companion;
                    JsonNode bl7 = object13;
                    object6 = object8;
                    object5 = object9;
                    object4 = object10;
                    string2 = string3;
                    object3 = object11;
                    n = n2;
                    bl2 = bl;
                    bl4 = bl3;
                    jdkProduct = jdkProduct2;
                    boolean bl8 = false;
                    jdkPackageType = ((JdkPackageType.Companion)it).findType((String)p12);
                    jdkProduct2 = jdkProduct;
                    bl3 = bl4;
                    bl = bl2;
                    n2 = n;
                    object11 = object3;
                    string3 = string2;
                    object10 = object4;
                    object9 = object5;
                    object8 = object6;
                    object7 = jdkPackageType;
                    if (object7 != null) break block33;
                }
                return CollectionsKt.emptyList();
            }
            Object object14 = pkg.get("url");
            if (object14 == null || (object14 = object14.asText()) == null) {
                return CollectionsKt.emptyList();
            }
            Object object15 = pkg.get("sha256");
            if (object15 == null || (object15 = object15.asText()) == null) {
                return CollectionsKt.emptyList();
            }
            JsonNode jsonNode8 = pkg.get("archive_size");
            if (jsonNode8 == null) {
                return CollectionsKt.emptyList();
            }
            long l = jsonNode8.asLong();
            Object object16 = pkg.get("archive_file_name");
            if (object16 == null || (object16 = object16.asText()) == null) {
                return CollectionsKt.emptyList();
            }
            Object object17 = pkg.get("package_root_prefix");
            if (object17 == null || (object17 = object17.asText()) == null) {
                return CollectionsKt.emptyList();
            }
            Object object18 = pkg.get("package_to_java_home_prefix");
            if (object18 == null || (object18 = object18.asText()) == null) {
                return CollectionsKt.emptyList();
            }
            JsonNode jsonNode9 = pkg.get("unpacked_size");
            if (jsonNode9 == null) {
                return CollectionsKt.emptyList();
            }
            long l2 = jsonNode9.asLong();
            Object object19 = pkg.get("install_folder_name");
            if (object19 == null || (object19 = object19.asText()) == null) {
                return CollectionsKt.emptyList();
            }
            JsonNode jsonNode10 = item.get("shared_index_aliases");
            if (!(jsonNode10 instanceof ArrayNode)) {
                jsonNode10 = null;
            }
            ArrayNode arrayNode2 = (ArrayNode)jsonNode10;
            if (arrayNode2 != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                object13 = (Iterable)arrayNode2;
                Object object20 = object19;
                long l3 = l2;
                Object object21 = object18;
                Object object22 = object17;
                Object object23 = object16;
                long l4 = l;
                Object object24 = object15;
                Object object25 = object14;
                jdkPackageType = object7;
                object6 = object8;
                object5 = object9;
                object4 = object10;
                string2 = string3;
                object3 = object11;
                n = n2;
                bl2 = bl;
                bl4 = bl3;
                jdkProduct = jdkProduct2;
                boolean $i$f$mapNotNull = false;
                p12 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                object2 = $this$forEach$iv$iv$iv.iterator();
                while (object2.hasNext()) {
                    String string4;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object2.next();
                    boolean bl9 = false;
                    JsonNode it = (JsonNode)element$iv$iv;
                    boolean bl10 = false;
                    if (it.asText() == null) continue;
                    String it$iv$iv = string4;
                    boolean bl11 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List list3 = (List)destination$iv$iv2;
                jdkProduct2 = jdkProduct;
                bl3 = bl4;
                bl = bl2;
                n2 = n;
                object11 = object3;
                string3 = string2;
                object10 = object4;
                object9 = object5;
                object8 = object6;
                object7 = jdkPackageType;
                object14 = object25;
                object15 = object24;
                l = l4;
                object16 = object23;
                object17 = object22;
                object18 = object21;
                l2 = l3;
                object19 = object20;
                list2 = list3;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            object13 = (Function1)new Function1<Path, Unit>(product, item, filters, contents){
                final /* synthetic */ JdkProduct $product$inlined;
                final /* synthetic */ ObjectNode $item$inlined;
                final /* synthetic */ JdkPredicate $filters$inlined;
                final /* synthetic */ byte[] $contents$inlined;
                {
                    this.$product$inlined = jdkProduct;
                    this.$item$inlined = objectNode;
                    this.$filters$inlined = jdkPredicate;
                    this.$contents$inlined = byArray;
                    super(1);
                }

                public final void invoke(@NotNull Path file2) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Intrinsics.checkNotNullExpressionValue((Object)this.$contents$inlined, (String)"contents");
                    PathKt.write$default(file2, this.$contents$inlined, 0, 0, 6, null);
                }
            };
            object12 = list2;
            Object object26 = object19;
            long l5 = l2;
            Object object27 = object18;
            Object object28 = object17;
            object2 = object16;
            Object object29 = object13;
            Object object30 = object12;
            Object object31 = object26;
            Object object32 = object2;
            Object object33 = object27;
            Object object34 = object28;
            long l6 = l5;
            long l7 = l;
            Object object35 = object15;
            Object object36 = object14;
            Object object37 = object7;
            Object object38 = object8;
            Object object39 = object9;
            Object object40 = object10;
            String string5 = string3;
            Object object41 = object11;
            int n3 = n2;
            boolean bl12 = bl;
            boolean bl13 = bl3;
            JdkProduct jdkProduct3 = jdkProduct2;
            JdkItem jdkItem = new JdkItem(jdkProduct3, bl13, bl12, n3, (String)object41, string5, (String)object40, (String)object39, (String)object38, (JdkPackageType)((Object)object37), (String)object36, (String)object35, l7, l6, (String)object34, (String)object33, (String)object32, (String)object31, (List<String>)object30, (Function1<? super Path, Unit>)object29);
            collection.add(jdkItem);
        }
        return (List)destination$iv$iv;
    }

    private JdkListParser() {
    }

    static {
        JdkListParser jdkListParser;
        INSTANCE = jdkListParser = new JdkListParser();
    }
}

