/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkStartupChecker;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "checkUnknownSdks", "", "project", "Lcom/intellij/openapi/project/Project;", "runActivity", "intellij.platform.lang.impl"})
public final class UnknownSdkStartupChecker
implements StartupActivity.DumbAware {
    @Override
    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.checkUnknownSdks(project2);
        UnknownSdkResolver.EP_NAME.addExtensionPointListener(new ExtensionPointListener<UnknownSdkResolver>(this, project2){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;

            public void extensionAdded(@NotNull UnknownSdkResolver extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void extensionRemoved(@NotNull UnknownSdkResolver extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        }, project2);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect();
        Topic<ModuleRootListener> topic = ProjectTopics.PROJECT_ROOTS;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"ProjectTopics.PROJECT_ROOTS");
        messageBusConnection.subscribe(topic, new ModuleRootListener(this){
            final /* synthetic */ UnknownSdkStartupChecker this$0;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project2 = event.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"event.project");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, project2);
            }
            {
                this.this$0 = this$0;
            }
        });
        ProjectRootManagerEx.getInstanceEx(project2).addProjectJdkListener(new ProjectRootManagerEx.ProjectJdkListener(this, project2){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;

            public final void projectJdkChanged() {
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
            {
                this.this$0 = unknownSdkStartupChecker;
                this.$project = project2;
            }
        });
        MessageBusConnection messageBusConnection2 = project2.getMessageBus().connect();
        Topic<ProjectJdkTable.Listener> topic2 = ProjectJdkTable.JDK_TABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"ProjectJdkTable.JDK_TABLE_TOPIC");
        messageBusConnection2.subscribe(topic2, new ProjectJdkTable.Listener(this, project2){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;

            public void jdkAdded(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        });
    }

    private final void checkUnknownSdks(Project project2) {
        if (project2.isDisposed() || project2.isDefault()) {
            return;
        }
        if (project2 instanceof ProjectEx) {
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)((ProjectEx)project2).getEarlyDisposable());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                return;
            }
        }
        UnknownSdkTracker.getInstance(project2).updateUnknownSdks();
    }

    public static final /* synthetic */ void access$checkUnknownSdks(UnknownSdkStartupChecker $this, Project project2) {
        $this.checkUnknownSdks(project2);
    }
}

