/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixActionBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UnknownSdkFixActionLocalBase
extends UnknownSdkFixActionBase {
    @NotNull
    protected abstract Sdk applyLocalFix();

    @NotNull
    protected abstract String getSuggestedSdkHome();

    @NotNull
    private Sdk runWithEvents() {
        Sdk sdk2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        UnknownSdkFixAction.Listener multicaster = this.getMulticaster();
        try {
            Sdk sdk3 = this.applyLocalFix();
            multicaster.onSdkNameResolved(sdk3);
            multicaster.onSdkResolved(sdk3);
            sdk2 = sdk3;
        }
        catch (Throwable t) {
            multicaster.onResolveFailed();
            throw t;
        }
        if (sdk2 == null) {
            UnknownSdkFixActionLocalBase.$$$reportNull$$$0(0);
        }
        return sdk2;
    }

    private void refreshVfs() {
        Path path2 = Paths.get(this.getSuggestedSdkHome(), new String[0]);
        VfsUtil.markDirtyAndRefresh(false, true, true, LocalFileSystem.getInstance().findFileByNioFile(path2));
    }

    @Override
    public final void applySuggestionAsync(@Nullable Project project2) {
        String title = ProjectBundle.message((String)"progress.title.downloading.sdk", (Object[])new Object[0]);
        new Task.Backgroundable(project2, title){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                block3: {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        UnknownSdkFixActionLocalBase.this.refreshVfs();
                        ApplicationManager.getApplication().invokeLater(() -> UnknownSdkFixActionLocalBase.this.runWithEvents());
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ControlFlowException)) break block3;
                        throw t;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/projectRoots/impl/UnknownSdkFixActionLocalBase$1", "run"));
            }
        }.queue();
    }

    @Override
    @NotNull
    public final Sdk applySuggestionBlocking(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnknownSdkFixActionLocalBase.$$$reportNull$$$0(1);
        }
        this.refreshVfs();
        AtomicReference<Object> sdk2 = new AtomicReference<Object>(null);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            Sdk r = this.runWithEvents();
            sdk2.set(r);
        });
        Sdk sdk3 = sdk2.get();
        if (sdk3 == null) {
            UnknownSdkFixActionLocalBase.$$$reportNull$$$0(2);
        }
        return sdk3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkFixActionLocalBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithEvents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkFixActionLocalBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "applySuggestionBlocking";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applySuggestionBlocking";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

