/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.MissingSdkInfo;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBlockingCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollectorKt;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollectorQueue;
import com.intellij.openapi.projectRoots.impl.UnknownSdkContributor;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.util.Computable;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0014J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0007\u001a\u00020\u0003H\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0014J'\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkCollector;", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkBlockingCollector;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "checkProjectSdk", "", "project", "collectModulesToCheckSdk", "", "Lcom/intellij/openapi/module/Module;", "collectSdksBlocking", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkSnapshot;", "collectSdksUnderReadAction", "getContributors", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkContributor;", "collectSdksPromise", "", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkCollectorQueue;", "lifetime", "Lcom/intellij/openapi/Disposable;", "onCompleted", "Ljava/util/function/Consumer;", "collectSdksPromise$intellij_platform_lang_impl", "Companion", "intellij.platform.lang.impl"})
public class UnknownSdkCollector
implements UnknownSdkBlockingCollector {
    private final Project myProject;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void collectSdksPromise$intellij_platform_lang_impl(@NotNull UnknownSdkCollectorQueue $this$collectSdksPromise, @NotNull Disposable lifetime, @NotNull Consumer<UnknownSdkSnapshot> onCompleted) {
        Intrinsics.checkNotNullParameter((Object)$this$collectSdksPromise, (String)"$this$collectSdksPromise");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        NonBlockingReadAction<UnknownSdkSnapshot> nonBlockingReadAction = ReadAction.nonBlocking(new Callable(this){
            final /* synthetic */ UnknownSdkCollector this$0;

            public final UnknownSdkSnapshot call() {
                return UnknownSdkCollector.access$collectSdksUnderReadAction(this.this$0);
            }
            {
                this.this$0 = unknownSdkCollector;
            }
        }).expireWith(lifetime).expireWith(this.myProject).coalesceBy(this.myProject, Reflection.getOrCreateKotlinClass(UnknownSdkCollector.class));
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        nonBlockingReadAction.finishOnUiThread(application.getDefaultModalityState(), onCompleted).submit(AppExecutorUtil.getAppExecutorService());
    }

    @Override
    @NotNull
    public UnknownSdkSnapshot collectSdksBlocking() {
        boolean $i$f$runReadAction = false;
        return (UnknownSdkSnapshot)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ UnknownSdkCollector this$0;
            {
                this.this$0 = unknownSdkCollector;
            }

            public final T compute() {
                boolean bl = false;
                return (T)UnknownSdkCollector.access$collectSdksUnderReadAction(this.this$0);
            }
        });
    }

    protected boolean checkProjectSdk(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return true;
    }

    @NotNull
    protected List<Module> collectModulesToCheckSdk(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(myProject).modules");
        return ArraysKt.toList((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final UnknownSdkSnapshot collectSdksUnderReadAction() {
        void $this$mapNotNullTo$iv$iv;
        Object jdkTypeName;
        Object moduleJdk;
        Iterator jdkEntry;
        Object moduleRootManager;
        Set knownSdks = new LinkedHashSet();
        SetMultimap sdkToTypes = MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).hashSetValues().build();
        ProgressManager.checkCanceled();
        if (this.checkProjectSdk(this.myProject)) {
            Object sdkName;
            ProjectRootManager rootManager;
            ProjectRootManager projectRootManager = rootManager = ProjectRootManager.getInstance(this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"rootManager");
            Sdk projectSdk = projectRootManager.getProjectSdk();
            if (projectSdk == null) {
                sdkName = rootManager.getProjectSdkName();
                String sdkTypeName = rootManager.getProjectSdkTypeName();
                if (sdkName != null) {
                    sdkToTypes.put(sdkName, (Object)sdkTypeName);
                }
            } else {
                sdkName = knownSdks;
                sdkName.add(projectSdk);
            }
        }
        for (Module module : this.collectModulesToCheckSdk(this.myProject)) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            ProgressManager.checkCanceled();
            moduleRootManager = ModuleRootManager.getInstance(module);
            ModuleRootManager moduleRootManager2 = moduleRootManager;
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager2, (String)"moduleRootManager");
            if (moduleRootManager2.getExternalSource() != null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager.getOrderEntries(), (String)"moduleRootManager.orderEntries");
            boolean $i$f$filterIsInstance = false;
            void var9_14 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ModuleJdkOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if ((ModuleJdkOrderEntry)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)) == null) {
                continue;
            }
            moduleJdk = jdkEntry.getJdk();
            if (moduleJdk == null) {
                String jdkName = jdkEntry.getJdkName();
                jdkTypeName = jdkEntry.getJdkTypeName();
                if (jdkName == null) continue;
                sdkToTypes.put((Object)jdkName, jdkTypeName);
                continue;
            }
            Collection jdkName = knownSdks;
            jdkName.add(moduleJdk);
        }
        TreeSet<void> totallyUnknownSdks = new TreeSet<void>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        List resolvableSdks = new ArrayList();
        Map map2 = sdkToTypes.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"sdkToTypes.asMap()");
        moduleJdk = map2;
        jdkEntry = moduleJdk.entrySet().iterator();
        while (jdkEntry.hasNext()) {
            void sdkName;
            Collection sdkTypes;
            jdkTypeName = moduleRootManager = jdkEntry.next();
            moduleJdk = (String)jdkTypeName.getKey();
            jdkTypeName = moduleRootManager;
            Collection collection = sdkTypes = (Collection)jdkTypeName.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sdkTypes");
            String singleSdkTypeName = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)CollectionsKt.filterNotNull((Iterable)collection)));
            if (singleSdkTypeName == null) {
                totallyUnknownSdks.add(sdkName);
                continue;
            }
            SdkType sdkType = SdkType.findByName((String)singleSdkTypeName);
            if (sdkType == null) continue;
            void v4 = sdkName;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"sdkName");
            resolvableSdks.add(new MissingSdkInfo((String)v4, sdkType));
        }
        Iterable $this$mapNotNull$iv = resolvableSdks;
        boolean $i$f$mapNotNull = false;
        Iterable sdkTypes = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            UnknownSdk it = (UnknownSdk)element$iv$iv;
            boolean bl2 = false;
            if (it.getSdkName() == null) continue;
            String it$iv$iv = string2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set detectedUnknownSdkNames = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = this.getContributors();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            List $i$f$forEach3;
            UnknownSdkContributor it = (UnknownSdkContributor)element$iv;
            boolean bl = false;
            try {
                $i$f$forEach3 = it.contributeUnknownSdks(this.myProject);
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable t) {
                LOG.warn("Failed to contribute SDKs with " + it.getClass().getName() + ". " + t.getMessage(), t);
                $i$f$forEach3 = CollectionsKt.emptyList();
            }
            List contrib = $i$f$forEach3;
            for (Object unknownSdk2 : contrib) {
                String name2;
                if (unknownSdk2.getSdkName() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"unknownSdk.sdkName ?: continue");
                if (!detectedUnknownSdkNames.add(name2)) continue;
                Collection collection = resolvableSdks;
                collection.add(unknownSdk2);
            }
            try {
                Object unknownSdk2;
                unknownSdk2 = knownSdks;
                object = it.contributeKnownSdks(this.myProject);
                CollectionsKt.addAll((Collection)unknownSdk2, (Iterable)object);
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable t) {
                LOG.warn("Failed to contribute SDKs with " + it.getClass().getName() + ". " + t.getMessage(), t);
            }
        }
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)knownSdks);
        boolean $i$f$sortedBy = false;
        return new UnknownSdkSnapshot((Set<String>)totallyUnknownSdks, resolvableSdks, CollectionsKt.distinct((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Sdk it = (Sdk)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Sdk)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string2 = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        })));
    }

    @NotNull
    protected List<UnknownSdkContributor> getContributors() {
        List<UnknownSdkContributor> list2 = UnknownSdkCollectorKt.access$getEP_NAME$p().getExtensionList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"EP_NAME.extensionList");
        return list2;
    }

    public UnknownSdkCollector(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnknownSdkCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ UnknownSdkSnapshot access$collectSdksUnderReadAction(UnknownSdkCollector $this) {
        return $this.collectSdksUnderReadAction();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkCollector$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

