/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdkFixLocal;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnknownSdkBalloonNotification {
    private final Project myProject;

    @NotNull
    public static UnknownSdkBalloonNotification getInstance(@NotNull Project project2) {
        if (project2 == null) {
            UnknownSdkBalloonNotification.$$$reportNull$$$0(0);
        }
        UnknownSdkBalloonNotification unknownSdkBalloonNotification = project2.getService(UnknownSdkBalloonNotification.class);
        if (unknownSdkBalloonNotification == null) {
            UnknownSdkBalloonNotification.$$$reportNull$$$0(1);
        }
        return unknownSdkBalloonNotification;
    }

    public UnknownSdkBalloonNotification(@NotNull Project project2) {
        if (project2 == null) {
            UnknownSdkBalloonNotification.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
    }

    public void notifyFixedSdks(@NotNull List<UnknownMissingSdkFixLocal> localFixes) {
        String change;
        String title;
        if (localFixes == null) {
            UnknownSdkBalloonNotification.$$$reportNull$$$0(3);
        }
        if (localFixes.isEmpty()) {
            return;
        }
        TreeSet<@Nls String> usages = new TreeSet<String>();
        for (UnknownMissingSdkFixLocal entry : localFixes) {
            UnknownSdkLocalSdkFix fix2 = entry.getLocalSdkFix();
            String usageText = ProjectBundle.message((String)"notification.text.sdk.usage.is.set.to", (Object[])new Object[]{entry.getSdkNameForUi(), fix2.getVersionString()});
            usages.add(new HtmlBuilder().append(usageText).append(HtmlChunk.br()).append(SdkListPresenter.presentDetectedSdkPath(fix2.getExistingSdkHome())).toString());
        }
        @Nls String message2 = StringUtil.join(usages, "<br/><br/>");
        if (localFixes.size() == 1) {
            UnknownMissingSdkFixLocal entry = localFixes.iterator().next();
            UnknownSdk info = entry.getUnknownSdk();
            String sdkTypeName = info.getSdkType().getPresentableName();
            title = ProjectBundle.message((String)"notification.title.sdk.configured", (Object[])new Object[]{sdkTypeName});
            change = ProjectBundle.message((String)"notification.link.change.sdk", (Object[])new Object[]{sdkTypeName});
        } else {
            title = ProjectBundle.message((String)"notification.title.sdks.configured", (Object[])new Object[0]);
            change = ProjectBundle.message((String)"notification.link.change.sdks", (Object[])new Object[0]);
        }
        if (usages.isEmpty() || message2.isBlank()) {
            return;
        }
        NotificationGroupManager.getInstance().getNotificationGroup("Missing SDKs").createNotification(title, message2, NotificationType.INFORMATION).setImportant(true).addAction((AnAction)NotificationAction.createSimple((String)change, () -> ProjectSettingsService.getInstance(this.myProject).openProjectSettings())).notify(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkBalloonNotification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkBalloonNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyFixedSdks";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

