/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdk;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixActionLocalBase;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UnknownMissingSdkFixLocal
extends UnknownSdkFixActionLocalBase
implements UnknownSdkFixAction {
    private static final Logger LOG = Logger.getInstance(UnknownMissingSdkFixLocal.class);
    @NotNull
    private final UnknownSdkLocalSdkFix myFix;
    @NotNull
    private final UnknownSdk mySdk;

    UnknownMissingSdkFixLocal(@NotNull UnknownSdk sdk2, @NotNull UnknownSdkLocalSdkFix fix2) {
        if (sdk2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(0);
        }
        if (fix2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(1);
        }
        this.myFix = fix2;
        this.mySdk = sdk2;
    }

    @NotNull
    String getSdkNameForUi() {
        String string2 = UnknownMissingSdk.getSdkNameForUi(this.mySdk);
        if (string2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    UnknownSdkLocalSdkFix getLocalSdkFix() {
        UnknownSdkLocalSdkFix unknownSdkLocalSdkFix = this.myFix;
        if (unknownSdkLocalSdkFix == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(3);
        }
        return unknownSdkLocalSdkFix;
    }

    @NotNull
    UnknownSdk getUnknownSdk() {
        UnknownSdk unknownSdk2 = this.mySdk;
        if (unknownSdk2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(4);
        }
        return unknownSdk2;
    }

    @Override
    @NotNull
    @Nls
    public String getActionTooltipText() {
        String string2 = SdkListPresenter.presentDetectedSdkPath(this.myFix.getExistingSdkHome(), 90, 40);
        if (string2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    @Nullable
    public Sdk getRegisteredSdkPrototype() {
        return this.myFix.getRegisteredSdkPrototype();
    }

    @Override
    @NotNull
    @Nls
    public String getActionShortText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string2 = ProjectBundle.message((String)"config.unknown.sdk.local", (Object[])new Object[]{sdkTypeName, this.myFix.getPresentableVersionString()});
        if (string2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    @Nls
    public String getActionAppliedMessage() {
        String string2 = ProjectBundle.message((String)"notification.text.sdk.usage.is.set.to", (Object[])new Object[]{this.getSdkNameForUi(), this.myFix.getVersionString()});
        if (string2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    @Nls
    public String getActionDetailedText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string2 = ProjectBundle.message((String)"label.text.use.for.unknown.sdk", (Object[])new Object[]{sdkTypeName, this.myFix.getPresentableVersionString(), sdkTypeName, this.getSdkNameForUi()});
        if (string2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    @NotNull
    protected String getSuggestedSdkHome() {
        String string2 = this.myFix.getExistingSdkHome();
        if (string2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    @NotNull
    protected Sdk applyLocalFix() {
        Sdk sdk2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            String actualSdkName = this.mySdk.getSdkName();
            if (actualSdkName == null) {
                actualSdkName = this.myFix.getSuggestedSdkName();
            }
            Sdk sdk3 = UnknownMissingSdkFix.createNewSdk(this.mySdk, this.myFix::getSuggestedSdkName);
            SdkModificator mod = sdk3.getSdkModificator();
            mod.setHomePath(FileUtil.toSystemIndependentName(this.myFix.getExistingSdkHome()));
            mod.setVersionString(this.myFix.getVersionString());
            mod.commitChanges();
            this.mySdk.getSdkType().setupSdkPaths(sdk3);
            this.myFix.configureSdk(sdk3);
            UnknownMissingSdkFix.registerNewSdkInJdkTable(actualSdkName, sdk3);
            LOG.info("Automatically set Sdk " + this.mySdk + " to " + this.myFix.getExistingSdkHome());
            sdk2 = sdk3;
        }
        catch (Throwable t) {
            LOG.warn("Failed to configure " + this.mySdk.getSdkType().getPresentableName() + "  for " + this.mySdk + " for path " + this.myFix + ". " + t.getMessage(), t);
            throw t;
        }
        if (sdk2 == null) {
            UnknownMissingSdkFixLocal.$$$reportNull$$$0(10);
        }
        return sdk2;
    }

    public String toString() {
        return this.myFix.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownMissingSdkFixLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownMissingSdkFixLocal";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkNameForUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSdkFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownSdk";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTooltipText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionShortText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionAppliedMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionDetailedText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedSdkHome";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyLocalFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

