/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderMac;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWindows;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaHomeFinder {
    public static final String[] DEFAULT_JAVA_LINUX_PATHS = new String[]{"/usr/java", "/opt/java", "/usr/lib/jvm"};

    @NotNull
    public static List<String> suggestHomePaths() {
        return JavaHomeFinder.suggestHomePaths(false);
    }

    @NotNull
    public static List<String> suggestHomePaths(boolean forceEmbeddedJava) {
        JavaHomeFinderBasic javaFinder = JavaHomeFinder.getFinder(forceEmbeddedJava);
        if (javaFinder == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaHomeFinder.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList<String> paths2 = new ArrayList<String>(javaFinder.findExistingJdks());
        paths2.sort((o1, o2) -> Comparing.compare(JavaVersion.tryParse(o2), JavaVersion.tryParse(o1)));
        ArrayList<String> arrayList = paths2;
        if (arrayList == null) {
            JavaHomeFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static boolean isDetectorEnabled(boolean forceEmbeddedJava) {
        return forceEmbeddedJava || Registry.is("java.detector.enabled", true);
    }

    private static JavaHomeFinderBasic getFinder(boolean forceEmbeddedJava) {
        if (!JavaHomeFinder.isDetectorEnabled(forceEmbeddedJava)) {
            return null;
        }
        return JavaHomeFinder.getFinder().checkEmbeddedJava(forceEmbeddedJava);
    }

    @NotNull
    public static JavaHomeFinderBasic getFinder() {
        SystemInfoProvider systemInfoProvider = new SystemInfoProvider();
        if (SystemInfo.isWindows) {
            return new JavaHomeFinderWindows(true, true, systemInfoProvider);
        }
        if (SystemInfo.isMac) {
            return new JavaHomeFinderMac(systemInfoProvider);
        }
        if (SystemInfo.isLinux) {
            JavaHomeFinderBasic javaHomeFinderBasic = new JavaHomeFinderBasic(systemInfoProvider).checkSpecifiedPaths(DEFAULT_JAVA_LINUX_PATHS);
            if (javaHomeFinderBasic == null) {
                JavaHomeFinder.$$$reportNull$$$0(2);
            }
            return javaHomeFinderBasic;
        }
        if (SystemInfo.isSolaris) {
            JavaHomeFinderBasic javaHomeFinderBasic = new JavaHomeFinderBasic(systemInfoProvider).checkSpecifiedPaths("/usr/jdk");
            if (javaHomeFinderBasic == null) {
                JavaHomeFinder.$$$reportNull$$$0(3);
            }
            return javaHomeFinderBasic;
        }
        return new JavaHomeFinderBasic(systemInfoProvider);
    }

    @Nullable
    public static String defaultJavaLocation() {
        if (SystemInfo.isWindows) {
            return "C:\\Program Files";
        }
        if (SystemInfo.isMac) {
            return JavaHomeFinderMac.defaultJavaLocation;
        }
        if (SystemInfo.isLinux) {
            return "/opt/java";
        }
        if (SystemInfo.isSolaris) {
            return "/usr/jdk";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinder";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class SystemInfoProvider {
        @Nullable
        public String getEnvironmentVariable(@NotNull String name2) {
            if (name2 == null) {
                SystemInfoProvider.$$$reportNull$$$0(0);
            }
            return EnvironmentUtil.getValue(name2);
        }

        @NotNull
        public Path getPath(String path2, String ... more) {
            Path path3 = Path.of(path2, more);
            if (path3 == null) {
                SystemInfoProvider.$$$reportNull$$$0(1);
            }
            return path3;
        }

        @Nullable
        public Path getUserHome() {
            return Path.of(SystemProperties.getUserHome(), new String[0]);
        }

        @NotNull
        public @NotNull Collection<@NotNull Path> getFsRoots() {
            Iterable<Path> rootDirectories = FileSystems.getDefault().getRootDirectories();
            List<Path> list2 = rootDirectories != null ? ContainerUtil.newArrayList(rootDirectories) : Collections.emptyList();
            if (list2 == null) {
                SystemInfoProvider.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public String getPathSeparator() {
            return File.pathSeparator;
        }

        public boolean isFileSystemCaseSensitive() {
            return SystemInfoRt.isFileSystemCaseSensitive;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinder$SystemInfoProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinder$SystemInfoProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFsRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getEnvironmentVariable";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

