/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CancellationKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a'\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\t0\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u001a>\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0006\u001a\u00020\u00072!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H\t0\u000bH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a'\u0010\u0011\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\t0\u000bH\u0000\u00a2\u0006\u0002\u0010\f\u001a/\u0010\u0012\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015\u001a)\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019\u001a'\u0010\u001a\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0018\u00a2\u0006\u0002\u0010\u001b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "cancelWithIndicator", "Lkotlinx/coroutines/Job;", "job", "Lkotlinx/coroutines/CompletableJob;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "ensureCurrentJob", "T", "action", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/ParameterName;", "name", "currentJob", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "ensureCurrentJobAllowingOrphan", "ensureCurrentJobInner", "allowOrphan", "", "(ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "executeWithJobAndCompleteIt", "X", "Lkotlin/Function0;", "(Lkotlinx/coroutines/CompletableJob;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withJob", "(Lkotlinx/coroutines/Job;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.core"})
@ApiStatus.Internal
public final class CancellationKt {
    private static final Logger LOG;

    public static final <X> X withJob(@NotNull Job job, @NotNull Function0<? extends X> action2) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Function0<? extends X> function0 = action2;
        return (X)Cancellation.withJob(job, new ThrowableComputable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object compute() {
                return this.function.invoke();
            }
        });
    }

    @ApiStatus.Internal
    public static final <T> T ensureCurrentJob(@NotNull Function1<? super Job, ? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CancellationKt.ensureCurrentJobInner(false, action2);
    }

    public static final <T> T ensureCurrentJobAllowingOrphan(@NotNull Function1<? super Job, ? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CancellationKt.ensureCurrentJobInner(true, action2);
    }

    private static final <T> T ensureCurrentJobInner(boolean allowOrphan, Function1<? super Job, ? extends T> action2) {
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        if (indicator != null) {
            return CancellationKt.ensureCurrentJob(indicator, action2);
        }
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            return (T)action2.invoke((Object)currentJob);
        }
        if (!allowOrphan) {
            LOG.error("There is no ProgressIndicator or Job in this thread, the current job is not cancellable.");
        }
        CompletableJob orphanJob = JobKt.Job(null);
        return (T)CancellationKt.executeWithJobAndCompleteIt(orphanJob, (Function0)new Function0<T>(action2, orphanJob){
            final /* synthetic */ Function1 $action;
            final /* synthetic */ CompletableJob $orphanJob;

            public final T invoke() {
                return (T)this.$action.invoke((Object)this.$orphanJob);
            }
            {
                this.$action = function1;
                this.$orphanJob = completableJob;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T ensureCurrentJob(@NotNull ProgressIndicator indicator, @NotNull Function1<? super Job, ? extends T> action2) {
        Object x;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        CompletableJob currentJob = JobKt.Job(null);
        Job indicatorWatcher = CancellationKt.cancelWithIndicator(currentJob, indicator);
        try {
            x = ProgressManager.getInstance().silenceGlobalIndicator(new Supplier(currentJob, action2){
                final /* synthetic */ CompletableJob $currentJob;
                final /* synthetic */ Function1 $action;

                public final T get() {
                    return (T)CancellationKt.executeWithJobAndCompleteIt(this.$currentJob, (Function0)new Function0<T>(this){
                        final /* synthetic */ ensureCurrentJob.1 this$0;

                        public final T invoke() {
                            return (T)this.this$0.$action.invoke((Object)this.this$0.$currentJob);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.$currentJob = completableJob;
                    this.$action = function1;
                }
            });
        }
        catch (CancellationException ce) {
            Throwable cause = ce.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw cause;
            }
            if (cause != null) {
                throw (Throwable)new ProcessCanceledException(cause);
            }
            throw (Throwable)ce;
        }
        finally {
            Job.DefaultImpls.cancel$default(indicatorWatcher, null, 1, null);
        }
        return (T)x;
    }

    private static final Job cancelWithIndicator(CompletableJob job, ProgressIndicator indicator) {
        return BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO()), (CoroutineContext)new CoroutineName("indicator watcher"), null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(indicator, job, null){
            int label;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ CompletableJob $job;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 3 sources

                        while (!this.$indicator.isCanceled()) {
                            this.label = 1;
                            v0 = DelayKt.delay(10L, (Continuation<? super Unit>)this);
                            if (v0 != var3_2) continue;
                            return var3_2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl5
                    }
                }
                try {
                    this.$indicator.checkCanceled();
                    var2_3 = "A cancelled indicator must throw PCE";
                    throw new IllegalStateException(var2_3.toString());
                }
                catch (ProcessCanceledException pce) {
                    this.$job.completeExceptionally(pce);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$indicator = progressIndicator;
                this.$job = completableJob;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @ApiStatus.Internal
    public static final <X> X executeWithJobAndCompleteIt(@NotNull CompletableJob job, @NotNull Function0<? extends X> action2) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        try {
            X result2 = CancellationKt.withJob(job, action2);
            job.complete();
            return result2;
        }
        catch (Throwable e) {
            CancellationException cancellationException;
            CancellationException $this$apply = cancellationException = new CancellationException();
            boolean bl = false;
            $this$apply.initCause(e);
            CancellationException ce = cancellationException;
            job.cancel(ce);
            throw e;
        }
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.openapi.progress");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026tellij.openapi.progress\")");
        LOG = logger;
    }
}

