/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReferenceManagerImpl
extends PathReferenceManager {
    private final StaticPathReferenceProvider myStaticProvider = new StaticPathReferenceProvider(null);
    private final PathReferenceProvider myGlobalPathsProvider = new GlobalPathReferenceProvider();
    private static final Comparator<PsiReference> START_OFFSET_COMPARATOR = Comparator.comparingInt(o -> o.getRangeInElement().getStartOffset());

    @Override
    @Nullable
    public PathReference getPathReference(@NotNull String path2, @NotNull PsiElement element2, PathReferenceProvider ... additionalProviders) {
        PathReference pathReference;
        if (path2 == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(1);
        }
        for (PathReferenceProvider provider2 : PathReferenceManagerImpl.getProviders()) {
            pathReference = provider2.getPathReference(path2, element2);
            if (pathReference == null) continue;
            return pathReference;
        }
        for (PathReferenceProvider provider3 : additionalProviders) {
            pathReference = provider3.getPathReference(path2, element2);
            if (pathReference == null) continue;
            return pathReference;
        }
        pathReference = this.myStaticProvider.getPathReference(path2, element2);
        if (pathReference != null) {
            return pathReference;
        }
        return null;
    }

    @Override
    @Nullable
    public PathReference getCustomPathReference(@NotNull String path2, @NotNull Module module, @NotNull PsiElement element2, PathReferenceProvider ... providers2) {
        if (path2 == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(2);
        }
        if (module == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(4);
        }
        for (PathReferenceProvider provider2 : providers2) {
            PathReference reference2 = provider2.getPathReference(path2, element2);
            if (reference2 == null) continue;
            return reference2;
        }
        return null;
    }

    @Override
    @NotNull
    public PathReferenceProvider getGlobalWebPathReferenceProvider() {
        PathReferenceProvider pathReferenceProvider = this.myGlobalPathsProvider;
        if (pathReferenceProvider == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(5);
        }
        return pathReferenceProvider;
    }

    @Override
    @NotNull
    public PathReferenceProvider createStaticPathReferenceProvider(boolean relativePathsAllowed) {
        StaticPathReferenceProvider provider2 = new StaticPathReferenceProvider(null);
        provider2.setRelativePathsAllowed(relativePathsAllowed);
        StaticPathReferenceProvider staticPathReferenceProvider = provider2;
        if (staticPathReferenceProvider == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(6);
        }
        return staticPathReferenceProvider;
    }

    @Override
    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(7);
        }
        PsiReference[] psiReferenceArray = this.createReferences(psiElement, soft, endingSlashNotAllowed, relativePathsAllowed, (FileType[])null, additionalProviders);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @Override
    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, FileType[] suitableFileTypes, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(9);
        }
        ArrayList<PsiReference> mergedReferences = new ArrayList<PsiReference>();
        PathReferenceManagerImpl.processProvider(psiElement, this.myGlobalPathsProvider, mergedReferences, soft);
        StaticPathReferenceProvider staticProvider = new StaticPathReferenceProvider(suitableFileTypes);
        staticProvider.setEndingSlashNotAllowed(endingSlashNotAllowed);
        staticProvider.setRelativePathsAllowed(relativePathsAllowed);
        PathReferenceManagerImpl.processProvider(psiElement, staticProvider, mergedReferences, soft);
        for (PathReferenceProvider provider2 : PathReferenceManagerImpl.getProviders()) {
            PathReferenceManagerImpl.processProvider(psiElement, provider2, mergedReferences, soft);
        }
        for (PathReferenceProvider provider3 : additionalProviders) {
            PathReferenceManagerImpl.processProvider(psiElement, provider3, mergedReferences, soft);
        }
        for (PathReferenceProvider provider4 : ANCHOR_REFERENCE_PROVIDER_EP.getExtensionList()) {
            PathReferenceManagerImpl.processProvider(psiElement, provider4, mergedReferences, soft);
        }
        PsiReference[] psiReferenceArray = PathReferenceManagerImpl.mergeReferences(psiElement, mergedReferences);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @Override
    public PsiReference @NotNull [] createCustomReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... providers2) {
        PathReferenceProvider provider2;
        boolean processed;
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(11);
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        PathReferenceProvider[] pathReferenceProviderArray = providers2;
        int n = pathReferenceProviderArray.length;
        for (int i = 0; i < n && !(processed = PathReferenceManagerImpl.processProvider(psiElement, provider2 = pathReferenceProviderArray[i], references, soft)); ++i) {
        }
        PsiReference[] psiReferenceArray = PathReferenceManagerImpl.mergeReferences(psiElement, references);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    @Override
    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(13);
        }
        PsiReference[] psiReferenceArray = this.createReferences(psiElement, soft, false, true, (FileType[])null, additionalProviders);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(14);
        }
        return psiReferenceArray;
    }

    private static PsiReference[] mergeReferences(PsiElement element2, List<? extends PsiReference> references) {
        if (references.size() <= 1) {
            return references.toArray(PsiReference.EMPTY_ARRAY);
        }
        references.sort(START_OFFSET_COMPARATOR);
        ArrayList<PsiReference> intersecting = new ArrayList<PsiReference>();
        ArrayList<PsiReference> notIntersecting = new ArrayList<PsiReference>();
        TextRange intersectingRange = references.get(0).getRangeInElement();
        boolean intersected = false;
        for (int i = 1; i < references.size(); ++i) {
            PsiReference reference2 = references.get(i);
            TextRange range = reference2.getRangeInElement();
            int offset = range.getStartOffset();
            if (intersectingRange.getStartOffset() <= offset && intersectingRange.getEndOffset() >= offset) {
                intersected = true;
                intersecting.add(references.get(i - 1));
                if (i == references.size() - 1) {
                    intersecting.add(reference2);
                }
                intersectingRange = intersectingRange.union(range);
                continue;
            }
            if (intersected) {
                intersecting.add(references.get(i - 1));
                intersected = false;
            } else {
                notIntersecting.add(references.get(i - 1));
            }
            intersectingRange = range;
            if (i != references.size() - 1) continue;
            notIntersecting.add(reference2);
        }
        List<PsiReference> result2 = PathReferenceManagerImpl.doMerge(element2, intersecting);
        result2.addAll(notIntersecting);
        result2.sort(START_OFFSET_COMPARATOR);
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static List<PsiReference> doMerge(PsiElement element2, List<? extends PsiReference> references) {
        TextRange range;
        AbstractList list2;
        ArrayList<PsiReference> resolvingRefs = new ArrayList<PsiReference>();
        ArrayList<PsiReference> nonResolvingRefs = new ArrayList<PsiReference>();
        for (int i = 0; i < references.size(); ++i) {
            PsiReference reference2 = references.get(i);
            assert (element2.equals(reference2.getElement()));
            if (reference2.resolve() != null) {
                resolvingRefs.add(reference2);
                continue;
            }
            nonResolvingRefs.add(reference2);
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>(5);
        while (!resolvingRefs.isEmpty()) {
            list2 = new ArrayList(5);
            range = PathReferenceManagerImpl.getFirstIntersectingReferences(resolvingRefs, list2);
            TextRange textRange = PathReferenceManagerImpl.addIntersectingReferences(nonResolvingRefs, list2, range);
            PathReferenceManagerImpl.addToResult(element2, result2, list2, textRange);
        }
        while (!nonResolvingRefs.isEmpty()) {
            list2 = new SmartList();
            range = PathReferenceManagerImpl.getFirstIntersectingReferences(nonResolvingRefs, list2);
            int endOffset = range.getEndOffset();
            for (PsiReference reference3 : list2) {
                endOffset = Math.min(endOffset, reference3.getRangeInElement().getEndOffset());
            }
            PathReferenceManagerImpl.addToResult(element2, result2, list2, new TextRange(range.getStartOffset(), endOffset));
        }
        return result2;
    }

    private static void addToResult(PsiElement element2, List<? super PsiReference> result2, List<? extends PsiReference> list2, TextRange range) {
        if (list2.size() == 1) {
            result2.add(list2.get(0));
        } else {
            PsiDynaReference<PsiElement> psiDynaReference = new PsiDynaReference<PsiElement>(element2);
            psiDynaReference.addReferences(list2);
            psiDynaReference.setRangeInElement(range);
            result2.add(psiDynaReference);
        }
    }

    private static TextRange addIntersectingReferences(List<PsiReference> set2, List<? super PsiReference> toAdd, TextRange range) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getStartOffset();
        Iterator<PsiReference> iterator = set2.iterator();
        while (iterator.hasNext()) {
            PsiReference reference2 = iterator.next();
            TextRange rangeInElement = reference2.getRangeInElement();
            if (!PathReferenceManagerImpl.intersect(range, rangeInElement)) continue;
            toAdd.add(reference2);
            iterator.remove();
            startOffset = Math.min(startOffset, rangeInElement.getStartOffset());
            endOffset = Math.max(endOffset, rangeInElement.getEndOffset());
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean intersect(TextRange range1, TextRange range2) {
        return range2.intersectsStrict(range1) || range2.intersects(range1) && (range1.isEmpty() || range2.isEmpty());
    }

    private static TextRange getFirstIntersectingReferences(List<PsiReference> set2, List<? super PsiReference> toAdd) {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        Iterator<PsiReference> it = set2.iterator();
        while (it.hasNext()) {
            PsiReference reference2 = it.next();
            TextRange range = reference2.getRangeInElement();
            if (endOffset != -1 && range.getStartOffset() > endOffset) break;
            startOffset = Math.min(startOffset, range.getStartOffset());
            endOffset = Math.max(range.getEndOffset(), endOffset);
            toAdd.add(reference2);
            it.remove();
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean processProvider(PsiElement psiElement, PathReferenceProvider provider2, List<PsiReference> mergedReferences, boolean soft) {
        return provider2.createReferences(psiElement, mergedReferences, soft);
    }

    private static List<PathReferenceProvider> getProviders() {
        return PATH_REFERENCE_PROVIDER_EP.getExtensionList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PathReferenceManagerImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PathReferenceManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalWebPathReferenceProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStaticPathReferenceProvider";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPathReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPathReference";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCustomReferences";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

