/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.configurationStore.RenameableStateStorageManager;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.NonPersistentModuleStore;
import com.intellij.openapi.module.impl.scopes.ModuleScopeProviderImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleImpl
extends ComponentManagerImpl
implements ModuleEx {
    private static final Logger LOG = Logger.getInstance(ModuleImpl.class);
    @NotNull
    private final Project myProject;
    @Nullable
    protected VirtualFilePointer myImlFilePointer;
    private volatile boolean isModuleAdded;
    private String myName;
    private final ModuleScopeProvider myModuleScopeProvider;

    @ApiStatus.Internal
    public ModuleImpl(@NotNull String name2, @NotNull Project project2, @NotNull String filePath) {
        if (name2 == null) {
            ModuleImpl.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ModuleImpl.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            ModuleImpl.$$$reportNull$$$0(2);
        }
        this(name2, project2);
        this.myImlFilePointer = VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl(filePath), (Disposable)this, new VirtualFilePointerListener(){

            @Override
            public void validityChanged(@NotNull @NotNull VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ModuleImpl.this.myImlFilePointer == null) {
                    return;
                }
                VirtualFile virtualFile2 = ModuleImpl.this.myImlFilePointer.getFile();
                if (virtualFile2 != null) {
                    ((ModuleStore)ModuleImpl.this.getStore()).setPath(virtualFile2.toNioPath(), virtualFile2, false);
                    ModuleManager.getInstance(ModuleImpl.this.myProject).incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/module/impl/ModuleImpl$1", "validityChanged"));
            }
        });
    }

    @ApiStatus.Internal
    public ModuleImpl(@NotNull String name2, @NotNull Project project2, @Nullable VirtualFilePointer virtualFilePointer) {
        if (name2 == null) {
            ModuleImpl.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            ModuleImpl.$$$reportNull$$$0(4);
        }
        this(name2, project2);
        this.myImlFilePointer = virtualFilePointer;
    }

    @ApiStatus.Internal
    public ModuleImpl(@NotNull String name2, @NotNull Project project2) {
        if (name2 == null) {
            ModuleImpl.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            ModuleImpl.$$$reportNull$$$0(6);
        }
        super((ComponentManagerImpl)project2);
        this.registerServiceInstance(Module.class, this, ComponentManagerImpl.fakeCorePluginDescriptor);
        this.myProject = project2;
        this.myModuleScopeProvider = new ModuleScopeProviderImpl(this);
        this.myName = name2;
    }

    @Override
    public void init(@Nullable Runnable beforeComponentCreation) {
        this.registerComponents();
        if (!this.isPersistent()) {
            this.registerService(IComponentStore.class, NonPersistentModuleStore.class, ComponentManagerImpl.fakeCorePluginDescriptor, true, ServiceDescriptor.PreloadMode.FALSE);
        }
        if (beforeComponentCreation != null) {
            beforeComponentCreation.run();
        }
        this.createComponents(null);
    }

    private boolean isPersistent() {
        return this.myImlFilePointer != null;
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ModuleImpl.$$$reportNull$$$0(7);
        }
    }

    @Override
    public final boolean isDisposed() {
        return super.isDisposed() || ((ProjectEx)this.myProject).isLight() && this.myProject.isDisposed();
    }

    protected boolean isComponentSuitable(@NotNull ComponentConfig componentConfig) {
        if (componentConfig == null) {
            ModuleImpl.$$$reportNull$$$0(8);
        }
        if (!super.isComponentSuitable(componentConfig)) {
            return false;
        }
        Map<String, String> options = componentConfig.options;
        if (options == null || options.isEmpty()) {
            return true;
        }
        for (String optionName : options.keySet()) {
            if ("workspace".equals(optionName) || "overrides".equals(optionName)) continue;
            String message2 = "Don't specify " + optionName + " in the component registration, transform component to service and implement your logic in your getInstance() method";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message2);
                continue;
            }
            LOG.warn(message2);
        }
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getModuleFile() {
        if (this.myImlFilePointer == null) {
            return null;
        }
        return this.myImlFilePointer.getFile();
    }

    @Override
    public void rename(@NotNull String newName2, boolean notifyStorage) {
        if (newName2 == null) {
            ModuleImpl.$$$reportNull$$$0(9);
        }
        this.myName = newName2;
        if (notifyStorage) {
            ((RenameableStateStorageManager)((Object)this.getStore().getStorageManager())).rename(newName2 + ".iml");
        }
    }

    @NotNull
    protected IComponentStore getStore() {
        IComponentStore iComponentStore = Objects.requireNonNull((IComponentStore)this.getService(IComponentStore.class));
        if (iComponentStore == null) {
            ModuleImpl.$$$reportNull$$$0(10);
        }
        return iComponentStore;
    }

    @Override
    public boolean canStoreSettings() {
        return !(this.getStore() instanceof NonPersistentModuleStore);
    }

    @Override
    @NotNull
    public Path getModuleNioFile() {
        if (!this.isPersistent()) {
            Path path2 = Paths.get("", new String[0]);
            if (path2 == null) {
                ModuleImpl.$$$reportNull$$$0(11);
            }
            return path2;
        }
        Path path3 = this.getStore().getStorageManager().expandMacro("$MODULE_FILE$");
        if (path3 == null) {
            ModuleImpl.$$$reportNull$$$0(12);
        }
        return path3;
    }

    @Override
    public synchronized void dispose() {
        this.isModuleAdded = false;
        super.dispose();
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            ModuleImpl.$$$reportNull$$$0(13);
        }
        ContainerDescriptor containerDescriptor = pluginDescriptor.moduleContainerDescriptor;
        if (containerDescriptor == null) {
            ModuleImpl.$$$reportNull$$$0(14);
        }
        return containerDescriptor;
    }

    @Override
    public void projectOpened() {
        this.processInitializedComponents(ModuleComponent.class, (component2, __) -> {
            try {
                component2.projectOpened();
            }
            catch (Exception e) {
                LOG.error(e);
            }
            return Unit.INSTANCE;
        });
    }

    @Override
    public void projectClosed() {
        ArrayList components = new ArrayList();
        this.processInitializedComponents(ModuleComponent.class, (component2, __) -> {
            components.add(component2);
            return Unit.INSTANCE;
        });
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                ((ModuleComponent)components.get(i)).projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ModuleImpl.$$$reportNull$$$0(15);
        }
        return project2;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            ModuleImpl.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @Override
    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    @Override
    public void moduleAdded() {
        this.isModuleAdded = true;
        this.processInitializedComponents(ModuleComponent.class, (component2, __) -> {
            component2.moduleAdded();
            return Unit.INSTANCE;
        });
    }

    @Override
    public void setOption(@NotNull String key, @Nullable String value) {
        if (key == null) {
            ModuleImpl.$$$reportNull$$$0(17);
        }
        DeprecatedModuleOptionManager manager = this.getOptionManager();
        if (value == null) {
            if (manager.state.options.remove(key) != null) {
                manager.incModificationCount();
            }
        } else if (!value.equals(manager.state.options.put(key, value))) {
            manager.incModificationCount();
        }
    }

    @NotNull
    private DeprecatedModuleOptionManager getOptionManager() {
        DeprecatedModuleOptionManager deprecatedModuleOptionManager = this.getService(DeprecatedModuleOptionManager.class);
        if (deprecatedModuleOptionManager == null) {
            ModuleImpl.$$$reportNull$$$0(18);
        }
        return deprecatedModuleOptionManager;
    }

    @Override
    public String getOptionValue(@NotNull String key) {
        if (key == null) {
            ModuleImpl.$$$reportNull$$$0(19);
        }
        return this.getOptionManager().state.options.get(key);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope(includeTests);
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(21);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(22);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(23);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(24);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(25);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(26);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(28);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(29);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleProductionSourceScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleProductionSourceScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(30);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleTestSourceScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestSourceScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(31);
        }
        return globalSearchScope;
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public String toString() {
        if (this.myName == null) {
            return "Module (not initialized)";
        }
        return "Module: '" + this.getName() + "'" + (this.isDisposed() ? " (disposed)" : "");
    }

    @Override
    public long getOptionsModificationCount() {
        return this.getOptionManager().getModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentConfig";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStore";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNioFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionManager";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleScope";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithLibrariesScope";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesScope";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentScope";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentWithDependenciesScope";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesAndLibrariesScope";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependentsScope";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTestsWithDependentsScope";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRuntimeScope";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleProductionSourceScope";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTestSourceScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isComponentSuitable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainerDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOptionValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @com.intellij.openapi.components.State(name="DeprecatedModuleOptionManager", useLoadedStateAsExisting=false)
    @ApiStatus.Internal
    public static class DeprecatedModuleOptionManager
    extends SimpleModificationTracker
    implements PersistentStateComponent<State>,
    ProjectModelElement {
        private final Module module;
        private State state;

        DeprecatedModuleOptionManager(@NotNull Module module) {
            if (module == null) {
                DeprecatedModuleOptionManager.$$$reportNull$$$0(0);
            }
            this.state = new State();
            this.module = module;
        }

        @Override
        @Nullable
        public ProjectModelExternalSource getExternalSource() {
            if (this.state.options.size() > 1 || this.state.options.size() == 1 && !this.state.options.containsKey("type")) {
                return null;
            }
            return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.module);
        }

        @Override
        @Nullable
        public State getState() {
            return this.state;
        }

        @Override
        public void loadState(@NotNull State state) {
            if (state == null) {
                DeprecatedModuleOptionManager.$$$reportNull$$$0(1);
            }
            this.state = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/module/impl/ModuleImpl$DeprecatedModuleOptionManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static final class State {
            @Property(surroundWithTag=false)
            @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false, entryTagName="option")
            public final Map<String, String> options = new HashMap<String, String>();

            State() {
            }
        }
    }
}

