/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManagerBase
extends FileDocumentManager {
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create("HARD_REF_TO_DOCUMENT_KEY");
    public static final Key<Boolean> TRACK_NON_PHYSICAL = Key.create("TRACK_NON_PHYSICAL");
    private static final Key<VirtualFile> FILE_KEY = Key.create("FILE_KEY");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create("BIG_FILE_PREVIEW");
    private static final Object lock = new Object();
    private final Map<VirtualFile, Document> myDocumentCache = ContainerUtil.createConcurrentWeakValueMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file2);
        if (document == null) {
            if (!file2.isValid() || file2.isDirectory() || FileDocumentManagerBase.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            boolean tooLarge = FileUtilRt.isTooLarge(file2.getLength());
            if (file2.getFileType().isBinary() && tooLarge) {
                return null;
            }
            CharSequence text2 = this.loadText(file2, tooLarge);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file2);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)this.createDocument(text2, file2);
                document.setModificationStamp(file2.getModificationStamp());
                FileDocumentManagerBase.setDocumentTooLarge(document, tooLarge);
                FileType fileType = file2.getFileType();
                document.setReadOnly(tooLarge || !file2.isWritable() || fileType.isBinary());
                if (!(file2 instanceof LightVirtualFile) && !(file2.getFileSystem() instanceof NonPhysicalFileSystem) || Boolean.TRUE.equals(TRACK_NON_PHYSICAL.get(file2))) {
                    document.addDocumentListener(this.getDocumentListener());
                }
                if (file2 instanceof LightVirtualFile) {
                    FileDocumentManagerBase.registerDocument(document, file2);
                } else {
                    document.putUserData(FILE_KEY, file2);
                    this.cacheDocument(file2, document);
                }
            }
            this.fileContentLoaded(file2, document);
        }
        return document;
    }

    protected static void setDocumentTooLarge(Document document, boolean tooLarge) {
        document.putUserData(BIG_FILE_PREVIEW, tooLarge ? Boolean.TRUE : null);
    }

    @NotNull
    private CharSequence loadText(@NotNull VirtualFile file2, boolean tooLarge) {
        FileViewProvider vp;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(1);
        }
        if (file2 instanceof LightVirtualFile && (vp = this.findCachedPsiInAnyProject(file2)) != null) {
            String string2 = vp.getPsi(vp.getBaseLanguage()).getText();
            if (string2 == null) {
                FileDocumentManagerBase.$$$reportNull$$$0(2);
            }
            return string2;
        }
        CharSequence charSequence = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerBase.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
        if (charSequence == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @NotNull
    protected abstract Document createDocument(@NotNull CharSequence var1, @NotNull VirtualFile var2);

    @Override
    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        Document hard;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(4);
        }
        return (hard = file2.getUserData(HARD_REF_TO_DOCUMENT_KEY)) != null ? hard : this.getDocumentFromCache(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile2) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(5);
        }
        if (virtualFile2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(6);
        }
        if (!(virtualFile2 instanceof LightVirtualFile) && !(virtualFile2.getFileSystem() instanceof NonPhysicalFileSystem)) {
            throw new IllegalArgumentException("Hard-coding file<->document association is permitted for non-physical files only (see ViewProvider.isPhysical()) to avoid memleaks. virtualFile=" + virtualFile2);
        }
        Object object = lock;
        synchronized (object) {
            document.putUserData(FILE_KEY, virtualFile2);
            virtualFile2.putUserData(HARD_REF_TO_DOCUMENT_KEY, document);
        }
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(7);
        }
        if (document instanceof FrozenDocument) {
            return null;
        }
        return document.getUserData(FILE_KEY);
    }

    @Override
    public void reloadBinaryFiles() {
        List<VirtualFile> binaries = ContainerUtil.filter(this.myDocumentCache.keySet(), file2 -> file2.getFileType().isBinary());
        FileContentUtilCore.reparseFiles(binaries);
    }

    @Override
    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(8);
        }
        return document.getUserData(BIG_FILE_PREVIEW) == Boolean.TRUE;
    }

    void unbindFileFromDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(9);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(10);
        }
        this.removeDocumentFromCache(file2);
        file2.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    protected static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(11);
        }
        return (type = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(type) == null;
    }

    protected static int getPreviewCharCount(@NotNull VirtualFile file2) {
        Charset charset;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(12);
        }
        float bytesPerChar = (charset = EncodingManager.getInstance().getEncoding(file2, false)) == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        return (int)((float)FileUtilRt.LARGE_FILE_PREVIEW_SIZE / bytesPerChar);
    }

    private void cacheDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(13);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(14);
        }
        this.myDocumentCache.put(file2, document);
    }

    private void removeDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(15);
        }
        this.myDocumentCache.remove(file2);
    }

    private Document getDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(16);
        }
        return this.myDocumentCache.get(file2);
    }

    protected abstract void fileContentLoaded(@NotNull VirtualFile var1, @NotNull Document var2);

    @NotNull
    protected abstract DocumentListener getDocumentListener();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unbindFileFromDocument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCharCount";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cacheDocument";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentFromCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFromCache";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

