/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.file.exclude.PersistentFileSetManager;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@State(name="OverrideFileTypeManager", storages={@Storage(value="overrideFileTypes.xml")})
@Service
public final class OverrideFileTypeManager
extends PersistentFileSetManager {
    public boolean isMarkedPlainText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            OverrideFileTypeManager.$$$reportNull$$$0(0);
        }
        return PlainTextFileType.INSTANCE.getName().equals(this.getFileValue(file2));
    }

    public static OverrideFileTypeManager getInstance() {
        return ApplicationManager.getApplication().getService(OverrideFileTypeManager.class);
    }

    @Override
    boolean addFile(@NotNull VirtualFile file2, @NotNull FileType type) {
        if (file2 == null) {
            OverrideFileTypeManager.$$$reportNull$$$0(1);
        }
        if (type == null) {
            OverrideFileTypeManager.$$$reportNull$$$0(2);
        }
        if (!(OverrideFileTypeManager.isOverridable(file2.getFileType()) && OverrideFileTypeManager.isOverridable(type) && file2 instanceof VirtualFileWithId)) {
            throw new IllegalArgumentException("Cannot override filetype for file " + file2 + " from " + file2.getFileType() + " to " + type + " because the " + (OverrideFileTypeManager.isOverridable(type) ? "former" : "latter") + " is not overridable");
        }
        return super.addFile(file2, type);
    }

    @TestOnly
    @ApiStatus.Internal
    public static void performTestWithMarkedAsPlainText(@NotNull VirtualFile file2, @NotNull Runnable runnable) {
        if (file2 == null) {
            OverrideFileTypeManager.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            OverrideFileTypeManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        OverrideFileTypeManager.getInstance().addFile(file2, PlainTextFileType.INSTANCE);
        UIUtil.dispatchAllInvocationEvents();
        try {
            runnable.run();
        }
        finally {
            OverrideFileTypeManager.getInstance().removeFile(file2);
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    static boolean isOverridable(@NotNull FileType type) {
        if (type == null) {
            OverrideFileTypeManager.$$$reportNull$$$0(5);
        }
        if (type instanceof InternalFileType) {
            return false;
        }
        if (type instanceof DirectoryFileType) {
            return false;
        }
        if (type instanceof UnknownFileType) {
            return false;
        }
        if (type instanceof FakeFileType) {
            return false;
        }
        return !(type instanceof FileTypeIdentifiableByVirtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/file/exclude/OverrideFileTypeManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarkedPlainText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performTestWithMarkedAsPlainText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isOverridable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

