/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.file.exclude.OverrideFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class OverrideFileTypeAction
extends DumbAwareAction {
    OverrideFileTypeAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (files2 = OverrideFileTypeAction.getContextFiles(e, file2 -> OverrideFileTypeManager.getInstance().getFileValue((VirtualFile)file2) == null)).length != 0;
        Presentation presentation2 = e.getPresentation();
        presentation2.setDescription(enabled ? ActionsBundle.message((String)"action.OverrideFileTypeAction.verbose.description", (Object[])new Object[]{files2[0].getName(), files2.length - 1}) : ActionsBundle.message((String)"action.OverrideFileTypeAction.description", (Object[])new Object[0]));
        presentation2.setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(2);
        }
        if ((files2 = OverrideFileTypeAction.getContextFiles(e, file2 -> OverrideFileTypeManager.getInstance().getFileValue((VirtualFile)file2) == null)).length == 0) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        Map duplicates = Arrays.stream(FileTypeManager.getInstance().getRegisteredFileTypes()).map(t -> t.getDisplayName()).collect(Collectors.groupingBy(Function.identity()));
        for (FileType type : ContainerUtil.sorted(Arrays.asList(FileTypeManager.getInstance().getRegisteredFileTypes()), (f1, f2) -> f1.getDisplayName().compareToIgnoreCase(f2.getDisplayName()))) {
            if (!OverrideFileTypeManager.isOverridable(type)) continue;
            boolean hasDuplicate = duplicates.get(type.getDisplayName()).size() > 1;
            String dupHint = null;
            if (hasDuplicate) {
                PluginDescriptor descriptor = ((FileTypeManagerImpl)FileTypeManager.getInstance()).findPluginDescriptor(type);
                dupHint = descriptor == null ? null : " (" + (descriptor.isBundled() ? ActionsBundle.message((String)"group.OverrideFileTypeAction.bundledPlugin", (Object[])new Object[0]) : ActionsBundle.message((String)"group.OverrideFileTypeAction.fromNamedPlugin", (Object[])new Object[]{descriptor.getName()})) + ")";
            }
            @NlsActions.ActionText String displayText = type.getDisplayName() + StringUtil.notNullize(dupHint);
            group.add((AnAction)new ChangeToThisFileTypeAction(displayText, files2, type));
        }
        JBPopupFactory.getInstance().createActionGroupPopup(ActionsBundle.message((String)"group.OverrideFileTypeAction.title", (Object[])new Object[0]), (ActionGroup)group, e.getDataContext(), false, null, -1).showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    static @NotNull VirtualFile @NotNull [] getContextFiles(@NotNull AnActionEvent e, @NotNull Predicate<? super VirtualFile> additionalPredicate) {
        VirtualFile[] files2;
        if (e == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(3);
        }
        if (additionalPredicate == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(4);
        }
        if ((files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                OverrideFileTypeAction.$$$reportNull$$$0(5);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])Arrays.stream(files2).filter(file2 -> file2 != null && ChangeToThisFileTypeAction.isOverridableFile(file2)).filter(additionalPredicate).toArray(count2 -> VirtualFile.ARRAY_FACTORY.create(count2));
        if (virtualFileArray == null) {
            OverrideFileTypeAction.$$$reportNull$$$0(6);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/file/exclude/OverrideFileTypeAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/file/exclude/OverrideFileTypeAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContextFiles";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeToThisFileTypeAction
    extends DumbAwareAction {
        @NotNull
        private final @NotNull VirtualFile @NotNull [] myFiles;
        private final FileType myType;

        ChangeToThisFileTypeAction(@NotNull @NlsActions.ActionText String displayText, @NotNull @NotNull VirtualFile @NotNull [] files2, @NotNull FileType type) {
            if (displayText == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(0);
            }
            if (files2 == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(1);
            }
            if (type == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(2);
            }
            super(displayText, ActionsBundle.message((String)"action.ChangeToThisFileTypeAction.description", (Object[])new Object[]{type.getDescription()}), type.getIcon());
            this.myFiles = files2;
            this.myType = type;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(3);
            }
            for (VirtualFile file2 : this.myFiles) {
                if (!ChangeToThisFileTypeAction.isOverridableFile(file2)) continue;
                OverrideFileTypeManager.getInstance().addFile(file2, this.myType);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(4);
            }
            boolean enabled = ContainerUtil.exists(this.myFiles, file2 -> ChangeToThisFileTypeAction.isOverridableFile(file2));
            e.getPresentation().setEnabled(enabled);
        }

        private static boolean isOverridableFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ChangeToThisFileTypeAction.$$$reportNull$$$0(5);
            }
            return file2.isValid() && !file2.isDirectory() && file2 instanceof VirtualFileWithId && OverrideFileTypeManager.isOverridable(file2.getFileType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/file/exclude/OverrideFileTypeAction$ChangeToThisFileTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOverridableFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

