/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedElementDuplicateHandler
extends EditorWriteActionHandler.ForEachCaret {
    private final EditorActionHandler myOriginal;

    public NamedElementDuplicateHandler(EditorActionHandler original) {
        this.myOriginal = original;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(1);
        }
        return this.myOriginal.isEnabled(editor2, caret, dataContext);
    }

    public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        Project project2;
        if (editor2 == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(3);
        }
        if ((project2 = editor2.getProject()) != null && !editor2.getSelectionModel().hasSelection()) {
            PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
            if (file2 != null) {
                VisualPosition caretPosition = editor2.getCaretModel().getVisualPosition();
                Pair lines2 = EditorUtil.calcSurroundingRange((Editor)editor2, (VisualPosition)caretPosition, (VisualPosition)caretPosition);
                TextRange toDuplicate = new TextRange(editor2.logicalPositionToOffset((LogicalPosition)lines2.first), editor2.logicalPositionToOffset((LogicalPosition)lines2.second));
                PsiElement name2 = NamedElementDuplicateHandler.findNameIdentifier(editor2, file2, toDuplicate);
                if (name2 != null && !name2.getTextRange().containsOffset(editor2.getCaretModel().getOffset())) {
                    editor2.getCaretModel().moveToOffset(name2.getTextOffset());
                }
            }
        }
        this.myOriginal.execute(editor2, caret, dataContext);
    }

    public EditorActionHandler getOriginal() {
        return this.myOriginal;
    }

    @Nullable
    private static PsiElement findNameIdentifier(Editor editor2, PsiFile file2, TextRange toDuplicate) {
        TextRange range;
        int nonWs = CharArrayUtil.shiftForward(editor2.getDocument().getCharsSequence(), toDuplicate.getStartOffset(), "\n\t ");
        PsiElement named = null;
        for (PsiElement psi = file2.findElementAt(nonWs); psi != null && (range = psi.getTextRange()) != null && !(psi instanceof PsiFile) && toDuplicate.contains(psi.getTextRange()); psi = psi.getParent()) {
            if (!(psi instanceof PsiNameIdentifierOwner)) continue;
            named = ((PsiNameIdentifierOwner)psi).getNameIdentifier();
        }
        return named;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/NamedElementDuplicateHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

