/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ide.impl.DocumentationTargetHoverInfoKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentationHoverInfo;
import com.intellij.openapi.editor.DocumentationPsiHoverInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorHoverInfo;
import com.intellij.openapi.editor.HighlightHoverInfo;
import com.intellij.openapi.editor.PopupBridge;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.WrapperPanel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.MouseMovementTracker;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class EditorMouseHoverPopupManager
implements Disposable {
    static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupManager.class);
    public static final int MAX_QUICK_DOC_CHARACTERS = 100000;
    protected final Alarm myAlarm;
    private final MouseMovementTracker myMouseMovementTracker = new MouseMovementTracker();
    private boolean myKeepPopupOnMouseMove;
    protected Reference<Editor> myCurrentEditor;
    protected Reference<AbstractPopup> myPopupReference;
    protected Context myContext;
    protected ProgressIndicator myCurrentProgress;
    private CancellablePromise<Context> myPreparationTask;
    private boolean mySkipNextMovement;

    public EditorMouseHoverPopupManager() {
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Editor editor2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor2 = event.getEditor()) == SoftReference.dereference(EditorMouseHoverPopupManager.this.myCurrentEditor)) {
                    DocumentationManager.getInstance(Objects.requireNonNull(editor2.getProject())).setAllowContentUpdateFromContext(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/EditorMouseHoverPopupManager$1", "caretPositionChanged"));
            }
        }, (Disposable)this);
        multicaster.addVisibleAreaListener(e -> {
            Rectangle oldRectangle = e.getOldRectangle();
            if (e.getEditor() == SoftReference.dereference(this.myCurrentEditor) && oldRectangle != null && !oldRectangle.getLocation().equals(e.getNewRectangle().getLocation())) {
                this.cancelProcessingAndCloseHint();
            }
        }, (Disposable)this);
        EditorMouseHoverPopupControl.getInstance().addListener(() -> {
            Editor editor2 = SoftReference.dereference(this.myCurrentEditor);
            if (editor2 != null && EditorMouseHoverPopupControl.arePopupsDisabled((Editor)editor2)) {
                this.closeHint();
            }
        });
        LaterInvocator.addModalityStateListener(new ModalityStateListener(){

            @Override
            public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
                if (modalEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditorMouseHoverPopupManager.this.cancelProcessingAndCloseHint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntity", "com/intellij/openapi/editor/EditorMouseHoverPopupManager$2", "beforeModalityStateChanged"));
            }
        }, this);
        IdeEventQueue.getInstance().addDispatcher(event -> {
            if (event.getID() == 401) {
                this.cancelCurrentProcessing();
            }
            return false;
        }, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(AnActionListener.TOPIC, new MyActionListener());
    }

    @Override
    public void dispose() {
    }

    protected void handleMouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(0);
        }
        long startTimestamp = System.currentTimeMillis();
        this.cancelCurrentProcessing();
        if (this.ignoreEvent(e)) {
            return;
        }
        Editor editor2 = e.getEditor();
        if (EditorMouseHoverPopupManager.isPopupDisabled(editor2)) {
            this.closeHint();
            return;
        }
        int targetOffset = EditorMouseHoverPopupManager.getTargetOffset(e);
        if (targetOffset < 0) {
            this.closeHint();
            return;
        }
        this.myPreparationTask = ReadAction.nonBlocking(() -> this.createContext(editor2, targetOffset, startTimestamp)).coalesceBy(this).withDocumentsCommitted(Objects.requireNonNull(editor2.getProject())).expireWhen(() -> editor2.isDisposed()).finishOnUiThread(ModalityState.any(), context2 -> {
            Context.Relation relation;
            this.myPreparationTask = null;
            if (context2 == null || !editor2.getContentComponent().isShowing()) {
                this.closeHint();
                return;
            }
            Context.Relation relation2 = relation = this.isHintShown() ? context2.compareTo(this.myContext) : Context.Relation.DIFFERENT;
            if (relation == Context.Relation.SAME) {
                return;
            }
            if (relation == Context.Relation.DIFFERENT) {
                this.closeHint();
            }
            this.scheduleProcessing(editor2, (Context)context2, relation == Context.Relation.SIMILAR, false, false);
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    protected void cancelCurrentProcessing() {
        if (this.myPreparationTask != null) {
            this.myPreparationTask.cancel();
            this.myPreparationTask = null;
        }
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
            this.myCurrentProgress = null;
        }
    }

    protected void skipNextMovement() {
        this.mySkipNextMovement = true;
    }

    protected void scheduleProcessing(@NotNull Editor editor2, @NotNull Context context2, boolean updateExistingPopup, boolean forceShowing, boolean requestFocus) {
        if (editor2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(2);
        }
        ProgressIndicatorBase progress = new ProgressIndicatorBase();
        this.myCurrentProgress = progress;
        this.myAlarm.addRequest(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(editor2);
            EditorHoverInfo info = context2.calcInfo(topLevelEditor);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (progress != this.myCurrentProgress) {
                    return;
                }
                this.myCurrentProgress = null;
                if (info == null || !topLevelEditor.getContentComponent().isShowing() || !forceShowing && EditorMouseHoverPopupManager.isPopupDisabled(topLevelEditor)) {
                    return;
                }
                VisualPosition position = context2.getPopupPosition(topLevelEditor);
                PopupBridge popupBridge = new PopupBridge(editor2, position);
                JComponent component2 = info.createComponent(topLevelEditor, popupBridge, requestFocus);
                if (component2 == null) {
                    this.closeHint();
                } else {
                    if (updateExistingPopup && this.isHintShown()) {
                        this.updateHint(component2, popupBridge);
                    } else {
                        AbstractPopup hint = EditorMouseHoverPopupManager.createHint(component2, popupBridge, requestFocus);
                        this.showHintInEditor(hint, topLevelEditor, position);
                        this.myPopupReference = new WeakReference<AbstractPopup>(hint);
                        this.myCurrentEditor = new WeakReference<Editor>(topLevelEditor);
                    }
                    this.myContext = context2;
                }
            });
        }, progress), context2.getShowingDelay());
    }

    private boolean ignoreEvent(EditorMouseEvent e) {
        if (this.mySkipNextMovement) {
            this.mySkipNextMovement = false;
            return true;
        }
        Rectangle currentHintBounds = this.getCurrentHintBounds(e.getEditor());
        return this.myMouseMovementTracker.isMovingTowards(e.getMouseEvent(), currentHintBounds) || currentHintBounds != null && this.myKeepPopupOnMouseMove;
    }

    protected static boolean isPopupDisabled(Editor editor2) {
        return EditorMouseHoverPopupManager.isAnotherAppInFocus() || EditorMouseHoverPopupControl.arePopupsDisabled((Editor)editor2) || LookupManager.getActiveLookup(editor2) != null || EditorMouseHoverPopupManager.isAnotherPopupFocused() || EditorMouseHoverPopupManager.isContextMenuShown();
    }

    private static boolean isAnotherAppInFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null;
    }

    private static boolean isAnotherPopupFocused() {
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return popup2 != null && !popup2.isDisposed();
    }

    private static boolean isContextMenuShown() {
        return MenuSelectionManager.defaultManager().getSelectedPath().length > 0;
    }

    private Rectangle getCurrentHintBounds(Editor editor2) {
        AbstractPopup popup2 = this.getCurrentHint();
        if (popup2 == null) {
            return null;
        }
        Dimension size = popup2.getSize();
        if (size == null) {
            return null;
        }
        Rectangle result2 = new Rectangle(popup2.getLocationOnScreen(), size);
        int borderTolerance = editor2.getLineHeight() / 3;
        result2.grow(borderTolerance, borderTolerance);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showHintInEditor(AbstractPopup hint, Editor editor2, @NotNull VisualPosition position) {
        if (position == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(3);
        }
        this.closeHint();
        this.myMouseMovementTracker.reset();
        this.myKeepPopupOnMouseMove = false;
        editor2.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, (Object)position);
        try {
            hint.showInBestPositionFor(editor2);
        }
        finally {
            editor2.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
        }
        Window window = hint.getPopupWindow();
        if (window != null) {
            window.setFocusableWindowState(true);
            IdeEventQueue.getInstance().addDispatcher(e -> {
                if (e.getID() == 501 && e.getSource() == window) {
                    this.myKeepPopupOnMouseMove = true;
                } else if (e.getID() == 200 && !EditorMouseHoverPopupManager.isParentWindow(window, e.getSource())) {
                    this.closeHint();
                }
                return false;
            }, (Disposable)hint);
        }
    }

    private static boolean isParentWindow(@NotNull Window parent, Object potentialChild) {
        if (parent == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(4);
        }
        return parent == potentialChild || potentialChild instanceof Component && EditorMouseHoverPopupManager.isParentWindow(parent, ((Component)potentialChild).getParent());
    }

    protected static AbstractPopup createHint(JComponent component2, PopupBridge popupBridge, boolean requestFocus) {
        WrapperPanel wrapper2 = new WrapperPanel(component2);
        AbstractPopup popup2 = (AbstractPopup)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)wrapper2, component2).setResizable(true).setFocusable(requestFocus).setRequestFocus(requestFocus).setModalContext(false).createPopup();
        popupBridge.setPopup(popup2);
        return popup2;
    }

    protected void updateHint(JComponent component2, PopupBridge popupBridge) {
        AbstractPopup popup2 = this.getCurrentHint();
        if (popup2 != null) {
            WrapperPanel wrapper2 = (WrapperPanel)popup2.getComponent();
            wrapper2.setContent(component2);
            EditorMouseHoverPopupManager.validatePopupSize(popup2);
            popupBridge.setPopup(popup2);
        }
    }

    static void validatePopupSize(@NotNull AbstractPopup popup2) {
        JComponent component2;
        if (popup2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(5);
        }
        if ((component2 = popup2.getComponent()) != null) {
            popup2.setSize(component2.getPreferredSize());
        }
    }

    private static int getTargetOffset(EditorMouseEvent event) {
        Editor editor2 = event.getEditor();
        if (editor2 instanceof EditorEx && editor2.getProject() != null && event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().getModifiers() == 0 && event.isOverText() && event.getCollapsedFoldRegion() == null) {
            return event.getOffset();
        }
        return -1;
    }

    protected Context createContext(Editor editor2, int offset, long startTimestamp) {
        Project project2 = Objects.requireNonNull(editor2.getProject());
        HighlightInfo info = null;
        if (!Registry.is("ide.disable.editor.tooltips")) {
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
            boolean highestPriorityOnly = !Registry.is("ide.tooltip.showAllSeverities");
            info = daemonCodeAnalyzer.findHighlightsByOffset(editor2.getDocument(), offset, false, highestPriorityOnly, HighlightInfoType.SYMBOL_TYPE_SEVERITY);
        }
        PsiElement elementForQuickDoc = EditorMouseHoverPopupManager.findElementForQuickDoc(editor2, offset, project2);
        return info == null && elementForQuickDoc == null ? null : new Context(startTimestamp, offset, info, elementForQuickDoc);
    }

    @Nullable
    protected static PsiElement findElementForQuickDoc(@NotNull Editor editor2, int offset, @NotNull Project project2) {
        if (editor2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(7);
        }
        if (!EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement()) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (psiFile == null) {
            return null;
        }
        PsiElement result2 = EditorMouseHoverPopupManager.findElementForQuickDoc(project2, psiFile, offset);
        if (result2 instanceof PsiWhiteSpace || result2 instanceof PsiPlainText) {
            return null;
        }
        return result2;
    }

    @Nullable
    private static PsiElement findElementForQuickDoc(@NotNull Project project2, @NotNull PsiFile psiFile, int offset) {
        PsiElement injected;
        if (project2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(8);
        }
        if (psiFile == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(9);
        }
        return (injected = InjectedLanguageManager.getInstance(project2).findInjectedElementAt(psiFile, offset)) != null ? injected : psiFile.findElementAt(offset);
    }

    protected void cancelProcessingAndCloseHint() {
        this.cancelCurrentProcessing();
        this.closeHint();
    }

    protected void closeHint() {
        AbstractPopup hint = this.getCurrentHint();
        if (hint != null) {
            hint.cancel();
        }
        this.myPopupReference = null;
        this.myCurrentEditor = null;
        this.myContext = null;
    }

    @ApiStatus.Internal
    public boolean isHintShown() {
        return this.getCurrentHint() != null;
    }

    protected AbstractPopup getCurrentHint() {
        if (this.myPopupReference == null) {
            return null;
        }
        AbstractPopup hint = this.myPopupReference.get();
        if (hint == null || !hint.isVisible()) {
            if (hint != null) {
                hint.cancel();
            }
            this.myPopupReference = null;
            this.myCurrentEditor = null;
            this.myContext = null;
            return null;
        }
        return hint;
    }

    public void showInfoTooltip(@NotNull Editor editor2, @NotNull HighlightInfo info, int offset, boolean requestFocus, final boolean showImmediately) {
        if (editor2 == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(10);
        }
        if (info == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(11);
        }
        if (editor2.getProject() == null) {
            return;
        }
        this.cancelProcessingAndCloseHint();
        Context context2 = new Context(System.currentTimeMillis(), offset, info, null){

            @Override
            public long getShowingDelay() {
                return showImmediately ? 0L : super.getShowingDelay();
            }

            @Override
            public boolean showDocumentation() {
                return false;
            }
        };
        this.scheduleProcessing(editor2, context2, false, true, requestFocus);
    }

    @NotNull
    public static EditorMouseHoverPopupManager getInstance() {
        EditorMouseHoverPopupManager editorMouseHoverPopupManager = ApplicationManager.getApplication().getService(EditorMouseHoverPopupManager.class);
        if (editorMouseHoverPopupManager == null) {
            EditorMouseHoverPopupManager.$$$reportNull$$$0(12);
        }
        return editorMouseHoverPopupManager;
    }

    @Deprecated
    @Nullable
    public DocumentationComponent getDocumentationComponent() {
        AbstractPopup hint = this.getCurrentHint();
        return hint == null ? null : UIUtil.findComponentOfType(hint.getComponent(), DocumentationComponent.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleMouseMoved";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleProcessing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showHintInEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isParentWindow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validatePopupSize";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementForQuickDoc";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showInfoTooltip";
                break;
            }
            case 12: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyActionListener
    implements AnActionListener {
        private MyActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            Component contextComponent;
            JBPopup contextPopup;
            if (action2 == null) {
                MyActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyActionListener.$$$reportNull$$$0(1);
            }
            if (action2 instanceof HintManagerImpl.ActionToIgnore) {
                return;
            }
            AbstractPopup currentHint = EditorMouseHoverPopupManager.getInstance().getCurrentHint();
            if (currentHint != null && (contextPopup = PopupUtil.getPopupContainerFor((Component)(contextComponent = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)))) == currentHint) {
                return;
            }
            EditorMouseHoverPopupManager.getInstance().cancelProcessingAndCloseHint();
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyActionListener.$$$reportNull$$$0(2);
            }
            EditorMouseHoverPopupManager.getInstance().cancelProcessingAndCloseHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$MyActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyEditorMouseEventListener
    implements EditorMouseListener {
        MyEditorMouseEventListener() {
        }

        public void mouseEntered(@NotNull EditorMouseEvent event) {
            if (event == null) {
                MyEditorMouseEventListener.$$$reportNull$$$0(0);
            }
            EditorMouseHoverPopupManager.getInstance().skipNextMovement();
        }

        public void mouseExited(@NotNull EditorMouseEvent event) {
            if (event == null) {
                MyEditorMouseEventListener.$$$reportNull$$$0(1);
            }
            EditorMouseHoverPopupManager.getInstance().cancelCurrentProcessing();
        }

        public void mousePressed(@NotNull EditorMouseEvent event) {
            if (event == null) {
                MyEditorMouseEventListener.$$$reportNull$$$0(2);
            }
            EditorMouseHoverPopupManager.getInstance().cancelProcessingAndCloseHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$MyEditorMouseEventListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyEditorMouseMotionEventListener
    implements EditorMouseMotionListener {
        MyEditorMouseMotionEventListener() {
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseMotionEventListener.$$$reportNull$$$0(0);
            }
            EditorMouseHoverPopupManager.getInstance().handleMouseMoved(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/EditorMouseHoverPopupManager$MyEditorMouseMotionEventListener", "mouseMoved"));
        }
    }

    protected static class Context {
        private final long startTimestamp;
        private final int targetOffset;
        private final WeakReference<HighlightInfo> highlightInfo;
        private final WeakReference<PsiElement> elementForQuickDoc;

        protected Context(long startTimestamp, int targetOffset, HighlightInfo highlightInfo, PsiElement elementForQuickDoc) {
            this.startTimestamp = startTimestamp;
            this.targetOffset = targetOffset;
            this.highlightInfo = highlightInfo == null ? null : new WeakReference<HighlightInfo>(highlightInfo);
            this.elementForQuickDoc = elementForQuickDoc == null ? null : new WeakReference<PsiElement>(elementForQuickDoc);
        }

        @Nullable
        public PsiElement getElementForQuickDoc() {
            return SoftReference.dereference(this.elementForQuickDoc);
        }

        public boolean showDocumentation() {
            return true;
        }

        public HighlightInfo getHighlightInfo() {
            return SoftReference.dereference(this.highlightInfo);
        }

        public int getTargetOffset() {
            return this.targetOffset;
        }

        private Relation compareTo(Context other) {
            if (other == null) {
                return Relation.DIFFERENT;
            }
            HighlightInfo highlightInfo = this.getHighlightInfo();
            if (!Objects.equals(highlightInfo, other.getHighlightInfo())) {
                return Relation.DIFFERENT;
            }
            return Objects.equals(this.getElementForQuickDoc(), other.getElementForQuickDoc()) ? Relation.SAME : (highlightInfo == null ? Relation.DIFFERENT : Relation.SIMILAR);
        }

        public long getShowingDelay() {
            return Math.max(0L, (long)EditorSettingsExternalizable.getInstance().getTooltipsDelay() - (System.currentTimeMillis() - this.startTimestamp));
        }

        private static int getElementStartHostOffset(@NotNull PsiElement element2) {
            Document document;
            if (element2 == null) {
                Context.$$$reportNull$$$0(0);
            }
            int offset = element2.getTextRange().getStartOffset();
            Project project2 = element2.getProject();
            PsiFile containingFile = element2.getContainingFile();
            if (containingFile != null && InjectedLanguageManager.getInstance(project2).isInjectedFragment(containingFile) && (document = PsiDocumentManager.getInstance(project2).getDocument(containingFile)) instanceof DocumentWindow) {
                return ((DocumentWindow)document).injectedToHost(offset);
            }
            return offset;
        }

        @NotNull
        protected VisualPosition getPopupPosition(Editor editor2) {
            HighlightInfo highlightInfo = this.getHighlightInfo();
            if (highlightInfo == null) {
                int offset = this.targetOffset;
                PsiElement elementForQuickDoc = this.getElementForQuickDoc();
                if (elementForQuickDoc != null && elementForQuickDoc.isValid()) {
                    offset = Context.getElementStartHostOffset(elementForQuickDoc);
                }
                VisualPosition visualPosition = editor2.offsetToVisualPosition(offset);
                if (visualPosition == null) {
                    Context.$$$reportNull$$$0(1);
                }
                return visualPosition;
            }
            VisualPosition targetPosition = editor2.offsetToVisualPosition(this.targetOffset);
            VisualPosition endPosition = editor2.offsetToVisualPosition(highlightInfo.getEndOffset());
            if (endPosition.line <= targetPosition.line) {
                VisualPosition visualPosition = targetPosition;
                if (visualPosition == null) {
                    Context.$$$reportNull$$$0(2);
                }
                return visualPosition;
            }
            Point targetPoint = editor2.visualPositionToXY(targetPosition);
            Point endPoint = editor2.visualPositionToXY(endPosition);
            Point resultPoint = new Point(targetPoint.x, endPoint.x > targetPoint.x ? endPoint.y : editor2.visualLineToY(endPosition.line - 1));
            VisualPosition visualPosition = editor2.xyToVisualPosition(resultPoint);
            if (visualPosition == null) {
                Context.$$$reportNull$$$0(3);
            }
            return visualPosition;
        }

        @Nullable
        protected EditorHoverInfo calcInfo(@NotNull Editor editor2) {
            if (editor2 == null) {
                Context.$$$reportNull$$$0(4);
            }
            HighlightHoverInfo highlightHoverInfo = HighlightHoverInfo.highlightHoverInfo(editor2, this.getHighlightInfo());
            DocumentationHoverInfo documentationHoverInfo = this.documentationHoverInfo(editor2);
            return highlightHoverInfo == null && documentationHoverInfo == null ? null : new EditorHoverInfo(highlightHoverInfo, documentationHoverInfo);
        }

        @Nullable
        private DocumentationHoverInfo documentationHoverInfo(@NotNull Editor editor2) {
            if (editor2 == null) {
                Context.$$$reportNull$$$0(5);
            }
            try {
                return QuickDocUtil.isDocumentationV2Enabled() ? (this.showDocumentation() && EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement() ? DocumentationTargetHoverInfoKt.calcTargetDocumentationInfo(Objects.requireNonNull(editor2.getProject()), editor2, this.targetOffset) : null) : this.documentationPsiHoverInfo(editor2);
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
        }

        @Deprecated
        @Nullable
        private DocumentationPsiHoverInfo documentationPsiHoverInfo(@NotNull Editor editor2) {
            if (editor2 == null) {
                Context.$$$reportNull$$$0(6);
            }
            @Nls String quickDocMessage = null;
            DocumentationProvider provider2 = null;
            PsiElement targetElement = null;
            PsiElement element2 = this.getElementForQuickDoc();
            if (element2 != null) {
                try {
                    Project project2 = Objects.requireNonNull(editor2.getProject());
                    DocumentationManager documentationManager = ReadAction.compute(() -> project2.isDisposed() ? null : DocumentationManager.getInstance(project2));
                    if (documentationManager != null && (targetElement = this.findTargetElement(editor2, element2, documentationManager)) != null) {
                        Pair<@NlsSafe String, DocumentationProvider> docWithProvider = documentationManager.getDocumentationAndProvider(targetElement, element2, true);
                        quickDocMessage = (String)docWithProvider.first;
                        provider2 = (DocumentationProvider)docWithProvider.second;
                        if (quickDocMessage != null && quickDocMessage.length() > 100000) {
                            quickDocMessage = quickDocMessage.substring(0, 100000);
                        }
                        if (quickDocMessage != null) {
                            PsiElement finalTargetElement = targetElement;
                            String finalQuickDocMessage = quickDocMessage;
                            DocumentationProvider finalProvider = provider2;
                            quickDocMessage = ReadAction.compute(() -> documentationManager.decorate(finalTargetElement, finalQuickDocMessage, null, finalProvider));
                        }
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException project2) {
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            if (quickDocMessage != null) {
                return new DocumentationPsiHoverInfo(quickDocMessage, targetElement, provider2);
            }
            return null;
        }

        @Deprecated
        @Nullable
        protected PsiElement findTargetElement(@NotNull Editor editor2, PsiElement element2, DocumentationManager documentationManager) {
            if (editor2 == null) {
                Context.$$$reportNull$$$0(7);
            }
            return ReadAction.nonBlocking(() -> {
                if (element2.isValid()) {
                    PsiFile containingFile = element2.getContainingFile();
                    Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, null, containingFile);
                    int offset = injectedEditor instanceof EditorWindow ? ((EditorWindow)injectedEditor).getDocument().hostToInjected(this.targetOffset) : this.targetOffset;
                    return documentationManager.findTargetElementAtOffset(injectedEditor, offset, containingFile, element2);
                }
                return null;
            }).executeSynchronously();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$Context";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/EditorMouseHoverPopupManager$Context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupPosition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementStartHostOffset";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "documentationHoverInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "documentationPsiHoverInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findTargetElement";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum Relation {
            SAME,
            SIMILAR,
            DIFFERENT;

        }
    }
}

