/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectWidePathMacroContributor;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ProjectPathMacroManager
extends PathMacroManager {
    private final @NotNull Supplier<@Nullable @SystemIndependent String> myProjectFilePathPointer;
    private final @NotNull Supplier<@Nullable @SystemIndependent String> myBasePathPointer;
    private final @Nullable Supplier<@NotNull @SystemIndependent String> myNamePointer;

    public ProjectPathMacroManager(@NotNull Project project2) {
        if (project2 == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(0);
        }
        super(PathMacros.getInstance());
        this.myProjectFilePathPointer = project2::getProjectFilePath;
        this.myBasePathPointer = project2::getBasePath;
        this.myNamePointer = !project2.isDefault() ? project2::getName : null;
    }

    @NonInjectable
    private ProjectPathMacroManager(@NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull Supplier<@Nullable @SystemIndependent String> basePathPointer, @Nullable Supplier<@NotNull @SystemIndependent String> namePointer) {
        if (projectFilePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(1);
        }
        if (basePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(2);
        }
        super(PathMacros.getInstance());
        this.myProjectFilePathPointer = projectFilePathPointer;
        this.myBasePathPointer = basePathPointer;
        this.myNamePointer = namePointer;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        String projectFile;
        ExpandMacroToPathMap result2 = super.getExpandMacroMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result2, "PROJECT_DIR", this.myBasePathPointer.get());
        if (this.myNamePointer != null) {
            result2.addMacroExpand("PROJECT_NAME", this.myNamePointer.get());
        }
        if ((projectFile = this.myProjectFilePathPointer.get()) != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result2.addMacroExpand(entry.getKey(), entry.getValue());
            }
        }
        ExpandMacroToPathMap expandMacroToPathMap = result2;
        if (expandMacroToPathMap == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(3);
        }
        return expandMacroToPathMap;
    }

    @Override
    @NotNull
    protected ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result2 = super.computeReplacePathMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result2, "PROJECT_DIR", this.myBasePathPointer.get(), null);
        String projectFile = this.myProjectFilePathPointer.get();
        if (projectFile != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result2.addMacroReplacement(entry.getValue(), entry.getKey());
            }
        }
        ReplacePathToMacroMap replacePathToMacroMap = result2;
        if (replacePathToMacroMap == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(4);
        }
        return replacePathToMacroMap;
    }

    public static ProjectPathMacroManager createInstance(@NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull Supplier<@SystemIndependent @Nullable String> basePathPointer, @Nullable Supplier<@SystemIndependent @NotNull String> namePointer) {
        if (projectFilePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(5);
        }
        if (basePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(6);
        }
        return new ProjectPathMacroManager(projectFilePathPointer, basePathPointer, namePointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePathPointer";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePathPointer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ProjectPathMacroManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ProjectPathMacroManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeReplacePathMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

