/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.largeFilesEditor.Utils;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.FrameSearcher;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskBase;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.io.IOException;
import java.util.ArrayList;

public class RangeSearchTask
extends SearchTaskBase {
    private static final Logger logger = Logger.getInstance(RangeSearchTask.class);
    private final Callback myCallback;
    private ProgressIndicator myProgressIndicator;

    public RangeSearchTask(SearchTaskOptions options, Project project2, FileDataProviderForSearch fileDataProviderForSearch, Callback callback) {
        super(options, project2, fileDataProviderForSearch);
        this.myCallback = callback;
    }

    @NlsContexts.ProgressTitle
    public String getTitleForBackgroundableTask() {
        int maxStrToFindLength = 16;
        int maxFileNameLength = 20;
        String strToFind = Utils.cutToMaxLength(this.options.stringToFind, 16);
        String fileName = Utils.cutToMaxLength(this.fileDataProviderForSearch.getName(), 20);
        return EditorBundle.message((String)"large.file.editor.title.searching.for.some.string.in.some.file", (Object[])new Object[]{strToFind, fileName});
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
    }

    @Override
    protected void doRun() {
        FrameSearcher searcher2 = this.createFrameSearcher(this.options, this.project);
        int tailLength = RangeSearchTask.getTailLength(this.options);
        try {
            long pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
            long curPageNumber = RangeSearchTask.getPageNumberForBeginning(pagesAmount, this.options);
            if (RangeSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                this.myCallback.tellSearchIsFinished(this, curPageNumber);
                return;
            }
            String prevPageText = curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
            String curPageText = this.fileDataProviderForSearch.getPage_wait(curPageNumber).getText();
            String nextPageText = curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
            String tailText = RangeSearchTask.getTailFromPage(nextPageText, tailLength);
            char prefixSymbol = RangeSearchTask.getPrefixSymbol(prevPageText);
            char postfixSymbol = RangeSearchTask.getPostfixSymbol(nextPageText, tailLength);
            while (true) {
                searcher2.setFrame(curPageNumber, prefixSymbol, curPageText, tailText, postfixSymbol);
                ArrayList<SearchResult> allMatchesAtFrame = searcher2.findAllMatchesAtFrame();
                this.myCallback.tellFrameSearchResultsFound(this, curPageNumber, allMatchesAtFrame);
                if (this.isShouldStop()) {
                    if (this.myProgressIndicator != null) {
                        this.myProgressIndicator.cancel();
                    }
                    this.myCallback.tellSearchIsStopped(curPageNumber);
                    return;
                }
                if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                    this.shouldStop();
                    this.myCallback.tellSearchIsStopped(curPageNumber);
                    return;
                }
                pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
                if (this.options.searchForwardDirection) {
                    prevPageText = curPageText;
                    curPageText = nextPageText;
                    nextPageText = ++curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
                } else {
                    nextPageText = curPageText;
                    curPageText = prevPageText;
                    String string2 = prevPageText = --curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
                }
                if (RangeSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                    this.myCallback.tellSearchIsFinished(this, RangeSearchTask.getPreviousPageNumber(curPageNumber, this.options));
                    return;
                }
                if (this.isShouldStop()) {
                    if (this.myProgressIndicator != null) {
                        this.myProgressIndicator.cancel();
                    }
                    this.myCallback.tellSearchIsStopped(curPageNumber);
                    return;
                }
                if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                    this.shouldStop();
                    this.myCallback.tellSearchIsStopped(curPageNumber);
                    return;
                }
                tailText = RangeSearchTask.getTailFromPage(nextPageText, tailLength);
                prefixSymbol = RangeSearchTask.getPrefixSymbol(prevPageText);
                postfixSymbol = RangeSearchTask.getPostfixSymbol(nextPageText, tailLength);
            }
        }
        catch (IOException e) {
            logger.warn(e);
            this.myCallback.tellSearchCatchedException(this, e);
            return;
        }
    }

    public static interface Callback {
        public void tellSearchIsFinished(RangeSearchTask var1, long var2);

        public void tellFrameSearchResultsFound(RangeSearchTask var1, long var2, ArrayList<SearchResult> var4);

        public void tellSearchIsStopped(long var1);

        public void tellSearchCatchedException(RangeSearchTask var1, IOException var2);
    }
}

