/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class MutableMarker {
    private final PsiBuilder.Marker myStartMarker;
    private IElementType myResultType;
    private final int myInitialPathLength;
    private final LinkedList<IElementType> myPath;
    private Mode myMode;

    public MutableMarker(LinkedList<IElementType> path2, PsiBuilder.Marker startMarker, int initialPathLength) {
        this.myPath = path2;
        this.myStartMarker = startMarker;
        this.myInitialPathLength = initialPathLength;
        this.myMode = startMarker instanceof LighterASTNode && ((LighterASTNode)((Object)startMarker)).getTokenType() != null ? Mode.COMMITTED : Mode.READY;
    }

    public MutableMarker(LinkedList<IElementType> path2, PsiBuilder builder2) {
        this.myPath = path2;
        this.myStartMarker = (PsiBuilder.Marker)((Object)builder2.getLatestDoneMarker());
        this.myInitialPathLength = path2.size();
        this.myResultType = this.myStartMarker != null ? ((LighterASTNode)((Object)this.myStartMarker)).getTokenType() : null;
        this.myMode = this.myResultType != null ? Mode.COMMITTED : Mode.READY;
    }

    public boolean isCommitted() {
        return this.myMode == Mode.COMMITTED;
    }

    public boolean isDropped() {
        return this.myMode == Mode.DROPPED;
    }

    public boolean isError() {
        return this.myMode == Mode.ERROR;
    }

    public boolean isReady() {
        return this.myMode == Mode.READY;
    }

    public MutableMarker setResultType(IElementType resultType) {
        this.myResultType = resultType;
        return this;
    }

    public IElementType getResultType() {
        return this.myResultType;
    }

    public void finish() {
        if (this.myMode == Mode.READY) {
            if (this.myResultType == null) {
                this.myMode = Mode.DROPPED;
                this.myStartMarker.drop();
            } else {
                this.myMode = Mode.COMMITTED;
                this.myStartMarker.done(this.myResultType);
                this.restorePath();
                this.myPath.addLast(this.myResultType);
            }
        }
    }

    private void restorePath() {
        while (this.myPath.size() > this.myInitialPathLength) {
            this.myPath.removeLast();
        }
    }

    public MutableMarker precede() {
        return new MutableMarker(this.myPath, this.myStartMarker.precede(), this.myInitialPathLength);
    }

    public void finish(IElementType type) {
        this.setResultType(type);
        this.finish();
    }

    public void drop() {
        assert (this.myMode == Mode.READY) : this.myMode;
        this.myMode = Mode.DROPPED;
        this.myStartMarker.drop();
    }

    public void rollback() {
        assert (this.myMode == Mode.READY) : this.myMode;
        this.myMode = Mode.DROPPED;
        this.restorePath();
        this.myStartMarker.rollbackTo();
    }

    public void error(@NotNull @NlsContexts.ParsingError String message2) {
        if (message2 == null) {
            MutableMarker.$$$reportNull$$$0(0);
        }
        assert (this.myMode == Mode.READY) : this.myMode;
        this.myMode = Mode.ERROR;
        this.myStartMarker.error(message2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/pratt/MutableMarker", "error"));
    }

    static enum Mode {
        READY,
        DROPPED,
        COMMITTED,
        ERROR;

    }
}

