/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.LangBundle;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGithubTagDownloadedProjectGenerator
extends WebProjectTemplate<GithubTagInfo> {
    private static final Logger LOG = Logger.getInstance(AbstractGithubTagDownloadedProjectGenerator.class);

    @NotNull
    @Nls
    public final String getName() {
        String string2 = this.getDisplayName();
        if (string2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    @Nls
    protected abstract String getDisplayName();

    @NotNull
    public abstract String getGithubUserName();

    @NotNull
    public abstract String getGithubRepositoryName();

    @Nullable
    public abstract String getDescription();

    @NlsContexts.ProgressTitle
    private String getTitle() {
        return this.getDisplayName();
    }

    @Nullable
    public String getHelpId() {
        return "create.from.template." + this.getGithubUserName() + "." + this.getGithubRepositoryName();
    }

    @Nullable
    public String getDefaultBranchName() {
        return "master";
    }

    public void generateProject(@NotNull Project project2, @NotNull VirtualFile baseDir, @NotNull GithubTagInfo tag, @NotNull Module module) {
        if (project2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(4);
        }
        try {
            this.unpackToDir(project2, VfsUtilCore.virtualToIoFile(baseDir), tag);
        }
        catch (GeneratorException e) {
            this.reportError(project2, e);
        }
        ApplicationManager.getApplication().runWriteAction(() -> baseDir.refresh(true, true));
    }

    @NotNull
    public GithubProjectGeneratorPeer createPeer() {
        return new GithubProjectGeneratorPeer(this);
    }

    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private void unpackToDir(@Nullable Project project2, @NotNull File extractToDir, @NotNull GithubTagInfo tag) throws GeneratorException {
        if (extractToDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(5);
        }
        if (tag == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(6);
        }
        File zipArchiveFile = this.getCacheFile(tag);
        String primaryUrl = this.getPrimaryZipArchiveUrlForDownload(tag);
        boolean downloaded = false;
        if (primaryUrl != null) {
            try {
                this.downloadAndUnzip(project2, primaryUrl, zipArchiveFile, extractToDir, false);
                downloaded = true;
            }
            catch (GeneratorException e) {
                LOG.info("Can't download " + primaryUrl, e);
                FileUtil.delete(zipArchiveFile);
            }
        }
        if (!downloaded) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new GeneratorException(LangBundle.message("dialog.message.download.skipped.in.unit.test.mode", tag.getZipballUrl()));
            }
            this.downloadAndUnzip(project2, tag.getZipballUrl(), zipArchiveFile, extractToDir, true);
        }
    }

    private void downloadAndUnzip(@Nullable Project project2, @NotNull String url, @NotNull File zipArchiveFile, @NotNull File extractToDir, boolean retryOnError) throws GeneratorException {
        if (url == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(7);
        }
        if (zipArchiveFile == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(8);
        }
        if (extractToDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                File file2 = URLUtil.urlToFile(new URL(url));
                ZipUtil.unzip(null, extractToDir, file2, null, null, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        GithubDownloadUtil.downloadContentToFileWithProgressSynchronously(project2, url, this.getTitle(), zipArchiveFile, this.getGithubUserName(), this.getGithubRepositoryName(), retryOnError);
        LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
        ZipUtil.unzipWithProgressSynchronously(project2, this.getTitle(), zipArchiveFile, extractToDir, this.getPathConvertor(), true);
    }

    @Nullable
    protected NullableFunction<String, String> getPathConvertor() {
        return null;
    }

    @Nullable
    public abstract String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo var1);

    @NotNull
    private File getCacheFile(@NotNull GithubTagInfo tag) {
        if (tag == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(10);
        }
        String fileName = URLUtil.encodeURIComponent(tag.getName() + ".zip");
        File file2 = GithubDownloadUtil.findCacheFile(this.getGithubUserName(), this.getGithubRepositoryName(), fileName);
        if (file2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(11);
        }
        return file2;
    }

    private void reportError(@NotNull Project project2, @NotNull GeneratorException e) {
        if (project2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(12);
        }
        if (e == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(13);
        }
        String message2 = LangBundle.message("dialog.message.error.creating.project", this.getDisplayName());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message2, e);
            return;
        }
        LOG.info(message2, e);
        String title = LangBundle.message("dialog.title.create.project", this.getDisplayName());
        Messages.showErrorDialog((Project)project2, (String)(message2 + ". " + e.getMessage()), (String)title);
    }

    public ActionLink createGitHubLink() {
        ActionLink link = new ActionLink(LangBundle.message("link.label.on.github", this.getName()), e -> BrowserUtil.open((String)("https://github.com/" + this.getGithubUserName() + "/" + this.getGithubRepositoryName())));
        link.setFont(UIUtil.getLabelFont(UIUtil.FontSize.SMALL));
        return link;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractToDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipArchiveFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unpackToDir";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndUnzip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

