/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider,
ExternalDocumentationHandler {
    private static final Logger LOG = Logger.getInstance(CompositeDocumentationProvider.class);
    private final List<DocumentationProvider> myProviders;

    public static DocumentationProvider wrapProviders(Collection<? extends DocumentationProvider> providers2) {
        ArrayList<DocumentationProvider> list2 = new ArrayList<DocumentationProvider>();
        for (DocumentationProvider documentationProvider : providers2) {
            if (documentationProvider instanceof CompositeDocumentationProvider) {
                list2.addAll(((CompositeDocumentationProvider)documentationProvider).getProviders());
                continue;
            }
            if (documentationProvider == null) continue;
            list2.add(documentationProvider);
        }
        return new CompositeDocumentationProvider(Collections.unmodifiableList(list2));
    }

    private CompositeDocumentationProvider(List<DocumentationProvider> providers2) {
        this.myProviders = providers2;
    }

    @NotNull
    public List<DocumentationProvider> getAllProviders() {
        List<DocumentationProvider> providers2 = this.myProviders;
        List extensions2 = EP_NAME.getExtensionList();
        LinkedHashSet<DocumentationProvider> result2 = new LinkedHashSet<DocumentationProvider>(providers2.size() + extensions2.size());
        result2.addAll(providers2);
        result2.addAll(extensions2);
        List<DocumentationProvider> list2 = List.copyOf(result2);
        if (list2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public List<DocumentationProvider> getProviders() {
        List<DocumentationProvider> list2 = this.myProviders;
        if (list2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public boolean handleExternal(PsiElement element2, PsiElement originalElement) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!(provider2 instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider2)).handleExternal(element2, originalElement)) continue;
            LOG.debug("handleExternal: ", provider2);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context2) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!(provider2 instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider2)).handleExternalLink(psiManager, link, context2)) continue;
            LOG.debug("handleExternalLink: ", provider2);
            return true;
        }
        return false;
    }

    @Override
    public boolean canFetchDocumentationLink(String link) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!(provider2 instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider2)).canFetchDocumentationLink(link)) continue;
            LOG.debug("canFetchDocumentationLink: ", provider2);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    @Nls
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element2) {
        if (link == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(2);
        }
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!(provider2 instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider2)).canFetchDocumentationLink(link)) continue;
            LOG.debug("fetchExternalDocumentation: ", provider2);
            String string2 = ((ExternalDocumentationHandler)((Object)provider2)).fetchExternalDocumentation(link, element2);
            if (string2 == null) {
                CompositeDocumentationProvider.$$$reportNull$$$0(3);
            }
            return string2;
        }
        throw new IllegalStateException("Unable to find a provider to fetch documentation link!");
    }

    @Override
    @Nls
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            String result2 = provider2.getQuickNavigateInfo(element2, originalElement);
            if (result2 == null) continue;
            LOG.debug("getQuickNavigateInfo: ", provider2);
            return result2;
        }
        return null;
    }

    @Override
    public List<String> getUrlFor(PsiElement element2, PsiElement originalElement) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            List<String> result2 = provider2.getUrlFor(element2, originalElement);
            if (result2 == null) continue;
            LOG.debug("getUrlFor: ", provider2);
            return result2;
        }
        return null;
    }

    @Override
    @Nls
    public String generateDoc(PsiElement element2, PsiElement originalElement) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            String result2 = provider2.generateDoc(element2, originalElement);
            if (result2 == null) continue;
            LOG.debug("generateDoc: ", provider2);
            return result2;
        }
        return null;
    }

    @Override
    @Nls
    public String generateHoverDoc(@NotNull PsiElement element2, @Nullable PsiElement originalElement) {
        if (element2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(4);
        }
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            String result2 = provider2.generateHoverDoc(element2, originalElement);
            if (result2 == null) continue;
            LOG.debug("generateHoverDoc: ", provider2);
            return result2;
        }
        return null;
    }

    @Override
    @Nls
    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        if (comment == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(5);
        }
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            String result2 = provider2.generateRenderedDoc(comment);
            if (result2 == null) continue;
            LOG.debug("generateRenderedDoc: ", provider2);
            return result2;
        }
        return null;
    }

    @Override
    public void collectDocComments(@NotNull PsiFile file2, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (file2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(7);
        }
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            provider2.collectDocComments(file2, sink);
        }
    }

    @Override
    @Nullable
    public PsiDocCommentBase findDocComment(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (range == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(9);
        }
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            PsiDocCommentBase result2 = provider2.findDocComment(file2, range);
            if (result2 == null) continue;
            LOG.debug("findDocComment: ", provider2);
            return result2;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            PsiElement result2 = provider2.getDocumentationElementForLookupItem(psiManager, object, element2);
            if (result2 == null) continue;
            LOG.debug("getDocumentationElementForLookupItem: ", provider2);
            return result2;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context2) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            PsiElement result2 = provider2.getDocumentationElementForLink(psiManager, link, context2);
            if (result2 == null) continue;
            LOG.debug("getDocumentationElementForLink: ", provider2);
            return result2;
        }
        return null;
    }

    @Nullable
    public CodeDocumentationProvider getFirstCodeDocumentationProvider() {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!(provider2 instanceof CodeDocumentationProvider)) continue;
            LOG.debug("getFirstCodeDocumentationProvider: ", provider2);
            return (CodeDocumentationProvider)provider2;
        }
        return null;
    }

    @Override
    @Nls
    public String fetchExternalDocumentation(Project project2, PsiElement element2, List<String> docUrls, boolean onHover) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            String doc;
            if (!(provider2 instanceof ExternalDocumentationProvider) || (doc = ((ExternalDocumentationProvider)((Object)provider2)).fetchExternalDocumentation(project2, element2, docUrls, onHover)) == null) continue;
            LOG.debug("fetchExternalDocumentation: ", provider2);
            return doc;
        }
        return null;
    }

    @Override
    public boolean hasDocumentationFor(PsiElement element2, PsiElement originalElement) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!CompositeDocumentationProvider.hasUrlsFor(provider2, element2, originalElement)) continue;
            LOG.debug("handleExternal(hasUrlsFor): ", provider2);
            return true;
        }
        return false;
    }

    @Override
    public boolean canPromptToConfigureDocumentation(PsiElement element2) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!(provider2 instanceof ExternalDocumentationProvider) || !((ExternalDocumentationProvider)((Object)provider2)).canPromptToConfigureDocumentation(element2)) continue;
            LOG.debug("canPromptToConfigureDocumentation: ", provider2);
            return true;
        }
        return false;
    }

    @Override
    public void promptToConfigureDocumentation(PsiElement element2) {
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            if (!(provider2 instanceof ExternalDocumentationProvider) || !((ExternalDocumentationProvider)((Object)provider2)).canPromptToConfigureDocumentation(element2)) continue;
            ((ExternalDocumentationProvider)((Object)provider2)).promptToConfigureDocumentation(element2);
            LOG.debug("promptToConfigureDocumentation: ", provider2);
            break;
        }
    }

    public static boolean hasUrlsFor(DocumentationProvider provider2, PsiElement element2, PsiElement originalElement) {
        List<String> urls = provider2.getUrlFor(element2, originalElement);
        return urls != null && !urls.isEmpty();
    }

    @Override
    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file2, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(11);
        }
        for (DocumentationProvider provider2 : this.getAllProviders()) {
            PsiElement element2 = provider2.getCustomDocumentationElement(editor2, file2, contextElement, targetOffset);
            if (element2 == null) continue;
            LOG.debug("getCustomDocumentationElement: ", provider2);
            return element2;
        }
        return null;
    }

    public String toString() {
        return this.getProviders().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/documentation/CompositeDocumentationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/documentation/CompositeDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchExternalDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetchExternalDocumentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateHoverDoc";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateRenderedDoc";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDocComments";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

