/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.editor.actions.CaretStopBoundary;
import com.intellij.openapi.editor.actions.CaretStopOptions;
import com.intellij.openapi.editor.actions.CaretStopOptionsTransposed;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.tabs.FileColorManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class EditorSettingsStatisticsCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("editor.settings.ide", 8);
    private static final EnumEventField<Settings> SETTING_ID = EventFields.Enum((String)"setting_id", Settings.class, it -> it.internalName);
    private static final IntEventField INT_VALUE_FIELD = EventFields.Int((String)"value");
    private static final StringEventField TRAILING_SPACES_FIELD = EventFields.String((String)"value", List.of("Whole", "Changed", "None"));
    private static final EnumEventField<SmartBackspaceMode> BACKSPACE_MODE = EventFields.Enum((String)"value", SmartBackspaceMode.class);
    private static final EnumEventField<CaretStopBoundaries> CARET_STOP_BOUNDARIES = EventFields.Enum((String)"value", CaretStopBoundaries.class);
    private static final VarargEventId SETTING = GROUP.registerVarargEvent("not.default", new EventField[]{EventFields.Enabled, SETTING_ID, EventFields.LanguageById, INT_VALUE_FIELD, TRAILING_SPACES_FIELD, BACKSPACE_MODE, CARET_STOP_BOUNDARIES});

    EditorSettingsStatisticsCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> set2 = new HashSet<MetricEvent>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsExternalizable esDefault = new EditorSettingsExternalizable(new EditorSettingsExternalizable.OsSpecificState());
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVirtualSpace(), Settings.CARET_AFTER_LINE_END, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCaretInsideTabs(), Settings.CARET_INSIDE_TABS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAdditionalPageAtBottom(), Settings.VIRTUAL_SPACE_AT_FILE_BOTTOM, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), Settings.SOFT_WRAPS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), Settings.SOFT_WRAPS_CONSOLE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), Settings.SOFT_WRAPS_PREVIEW, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseCustomSoftWrapIndent(), Settings.SOFT_WRAPS_RELATIVE_INDENT, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAllSoftWrapsShown(), Settings.SOFT_WRAPS_SHOW_ALL, new EventPair[0]);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es, esDefault, s -> s.getStripTrailingSpaces(), Settings.STRIP_TRAILING_SPACES, TRAILING_SPACES_FIELD);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isEnsureNewLineAtEOF(), Settings.ENSURE_NEWLINE_AT_EOF, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowQuickDocOnMouseOverElement(), Settings.QUICK_DOC_ON_MOUSE_HOVER, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlinkCaret(), Settings.BLINKING_CARET, new EventPair[0]);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es, esDefault, s -> s.getBlinkPeriod(), Settings.BLINK_PERIOD, INT_VALUE_FIELD);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlockCursor(), Settings.BLOCK_CARET, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRightMarginShown(), Settings.RIGHT_MARGIN, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isLineNumbersShown(), Settings.LINE_NUMBERS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.areGutterIconsShown(), Settings.GUTTER_ICONS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isFoldingOutlineShown(), Settings.FOLDING_OUTLINE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isLeadingWhitespacesShown(), Settings.SHOW_LEADING_WHITESPACE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isInnerWhitespacesShown(), Settings.SHOW_INNER_WHITESPACE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isTrailingWhitespacesShown(), Settings.SHOW_TRAILING_WHITESPACE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isIndentGuidesShown(), Settings.INDENT_GUIDES, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmoothScrolling(), Settings.ANIMATED_SCROLL, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isDndEnabled(), Settings.DRAG_N_DROP, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWheelFontChangeEnabled(), Settings.WHEEL_ZOOM, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWheelFontChangePersistent(), Settings.WHEEL_PERSISTENT, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isMouseClickSelectionHonorsCamelWords(), Settings.MOUSE_CAMEL, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVariableInplaceRenameEnabled(), Settings.INPLACE_RENAME, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isPreselectRename(), Settings.PRESELECT_ON_RENAME, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowInlineLocalDialog(), Settings.INLINE_DIALOG, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRefrainFromScrolling(), Settings.MINIMIZE_SCROLLING, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowNotificationAfterReformat(), Settings.AFTER_REFORMAT_NOTIFICATION, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowNotificationAfterOptimizeImports(), Settings.AFTER_OPTIMIZE_NOTIFICATION, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmartHome(), Settings.SMART_HOME, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCamelWords(), Settings.CAMEL_WORDS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowParameterNameHints(), Settings.EDITOR_INLAY_PARAMETER_HINTS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsAbove(), Settings.BREADCRUMBS_ABOVE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsShown(), Settings.ALL_BREADCRUMBS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowIntentionBulb(), Settings.INTENTION_BULB, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isDocCommentRenderingEnabled(), Settings.RENDER_DOC, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowIntentionPreview(), Settings.INTENTION_PREVIEW, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseEditorFontInInlays(), Settings.USE_EDITOR_FONT_IN_INLAYS, new EventPair[0]);
        for (String language : es.getOptions().getLanguageBreadcrumbsMap().keySet()) {
            EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsShownFor(language), Settings.BREADCRUMBS, EventFields.LanguageById.with((Object)language));
        }
        RichCopySettings rcs = RichCopySettings.getInstance();
        RichCopySettings rcsDefault = new RichCopySettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, rcs, rcsDefault, s -> s.isEnabled(), Settings.RICH_COPY, new EventPair[0]);
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        CodeInsightSettings cisDefault = new CodeInsightSettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_PARAMETER_INFO, Settings.PARAMETER_AUTO_POPUP, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_JAVADOC_INFO, Settings.JAVADOC_AUTO_POPUP, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_COMPLETION_LOOKUP, Settings.COMPLETION_AUTO_POPUP, new EventPair[0]);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.COMPLETION_CASE_SENSITIVE, Settings.COMPLETION_CASE_SENSITIVITY, INT_VALUE_FIELD);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.isSelectAutopopupSuggestionsByChars(), Settings.AUTO_POPUP_CHAR_COMPLETE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_CODE_COMPLETION, Settings.AUTO_COMPLETE_BASIC, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, Settings.AUTO_COMPLETE_SMART, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, Settings.PARAMETER_INFO_FULL_SIGNATURE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.getBackspaceMode(), Settings.SMART_BACKSPACE, BACKSPACE_MODE);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_INDENT_ON_ENTER, Settings.INDENT_ON_ENTER, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.INSERT_BRACE_ON_ENTER, Settings.BRACE_ON_ENTER, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_STUB_ON_ENTER, Settings.JAVADOC_ON_ENTER, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.INSERT_SCRIPTLET_END_ON_ENTER, Settings.SCRIPTLET_END_ON_ENTER, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_END_ACTION, Settings.SMART_END, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_GENERATE_CLOSING_TAG, Settings.AUTO_CLOSE_JAVADOC_TAGS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SURROUND_SELECTION_ON_QUOTE_TYPED, Settings.SURROUND_BY_QUOTE_OR_BRACE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_BRACKET, Settings.PAIR_BRACKET_AUTO_INSERT, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_QUOTE, Settings.PAIR_QUOTE_AUTO_INSERT, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_BLOCK_ON_RBRACE, Settings.REFORMAT_ON_R_BRACE, new EventPair[0]);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_ON_PASTE, Settings.REFORMAT_ON_PASTE, INT_VALUE_FIELD);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.ADD_IMPORTS_ON_PASTE, Settings.IMPORTS_ON_PASTE, INT_VALUE_FIELD);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_BRACES, Settings.BRACES_HIGHLIGHT, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_SCOPE, Settings.SCOPE_HIGHLIGHT, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_IDENTIFIER_UNDER_CARET, Settings.IDENTIFIER_UNDER_CARET_HIGHLIGHT, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, Settings.AUTO_ADD_IMPORTS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION, Settings.COMPLETION_HINTS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.TAB_EXITS_BRACKETS_AND_QUOTES, Settings.TAB_EXITS_BRACKETS_AND_QUOTES, new EventPair[0]);
        EditorSettingsStatisticsCollector.addTooltipActionsMetricIfDiffers(set2);
        DaemonCodeAnalyzerSettings dcas = DaemonCodeAnalyzerSettings.getInstance();
        DaemonCodeAnalyzerSettings dcasDefault = new DaemonCodeAnalyzerSettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, dcas, dcasDefault, s -> s.isNextErrorActionGoesToErrorsFirst(), Settings.NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST, new EventPair[0]);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, dcas, dcasDefault, s -> s.getAutoReparseDelay(), Settings.AUTO_REPARSE_DELAY, INT_VALUE_FIELD);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, dcas, dcasDefault, s -> s.getErrorStripeMarkMinHeight(), Settings.ERROR_STRIPE_MARK_MIN_HEIGHT, INT_VALUE_FIELD);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, dcas, dcasDefault, s -> s.isSuppressWarnings(), Settings.SUPPRESS_WARNINGS, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, dcas, dcasDefault, s -> s.isImportHintEnabled(), Settings.IMPORT_HINT_ENABLED, new EventPair[0]);
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, dcas, dcasDefault, s -> s.SHOW_METHOD_SEPARATORS, Settings.SHOW_METHOD_SEPARATORS, new EventPair[0]);
        CaretStopOptionsTransposed defaultCaretStop = CaretStopOptionsTransposed.fromCaretStopOptions((CaretStopOptions)new CaretStopOptions());
        CaretStopOptionsTransposed caretStop = CaretStopOptionsTransposed.fromCaretStopOptions((CaretStopOptions)es.getCaretStopOptions());
        EditorSettingsStatisticsCollector.addIfDiffers(set2, caretStop.getLineBoundary(), defaultCaretStop.getLineBoundary(), s -> EditorSettingsStatisticsCollector.toCaretStopValue(s), Settings.CARET_MOVEMENT_WORD, CARET_STOP_BOUNDARIES);
        EditorSettingsStatisticsCollector.addIfDiffers(set2, caretStop.getWordBoundary(), defaultCaretStop.getWordBoundary(), s -> EditorSettingsStatisticsCollector.toCaretStopValue(s), Settings.CARET_MOVEMENT_LINE, CARET_STOP_BOUNDARIES);
        if (!FileColorManagerImpl._isEnabled()) {
            set2.add(SETTING.metric(new EventPair[]{SETTING_ID.with((Object)Settings.FILE_COLORS_ENABLED), EventFields.Enabled.with((Object)false)}));
        }
        if (!FileColorManagerImpl._isEnabledForProjectView()) {
            set2.add(SETTING.metric(new EventPair[]{SETTING_ID.with((Object)Settings.FILE_COLORS_ENABLED_FOR_PROJECT_VIEW), EventFields.Enabled.with((Object)false)}));
        }
        if (!FileColorManagerImpl._isEnabledForTabs()) {
            set2.add(SETTING.metric(new EventPair[]{SETTING_ID.with((Object)Settings.FILE_COLORS_ENABLED_FOR_TABS), EventFields.Enabled.with((Object)false)}));
        }
        UISettings uiSettings = UISettings.getInstance();
        UISettings uiSettingsDefault = new UISettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, uiSettings, uiSettingsDefault, s -> s.getOpenTabsInMainWindow(), Settings.OPEN_TABS_IN_MAIN_WINDOW, new EventPair[0]);
        HashSet<MetricEvent> hashSet = set2;
        if (hashSet == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static <T> void addBoolIfDiffers(@NotNull Set<? super MetricEvent> set2, @NotNull T settingsBean, @NotNull T defaultSettingsBean, @NotNull Function<T, Boolean> valueFunction, @NotNull Settings setting, EventPair<?> ... pairs) {
        Boolean defaultValue;
        Boolean value;
        if (set2 == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(1);
        }
        if (settingsBean == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (defaultSettingsBean == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(3);
        }
        if (valueFunction == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(4);
        }
        if (setting == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(5);
        }
        if (pairs == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(6);
        }
        if (!Comparing.equal(value = valueFunction.apply(settingsBean), defaultValue = valueFunction.apply(defaultSettingsBean))) {
            ArrayList values2 = new ArrayList(Arrays.asList(pairs));
            values2.add(SETTING_ID.with((Object)setting));
            values2.add(EventFields.Enabled.with((Object)value));
            set2.add((MetricEvent)SETTING.metric(values2));
        }
    }

    private static <T, V> void addIfDiffers(@NotNull Set<? super MetricEvent> set2, @NotNull T settingsBean, @NotNull T defaultSettingsBean, @NotNull Function<? super T, ? extends V> valueFunction, @NotNull Settings setting, @NotNull EventField<V> field) {
        V defaultValue;
        V value;
        if (set2 == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(7);
        }
        if (settingsBean == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(8);
        }
        if (defaultSettingsBean == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(9);
        }
        if (valueFunction == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(10);
        }
        if (setting == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(11);
        }
        if (field == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(12);
        }
        if (!Comparing.equal(value = valueFunction.apply(settingsBean), defaultValue = valueFunction.apply(defaultSettingsBean))) {
            set2.add((MetricEvent)SETTING.metric(new EventPair[]{SETTING_ID.with((Object)setting), field.with(value)}));
        }
    }

    private static CaretStopBoundaries toCaretStopValue(@NotNull CaretStopBoundary boundary) {
        if (boundary == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(13);
        }
        if (boundary.equals((Object)CaretStopBoundary.NONE)) {
            return CaretStopBoundaries.NONE;
        }
        if (boundary.equals((Object)CaretStopBoundary.CURRENT)) {
            return CaretStopBoundaries.CURRENT;
        }
        if (boundary.equals((Object)CaretStopBoundary.NEIGHBOR)) {
            return CaretStopBoundaries.NEIGHBOR;
        }
        if (boundary.equals((Object)CaretStopBoundary.START)) {
            return CaretStopBoundaries.START;
        }
        if (boundary.equals((Object)CaretStopBoundary.END)) {
            return CaretStopBoundaries.END;
        }
        if (boundary.equals((Object)CaretStopBoundary.BOTH)) {
            return CaretStopBoundaries.BOTH;
        }
        return CaretStopBoundaries.OTHER;
    }

    private static void addTooltipActionsMetricIfDiffers(@NotNull Set<? super MetricEvent> set2) {
        boolean value;
        if (set2 == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(14);
        }
        if (!(value = TooltipActionProvider.isShowActions())) {
            set2.add((MetricEvent)SETTING.metric(new EventPair[]{SETTING_ID.with((Object)Settings.SHOW_ACTIONS_IN_TOOLTIP), EventFields.Enabled.with((Object)value)}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector";
                break;
            }
            case 1: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsBean";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSettingsBean";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFunction";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setting";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBoolIfDiffers";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addIfDiffers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toCaretStopValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTooltipActionsMetricIfDiffers";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProjectUsages
    extends ProjectUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("editor.settings.project", 3);
        private static final VarargEventId AUTO_OPTIMIZE_IMPORTS = GROUP.registerVarargEvent("autoOptimizeImports", new EventField[]{EventFields.Enabled});

        public EventLogGroup getGroup() {
            return GROUP;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project2) {
            if (project2 == null) {
                ProjectUsages.$$$reportNull$$$0(0);
            }
            HashSet<MetricEvent> set2 = new HashSet<MetricEvent>();
            CodeInsightWorkspaceSettings ciws = CodeInsightWorkspaceSettings.getInstance(project2);
            CodeInsightWorkspaceSettings ciwsDefault = new CodeInsightWorkspaceSettings();
            MetricEventUtilKt.addBoolIfDiffers(set2, (Object)ciws, (Object)ciwsDefault, s -> s.isOptimizeImportsOnTheFly(), (VarargEventId)AUTO_OPTIMIZE_IMPORTS);
            HashSet<MetricEvent> hashSet = set2;
            if (hashSet == null) {
                ProjectUsages.$$$reportNull$$$0(1);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum Settings {
        CARET_AFTER_LINE_END("caretAfterLineEnd"),
        CARET_INSIDE_TABS("caretInsideTabs"),
        VIRTUAL_SPACE_AT_FILE_BOTTOM("virtualSpaceAtFileBottom"),
        SOFT_WRAPS("softWraps"),
        SOFT_WRAPS_CONSOLE("softWraps.console"),
        SOFT_WRAPS_PREVIEW("softWraps.preview"),
        SOFT_WRAPS_RELATIVE_INDENT("softWraps.relativeIndent"),
        SOFT_WRAPS_SHOW_ALL("softWraps.showAll"),
        ENSURE_NEWLINE_AT_EOF("ensureNewlineAtEOF"),
        QUICK_DOC_ON_MOUSE_HOVER("quickDocOnMouseHover"),
        BLINKING_CARET("blinkingCaret"),
        BLOCK_CARET("blockCaret"),
        RIGHT_MARGIN("rightMargin"),
        LINE_NUMBERS("lineNumbers"),
        GUTTER_ICONS("gutterIcons"),
        FOLDING_OUTLINE("foldingOutline"),
        SHOW_LEADING_WHITESPACE("showLeadingWhitespace"),
        SHOW_INNER_WHITESPACE("showInnerWhitespace"),
        SHOW_TRAILING_WHITESPACE("showTrailingWhitespace"),
        INDENT_GUIDES("indentGuides"),
        ANIMATED_SCROLL("animatedScroll"),
        DRAG_N_DROP("dragNDrop"),
        WHEEL_ZOOM("wheelZoom"),
        WHEEL_PERSISTENT("wheelPersistent"),
        MOUSE_CAMEL("mouseCamel"),
        INPLACE_RENAME("inplaceRename"),
        PRESELECT_ON_RENAME("preselectOnRename"),
        INLINE_DIALOG("inlineDialog"),
        MINIMIZE_SCROLLING("minimizeScrolling"),
        AFTER_REFORMAT_NOTIFICATION("afterReformatNotification"),
        AFTER_OPTIMIZE_NOTIFICATION("afterOptimizeNotification"),
        SMART_HOME("smartHome"),
        CAMEL_WORDS("camelWords"),
        EDITOR_INLAY_PARAMETER_HINTS("editor.inlay.parameter.hints"),
        BREADCRUMBS_ABOVE("breadcrumbsAbove"),
        ALL_BREADCRUMBS("all.breadcrumbs"),
        INTENTION_BULB("intentionBulb"),
        RENDER_DOC("renderDoc"),
        INTENTION_PREVIEW("intentionPreview"),
        USE_EDITOR_FONT_IN_INLAYS("useEditorFontInInlays"),
        BREADCRUMBS("breadcrumbs"),
        RICH_COPY("richCopy"),
        PARAMETER_AUTO_POPUP("parameterAutoPopup"),
        JAVADOC_AUTO_POPUP("javadocAutoPopup"),
        COMPLETION_AUTO_POPUP("completionAutoPopup"),
        AUTO_POPUP_CHAR_COMPLETE("autoPopupCharComplete"),
        AUTO_COMPLETE_BASIC("autoCompleteBasic"),
        AUTO_COMPLETE_SMART("autoCompleteSmart"),
        PARAMETER_INFO_FULL_SIGNATURE("parameterInfoFullSignature"),
        INDENT_ON_ENTER("indentOnEnter"),
        BRACE_ON_ENTER("braceOnEnter"),
        JAVADOC_ON_ENTER("javadocOnEnter"),
        SCRIPTLET_END_ON_ENTER("scriptletEndOnEnter"),
        SMART_END("smartEnd"),
        AUTO_CLOSE_JAVADOC_TAGS("autoCloseJavadocTags"),
        SURROUND_BY_QUOTE_OR_BRACE("surroundByQuoteOrBrace"),
        PAIR_BRACKET_AUTO_INSERT("pairBracketAutoInsert"),
        PAIR_QUOTE_AUTO_INSERT("pairQuoteAutoInsert"),
        REFORMAT_ON_R_BRACE("reformatOnRBrace"),
        BRACES_HIGHLIGHT("bracesHighlight"),
        SCOPE_HIGHLIGHT("scopeHighlight"),
        IDENTIFIER_UNDER_CARET_HIGHLIGHT("identifierUnderCaretHighlight"),
        AUTO_ADD_IMPORTS("autoAddImports"),
        COMPLETION_HINTS("completionHints"),
        TAB_EXITS_BRACKETS_AND_QUOTES("tabExitsBracketsAndQuotes"),
        NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST("nextErrorActionGoesToErrorsFirst"),
        SUPPRESS_WARNINGS("suppressWarnings"),
        IMPORT_HINT_ENABLED("importHintEnabled"),
        SHOW_METHOD_SEPARATORS("showMethodSeparators"),
        OPEN_TABS_IN_MAIN_WINDOW("openTabsInMainWindow"),
        STRIP_TRAILING_SPACES("stripTrailingSpaces"),
        BLINK_PERIOD("blinkPeriod"),
        COMPLETION_CASE_SENSITIVITY("completionCaseSensitivity"),
        SMART_BACKSPACE("smartBackspace"),
        REFORMAT_ON_PASTE("reformatOnPaste"),
        IMPORTS_ON_PASTE("importsOnPaste"),
        AUTO_REPARSE_DELAY("autoReparseDelay"),
        ERROR_STRIPE_MARK_MIN_HEIGHT("errorStripeMarkMinHeight"),
        CARET_MOVEMENT_WORD("caret.movement.word"),
        CARET_MOVEMENT_LINE("caret.movement.line"),
        FILE_COLORS_ENABLED("fileColorsEnabled"),
        FILE_COLORS_ENABLED_FOR_PROJECT_VIEW("fileColorsEnabledForProjectView"),
        FILE_COLORS_ENABLED_FOR_TABS("fileColorsEnabledForTabs"),
        SHOW_ACTIONS_IN_TOOLTIP("show.actions.in.tooltip");

        public final String internalName;

        private Settings(String internalName) {
            this.internalName = internalName;
        }
    }

    private static enum CaretStopBoundaries {
        NONE,
        CURRENT,
        NEIGHBOR,
        START,
        END,
        BOTH,
        OTHER;

    }
}

