/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.internal.retype.RetypeQueue;
import com.intellij.internal.retype.RetypeSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/retype/RetypeQueue;", "", "project", "Lcom/intellij/openapi/project/Project;", "retypeDelay", "", "threadDumpDelay", "scriptBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "largeIndexFileCount", "restoreText", "", "(Lcom/intellij/openapi/project/Project;IILjava/lang/StringBuilder;IZ)V", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFiles", "()Ljava/util/List;", "threadDumps", "", "findRangeOfSuitableElement", "Lcom/intellij/openapi/util/TextRange;", "treeElement", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "processNext", "", "selectFragmentToRetype", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
final class RetypeQueue {
    @NotNull
    private final List<VirtualFile> files;
    private final List<String> threadDumps;
    private final Project project;
    private final int retypeDelay;
    private final int threadDumpDelay;
    private final StringBuilder scriptBuilder;
    private final int largeIndexFileCount;
    private final boolean restoreText;

    @NotNull
    public final List<VirtualFile> getFiles() {
        return this.files;
    }

    public final void processNext() {
        if (this.files.isEmpty()) {
            return;
        }
        VirtualFile file2 = this.files.get(0);
        this.files.remove(0);
        Editor editor2 = FileEditorManager.getInstance(this.project).openTextEditor(new OpenFileDescriptor(this.project, file2, 0), true);
        if (editor2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        }
        EditorImpl editor3 = (EditorImpl)editor2;
        this.selectFragmentToRetype((Editor)editor3);
        int n = this.largeIndexFileCount;
        boolean bl = this.restoreText;
        RetypeSession retypeSession = new RetypeSession(this.project, editor3, this.retypeDelay, this.scriptBuilder, this.threadDumpDelay, this.threadDumps, n, bl);
        Collection collection = this.files;
        if (!collection.isEmpty()) {
            retypeSession.setStartNextCallback((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ RetypeQueue this$0;

                public final void invoke() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ processNext.1 this$0;

                        public final void run() {
                            this.this$0.this$0.processNext();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = retypeQueue;
                    super(0);
                }
            }));
        }
        retypeSession.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void selectFragmentToRetype(Editor editor2) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        if (document.getTextLength() < 2000) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        FileEditor fileEditor = fileEditorManager.getSelectedEditor();
        if (fileEditor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"FileEditorManager.getIns\u2026.selectedEditor ?: return");
        FileEditor fileEditor2 = fileEditor;
        StructureViewBuilder structureViewBuilder = fileEditor2.getStructureViewBuilder();
        if (structureViewBuilder != null && (structureViewBuilder = structureViewBuilder.createStructureView(fileEditor2, this.project)) != null) {
            Disposable $this$use$iv = (Disposable)structureViewBuilder;
            boolean $i$f$use = false;
            try {
                TextRange textRange;
                PsiTreeElementBase psiTreeElementBase;
                StructureView it = (StructureView)$this$use$iv;
                boolean bl = false;
                StructureView structureView = it;
                Intrinsics.checkNotNullExpressionValue((Object)structureView, (String)"it");
                StructureViewModel structureViewModel = structureView.getTreeModel();
                Intrinsics.checkNotNullExpressionValue((Object)structureViewModel, (String)"it.treeModel");
                StructureViewTreeElement structureViewTreeElement = structureViewModel.getRoot();
                if (!(structureViewTreeElement instanceof PsiTreeElementBase)) {
                    structureViewTreeElement = null;
                }
                if ((PsiTreeElementBase)structureViewTreeElement == null) {
                    return;
                }
                PsiTreeElementBase root = psiTreeElementBase;
                if (this.findRangeOfSuitableElement((TreeElement)root) == null) {
                    return;
                }
                TextRange range = textRange;
                editor2.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                editor2.getCaretModel().moveToOffset(range.getStartOffset());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose($this$use$iv);
                }
            }
        }
    }

    private final TextRange findRangeOfSuitableElement(TreeElement treeElement) {
        for (TreeElement child : treeElement.getChildren()) {
            TextRange grandchildRange;
            TextRange childRange;
            TreeElement treeElement2 = child;
            if (!(treeElement2 instanceof StructureViewTreeElement)) {
                treeElement2 = null;
            }
            StructureViewTreeElement structureViewTreeElement = (StructureViewTreeElement)treeElement2;
            Object object = structureViewTreeElement != null ? structureViewTreeElement.getValue() : null;
            if (!(object instanceof PsiElement)) {
                object = null;
            }
            PsiElement psiElement = (PsiElement)object;
            TextRange textRange = childRange = psiElement != null ? psiElement.getTextRange() : null;
            if (childRange == null) continue;
            int n = childRange.getLength();
            if (1000 <= n && 2000 >= n) {
                return childRange;
            }
            if (childRange.getLength() <= 2000 || (grandchildRange = this.findRangeOfSuitableElement(child)) == null) continue;
            return grandchildRange;
        }
        return null;
    }

    public RetypeQueue(@NotNull Project project2, int retypeDelay, int threadDumpDelay, @Nullable StringBuilder scriptBuilder, int largeIndexFileCount, boolean restoreText) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.retypeDelay = retypeDelay;
        this.threadDumpDelay = threadDumpDelay;
        this.scriptBuilder = scriptBuilder;
        this.largeIndexFileCount = largeIndexFileCount;
        this.restoreText = restoreText;
        this.files = new ArrayList();
        this.threadDumps = new ArrayList();
    }
}

