/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

final class LoadAllContentsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(LoadAllContentsAction.class);
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong totalSize = new AtomicLong();

    LoadAllContentsAction() {
        super(InternalActionsBundle.messagePointer((String)"action.AnAction.text.load.all.files.content", (Object[])new Object[0]), InternalActionsBundle.messagePointer((String)"action.AnAction.description.load.all.files.content", (Object[])new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            LoadAllContentsAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        String m = "Started loading content";
        LOG.info(m);
        System.out.println(m);
        long start2 = System.currentTimeMillis();
        this.count.set(0);
        this.totalSize.set(0L);
        ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(() -> ProjectRootManager.getInstance(project2).getFileIndex().iterateContent(fileOrDir -> {
            if (fileOrDir.isDirectory() || fileOrDir.is(VFileProperty.SPECIAL)) {
                return true;
            }
            try {
                this.count.incrementAndGet();
                byte[] bytes = FileUtil.loadFileBytes(new File(fileOrDir.getPath()));
                this.totalSize.addAndGet(bytes.length);
                ProgressManager.getInstance().getProgressIndicator().setText(fileOrDir.getPresentableUrl());
            }
            catch (IOException e1) {
                LOG.error(e1);
            }
            return true;
        }), "Loading", false, project2);
        long end = System.currentTimeMillis();
        String message2 = "Finished loading content of " + this.count + " files. Total size=" + StringUtil.formatFileSize(this.totalSize.get()) + ". Elapsed=" + (end - start2) / 1000L + "sec.";
        LOG.info(message2);
        System.out.println(message2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            LoadAllContentsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadAllContentsAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/LoadAllContentsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/LoadAllContentsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

