/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class DumpIntentionsAction
extends AnAction
implements DumbAware {
    DumpIntentionsAction() {
        super(ActionsBundle.messagePointer((String)"action.DumpIntentionsAction.text", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpIntentionsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        VirtualFile file2;
        if (event == null) {
            DumpIntentionsAction.$$$reportNull$$$0(1);
        }
        if ((file2 = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)event.getProject(), null)) == null) {
            return;
        }
        List<IntentionActionMetaData> list2 = IntentionManagerSettings.getInstance().getMetaData();
        File root = VfsUtilCore.virtualToIoFile(file2);
        Element el = new Element("root");
        HashMap<String, Element> categoryMap = new HashMap<String, Element>();
        for (IntentionActionMetaData metaData : list2) {
            try {
                Element metadataElement = new Element("intention");
                metadataElement.setAttribute("family", metaData.getFamily());
                metadataElement.setAttribute("description", metaData.getDescription().getText());
                String key = StringUtil.join(metaData.myCategory, ".");
                Element element2 = DumpIntentionsAction.getCategoryElement(categoryMap, el, metaData, key, metaData.myCategory.length - 1);
                element2.addContent(metadataElement);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            JDOMUtil.write(el, root.toPath().resolve("intentions.xml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Element getCategoryElement(Map<String, Element> categoryMap, Element rootElement, IntentionActionMetaData metaData, String key, int idx) {
        Element element2 = categoryMap.get(key);
        if (element2 == null) {
            element2 = new Element("category");
            element2.setAttribute("name", metaData.myCategory[idx]);
            categoryMap.put(key, element2);
            if (idx == 0) {
                rootElement.addContent(element2);
            } else {
                DumpIntentionsAction.getCategoryElement(categoryMap, rootElement, metaData, StringUtil.join(metaData.myCategory, 0, metaData.myCategory.length - 1, "."), idx - 1).addContent(element2);
            }
        }
        return element2;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpIntentionsAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/DumpIntentionsAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/DumpIntentionsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

