/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.ide.util.scopeChooser.ScopeIdMapper;
import com.intellij.openapi.fileEditor.impl.OpenFilesScope;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\u0006\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u0004H\u0017\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/util/scopeChooser/ScopeIdMapperImpl;", "Lcom/intellij/ide/util/scopeChooser/ScopeIdMapper;", "()V", "getPresentableScopeName", "", "scopeId", "getScopeSerializationId", "presentableScopeName", "intellij.platform.lang.impl"})
public final class ScopeIdMapperImpl
extends ScopeIdMapper {
    @NotNull
    public String getPresentableScopeName(@NotNull String scopeId) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        switch (scopeId) {
            case "All Places": {
                String string3 = EverythingGlobalScope.getNameText();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"EverythingGlobalScope.getNameText()");
                break;
            }
            case "Project and Libraries": {
                String string4 = ProjectAndLibrariesScope.getNameText();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ProjectAndLibrariesScope.getNameText()");
                break;
            }
            case "Project Files": {
                String string5 = ProjectScope.getProjectFilesScopeName();
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"ProjectScope.getProjectFilesScopeName()");
                break;
            }
            case "Project Production Files": {
                String string6 = GlobalSearchScopesCore.getProjectProductionFilesScopeName();
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"GlobalSearchScopesCore.g\u2026roductionFilesScopeName()");
                break;
            }
            case "Project Test Files": {
                String string7 = GlobalSearchScopesCore.getProjectTestFilesScopeName();
                string2 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"GlobalSearchScopesCore.g\u2026ojectTestFilesScopeName()");
                break;
            }
            case "Scratches and Consoles": {
                String string8 = ScratchesNamedScope.scratchesAndConsoles();
                string2 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"ScratchesNamedScope.scratchesAndConsoles()");
                break;
            }
            case "Recently Viewed Files": {
                String string9 = PredefinedSearchScopeProviderImpl.getRecentlyViewedFilesScopeName();
                string2 = string9;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"PredefinedSearchScopePro\u2026tlyViewedFilesScopeName()");
                break;
            }
            case "Recently Changed Files": {
                String string10 = PredefinedSearchScopeProviderImpl.getRecentlyChangedFilesScopeName();
                string2 = string10;
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"PredefinedSearchScopePro\u2026lyChangedFilesScopeName()");
                break;
            }
            case "Open Files": {
                String string11 = OpenFilesScope.getNameText();
                string2 = string11;
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"OpenFilesScope.getNameText()");
                break;
            }
            case "Current File": {
                String string12 = PredefinedSearchScopeProviderImpl.getCurrentFileScopeName();
                string2 = string12;
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"PredefinedSearchScopePro\u2026getCurrentFileScopeName()");
                break;
            }
            default: {
                string2 = scopeId;
            }
        }
        return string2;
    }

    @NonNls
    @NotNull
    public String getScopeSerializationId(@Nls @NotNull String presentableScopeName) {
        Intrinsics.checkNotNullParameter((Object)presentableScopeName, (String)"presentableScopeName");
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)EverythingGlobalScope.getNameText())) {
            return "All Places";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)ProjectAndLibrariesScope.getNameText())) {
            return "Project and Libraries";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)ProjectScope.getProjectFilesScopeName())) {
            return "Project Files";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)GlobalSearchScopesCore.getProjectProductionFilesScopeName())) {
            return "Project Production Files";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)GlobalSearchScopesCore.getProjectTestFilesScopeName())) {
            return "Project Test Files";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)ScratchesNamedScope.scratchesAndConsoles())) {
            return "Scratches and Consoles";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)PredefinedSearchScopeProviderImpl.getRecentlyViewedFilesScopeName())) {
            return "Recently Viewed Files";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)PredefinedSearchScopeProviderImpl.getRecentlyChangedFilesScopeName())) {
            return "Recently Changed Files";
        }
        if (Intrinsics.areEqual((Object)presentableScopeName, (Object)OpenFilesScope.getNameText())) {
            return "Open Files";
        }
        return Intrinsics.areEqual((Object)presentableScopeName, (Object)PredefinedSearchScopeProviderImpl.getCurrentFileScopeName()) ? "Current File" : presentableScopeName;
    }
}

