/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.ide.util.scopeChooser.ScopeIdMapper;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    public static final int OPT_LIBRARIES = 1;
    public static final int OPT_SEARCH_RESULTS = 2;
    public static final int OPT_FROM_SELECTION = 4;
    public static final int OPT_USAGE_VIEW = 8;
    public static final int OPT_EMPTY_SCOPES = 16;
    private Project myProject;
    private int myOptions = 12;
    private Condition<? super ScopeDescriptor> myScopeFilter;
    private BrowseListener myBrowseListener;
    private SearchScope preselectedScope;

    public ScopeChooserCombo() {
        super((JComboBox)((Object)new MyComboBox()));
    }

    public ScopeChooserCombo(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this();
        this.init(project2, suggestSearchInLibs, prevSearchWholeFiles, preselect, null);
    }

    public void init(Project project2, String preselect) {
        this.init(project2, false, true, preselect, null);
    }

    public void init(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, Object selection, @Nullable Condition<? super ScopeDescriptor> scopeFilter) {
        this.initialize(project2, suggestSearchInLibs, prevSearchWholeFiles, selection, scopeFilter);
    }

    public Promise<?> initialize(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, Object selection, @Nullable Condition<? super ScopeDescriptor> scopeFilter) {
        if (this.myProject != null) {
            throw new IllegalStateException("scope chooser combo already initialized");
        }
        this.myOptions = BitUtil.set(this.myOptions, 1, suggestSearchInLibs);
        this.myOptions = BitUtil.set(this.myOptions, 2, prevSearchWholeFiles);
        this.myProject = project2;
        NamedScopesHolder.ScopeListener scopeListener = () -> {
            SearchScope selectedScope = this.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(selectedScope);
        };
        this.myScopeFilter = scopeFilter;
        NamedScopeManager.getInstance(project2).addScopeListener(scopeListener, this);
        DependencyValidationManager.getInstance(project2).addScopeListener(scopeListener, this);
        this.addActionListener(this::handleScopeChooserAction);
        ComboBox<ScopeDescriptor> combo = this.getComboBox();
        combo.setMinimumAndPreferredWidth(JBUIScale.scale(300));
        combo.setRenderer(ScopeChooserCombo.createDefaultRenderer());
        combo.setSwingPopup(false);
        if (selection != null) {
            PredefinedSearchScopeProvider provider2 = PredefinedSearchScopeProvider.getInstance();
            List<SearchScope> scopes = provider2.getPredefinedScopes(project2, null, suggestSearchInLibs, prevSearchWholeFiles, false, false, false);
            for (SearchScope s : scopes) {
                if (!selection.equals(s.getDisplayName())) continue;
                this.preselectedScope = s;
                break;
            }
        }
        return this.rebuildModelAndSelectScopeOnSuccess(selection);
    }

    @NotNull
    public static ListCellRenderer<ScopeDescriptor> createDefaultRenderer() {
        return new MyRenderer();
    }

    public ComboBox<ScopeDescriptor> getComboBox() {
        return (ComboBox)super.getComboBox();
    }

    public void setBrowseListener(BrowseListener browseListener) {
        this.myBrowseListener = browseListener;
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.myOptions = BitUtil.set(this.myOptions, 4, currentSelection);
    }

    public void setUsageView(boolean usageView) {
        this.myOptions = BitUtil.set(this.myOptions, 8, usageView);
    }

    public void selectItem(@Nullable Object selection) {
        if (selection == null) {
            return;
        }
        ComboBox<ScopeDescriptor> combo = this.getComboBox();
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)combo.getModel();
        for (int i = 0; i < model2.getSize(); ++i) {
            ScopeDescriptor descriptor = (ScopeDescriptor)model2.getElementAt(i);
            if ((!(selection instanceof String) || !selection.equals(descriptor.getDisplayName())) && (!(selection instanceof SearchScope) || !descriptor.scopeEquals((SearchScope)selection))) continue;
            combo.setSelectedIndex(i);
            break;
        }
    }

    private void handleScopeChooserAction(ActionEvent ignore) {
        EditScopesDialog dlg;
        String selection = this.getSelectedScopeName();
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onBeforeBrowseStarted();
        }
        if ((dlg = EditScopesDialog.showDialog(this.myProject, selection)).isOK()) {
            NamedScope namedScope = dlg.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(namedScope == null ? null : namedScope.getScopeId());
        }
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onAfterBrowseFinished();
        }
    }

    @Deprecated
    public static boolean processScopes(@NotNull Project project2, @NotNull DataContext dataContext, int options, @NotNull Processor<? super ScopeDescriptor> processor) {
        if (project2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            ScopeChooserCombo.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ScopeChooserCombo.$$$reportNull$$$0(2);
        }
        List<SearchScope> scopes = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project2, dataContext, BitUtil.isSet(options, 1), BitUtil.isSet(options, 2), BitUtil.isSet(options, 4), BitUtil.isSet(options, 8), BitUtil.isSet(options, 16));
        return ScopeChooserCombo.doProcessScopes(project2, dataContext, scopes, processor);
    }

    public static Promise<Boolean> processScopesAsync(@NotNull Project project2, @NotNull DataContext dataContext, int options, @NotNull Processor<? super ScopeDescriptor> processor) {
        if (project2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ScopeChooserCombo.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            ScopeChooserCombo.$$$reportNull$$$0(5);
        }
        return PredefinedSearchScopeProvider.getInstance().getPredefinedScopesAsync(project2, dataContext, BitUtil.isSet(options, 1), BitUtil.isSet(options, 2), BitUtil.isSet(options, 4), BitUtil.isSet(options, 8), BitUtil.isSet(options, 16)).then(predefinedScopes -> ScopeChooserCombo.doProcessScopes(project2, dataContext, predefinedScopes, processor));
    }

    @NotNull
    private static Boolean doProcessScopes(@NotNull Project project2, @NotNull DataContext dataContext, List<? extends SearchScope> predefinedScopes, @NotNull Processor<? super ScopeDescriptor> processor) {
        if (project2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            ScopeChooserCombo.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            ScopeChooserCombo.$$$reportNull$$$0(8);
        }
        for (SearchScope searchScope2 : predefinedScopes) {
            if (processor.process(new ScopeDescriptor(searchScope2))) continue;
            Boolean bl = false;
            if (bl == null) {
                ScopeChooserCombo.$$$reportNull$$$0(9);
            }
            return bl;
        }
        for (ScopeDescriptorProvider scopeDescriptorProvider : ScopeDescriptorProvider.EP_NAME.getExtensionList()) {
            ScopeDescriptor[] scopeDescriptorArray = scopeDescriptorProvider.getScopeDescriptors(project2);
            int n = scopeDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                ScopeDescriptor descriptor = scopeDescriptorArray[i];
                if (processor.process(descriptor)) continue;
                Boolean bl = false;
                if (bl == null) {
                    ScopeChooserCombo.$$$reportNull$$$0(10);
                }
                return bl;
            }
        }
        Comparator comparator2 = (o1, o2) -> {
            int w2;
            int w1 = o1 instanceof WeighedItem ? ((WeighedItem)o1).getWeight() : Integer.MAX_VALUE;
            int n = w2 = o2 instanceof WeighedItem ? ((WeighedItem)o2).getWeight() : Integer.MAX_VALUE;
            if (w1 == w2) {
                return StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
            }
            return w1 - w2;
        };
        for (SearchScopeProvider each : SearchScopeProvider.EP_NAME.getExtensions()) {
            List scopes;
            if (StringUtil.isEmpty(each.getDisplayName()) || (scopes = SlowOperations.allowSlowOperations(() -> each.getSearchScopes(project2, dataContext))).isEmpty()) continue;
            if (!processor.process(new ScopeSeparator(each.getDisplayName()))) {
                Boolean bl = false;
                if (bl == null) {
                    ScopeChooserCombo.$$$reportNull$$$0(11);
                }
                return bl;
            }
            for (SearchScope scope : ContainerUtil.sorted(scopes, comparator2)) {
                if (processor.process(new ScopeDescriptor(scope))) continue;
                Boolean bl = false;
                if (bl == null) {
                    ScopeChooserCombo.$$$reportNull$$$0(12);
                }
                return bl;
            }
        }
        Boolean bl = true;
        if (bl == null) {
            ScopeChooserCombo.$$$reportNull$$$0(13);
        }
        return bl;
    }

    @NotNull
    private Promise<?> rebuildModelAndSelectScopeOnSuccess(@Nullable Object selection) {
        DefaultComboBoxModel model2 = new DefaultComboBoxModel();
        Promise promise = DataManager.getInstance().getDataContextFromFocusAsync().thenAsync(c -> this.processScopes(model2, (DataContext)c).onSuccess(__ -> {
            this.getComboBox().setModel((ComboBoxModel)model2);
            this.selectItem(selection);
            this.preselectedScope = null;
        }));
        if (promise == null) {
            ScopeChooserCombo.$$$reportNull$$$0(14);
        }
        return promise;
    }

    @NotNull
    private Promise<?> processScopes(DefaultComboBoxModel<ScopeDescriptor> model2, DataContext c) {
        ArrayList descriptors = new ArrayList();
        Promise<Boolean> promise = ScopeChooserCombo.processScopesAsync(this.myProject, c, this.myOptions, descriptor -> {
            if (this.myScopeFilter == null || this.myScopeFilter.value((ScopeDescriptor)descriptor)) {
                descriptors.add(descriptor);
            }
            return true;
        }).onSuccess(__ -> this.updateModel(model2, descriptors));
        if (promise == null) {
            ScopeChooserCombo.$$$reportNull$$$0(15);
        }
        return promise;
    }

    protected void updateModel(DefaultComboBoxModel<ScopeDescriptor> model2, List<? extends ScopeDescriptor> descriptors) {
        for (ScopeDescriptor scopeDescriptor : descriptors) {
            model2.addElement(scopeDescriptor);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    public void setShowEmptyScopes(boolean showEmptyScopes) {
        this.myOptions = BitUtil.set(this.myOptions, 16, showEmptyScopes);
    }

    @Nullable
    public SearchScope getSelectedScope() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        return item == null ? this.preselectedScope : item.getScope();
    }

    @Nullable
    @Nls
    public String getSelectedScopeName() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        if (item == null) {
            return this.preselectedScope == null ? null : this.preselectedScope.getDisplayName();
        }
        return item.getDisplayName();
    }

    @Nullable
    @NonNls
    public String getSelectedScopeId() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        String scopeName = item != null ? item.getDisplayName() : (this.preselectedScope != null ? this.preselectedScope.getDisplayName() : null);
        return scopeName != null ? ScopeIdMapper.getInstance().getScopeSerializationId(scopeName) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doProcessScopes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildModelAndSelectScopeOnSuccess";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processScopes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processScopesAsync";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doProcessScopes";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyComboBox
    extends ComboBox {
        private MyComboBox() {
        }

        public void setSelectedItem(Object item) {
            if (!(item instanceof ScopeSeparator)) {
                super.setSelectedItem(item);
            }
        }

        public void setSelectedIndex(int anIndex) {
            Object item = this.getItemAt(anIndex);
            if (!(item instanceof ScopeSeparator)) {
                super.setSelectedIndex(anIndex);
            }
        }
    }

    public static interface BrowseListener {
        public void onBeforeBrowseStarted();

        public void onAfterBrowseFinished();
    }

    private static class MyRenderer
    extends SimpleListCellRenderer<ScopeDescriptor> {
        final TitledSeparator separator = new TitledSeparator();

        private MyRenderer() {
        }

        public void customize(@NotNull JList<? extends ScopeDescriptor> list2, ScopeDescriptor value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return;
            }
            this.setIcon(value.getIcon());
            this.setText(value.getDisplayName());
        }

        public Component getListCellRendererComponent(JList<? extends ScopeDescriptor> list2, ScopeDescriptor value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof ScopeSeparator) {
                this.separator.setText(value.getDisplayName());
                this.separator.setBorder((Border)(index == -1 ? null : new JBEmptyBorder(4, 2, 4, 0)));
                return this.separator;
            }
            return super.getListCellRendererComponent(list2, (Object)value, index, selected, hasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$MyRenderer", "customize"));
        }
    }

    private static class ScopeSeparator
    extends ScopeDescriptor {
        @Nls
        final String text;

        ScopeSeparator(@NotNull @Nls String text2) {
            if (text2 == null) {
                ScopeSeparator.$$$reportNull$$$0(0);
            }
            super(null);
            this.text = text2;
        }

        @Override
        public String getDisplayName() {
            return this.text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$ScopeSeparator", "<init>"));
        }
    }
}

