/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.ui.IdeUICustomization;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoSymbolModel2
extends FilteringGotoByModel<LanguageRef> {
    private String[] mySeparators;
    private final boolean myAllContributors;

    public GotoSymbolModel2(@NotNull Project project2, ChooseByNameContributor @NotNull [] contributors) {
        if (project2 == null) {
            GotoSymbolModel2.$$$reportNull$$$0(0);
        }
        if (contributors == null) {
            GotoSymbolModel2.$$$reportNull$$$0(1);
        }
        super(project2, contributors);
        this.myAllContributors = false;
        this.addEpListener(project2);
    }

    public GotoSymbolModel2(@NotNull Project project2) {
        if (project2 == null) {
            GotoSymbolModel2.$$$reportNull$$$0(2);
        }
        super(project2, new ChooseByNameContributor[0]);
        this.myAllContributors = true;
        this.addEpListener(project2);
    }

    private void addEpListener(@NotNull Project project2) {
        if (project2 == null) {
            GotoSymbolModel2.$$$reportNull$$$0(3);
        }
        ChooseByNameContributor.CLASS_EP_NAME.addChangeListener(() -> {
            this.mySeparators = null;
        }, project2);
    }

    @Override
    protected List<ChooseByNameContributor> getContributorList() {
        if (this.myAllContributors) {
            return ChooseByNameRegistry.getInstance().getSymbolModelContributors();
        }
        return super.getContributorList();
    }

    @Override
    protected LanguageRef filterValueFor(NavigationItem item) {
        return LanguageRef.forNavigationitem(item);
    }

    @Override
    @Nullable
    protected synchronized Collection<LanguageRef> getFilterItems() {
        Collection result2 = super.getFilterItems();
        if (result2 == null) {
            return null;
        }
        HashSet<LanguageRef> items = new HashSet<LanguageRef>(result2);
        items.add(LanguageRef.forLanguage(Language.ANY));
        return items;
    }

    @Override
    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotosymbol.enter.symbol.name", (Object[])new Object[0]);
    }

    @Override
    public String getCheckBoxName() {
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.symbols", new Object[0]);
    }

    @Override
    @NotNull
    public String getNotInMessage() {
        String string2 = IdeUICustomization.getInstance().projectMessage("label.no.matches.found.in.project", new Object[0]);
        if (string2 == null) {
            GotoSymbolModel2.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getNotFoundMessage() {
        String string2 = IdeBundle.message((String)"label.no.matches.found", (Object[])new Object[0]);
        if (string2 == null) {
            GotoSymbolModel2.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.myProject);
        return Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries")) && Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToSymbol.includeLibraries"));
    }

    @Override
    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.myProject);
        if (Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries"))) {
            propertiesComponent.setValue("GoToSymbol.includeLibraries", Boolean.toString(state));
        }
    }

    @Override
    public String getFullName(@NotNull Object element2) {
        if (element2 == null) {
            GotoSymbolModel2.$$$reportNull$$$0(6);
        }
        for (ChooseByNameContributor c : this.getContributorList()) {
            String result2;
            if (!(c instanceof GotoClassContributor) || (result2 = ((GotoClassContributor)c).getQualifiedName((NavigationItem)element2)) == null) continue;
            return result2;
        }
        String elementName = this.getElementName(element2);
        if (elementName == null) {
            return null;
        }
        if (element2 instanceof PsiElement) {
            return SymbolPresentationUtil.getSymbolContainerText((PsiElement)element2) + "." + elementName;
        }
        return elementName;
    }

    @Override
    public String @NotNull [] getSeparators() {
        if (this.mySeparators == null) {
            this.mySeparators = GotoClassModel2.getSeparatorsFromContributors(this.getContributors());
        }
        if (this.mySeparators == null) {
            GotoSymbolModel2.$$$reportNull$$$0(7);
        }
        return this.mySeparators;
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    @Override
    public boolean willOpenEditor() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoSymbolModel2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoSymbolModel2";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEpListener";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

