/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Color;
import java.io.File;
import java.util.Objects;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileCellRenderer
extends PsiElementListCellRenderer<PsiFileSystemItem> {
    private final int myMaxWidth;

    public GotoFileCellRenderer(int maxSize) {
        this.myMaxWidth = maxSize;
    }

    @Override
    public String getElementText(PsiFileSystemItem element2) {
        return element2.getName();
    }

    @Override
    protected String getContainerText(PsiFileSystemItem element2, String name2) {
        PsiDirectory psiDirectory;
        PsiFileSystemItem parent = element2.getParent();
        PsiDirectory psiDirectory2 = psiDirectory = parent instanceof PsiDirectory ? (PsiDirectory)parent : null;
        if (psiDirectory == null) {
            return null;
        }
        VirtualFile virtualFile2 = psiDirectory.getVirtualFile();
        String relativePath = GotoFileCellRenderer.getRelativePath(virtualFile2, element2.getProject());
        if (relativePath == null) {
            return "( " + File.separator + " )";
        }
        String path2 = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getOptimalTextForComponent(name2 + "          ", new File(relativePath), this, this.myMaxWidth);
        return "(" + path2 + ")";
    }

    @Nullable
    public static String getRelativePath(VirtualFile virtualFile2, Project project2) {
        String projectHomeUrl;
        if (project2 == null) {
            return virtualFile2.getPresentableUrl();
        }
        VirtualFile root = GotoFileCellRenderer.getAnyRoot(virtualFile2, project2);
        if (root != null) {
            return GotoFileCellRenderer.getRelativePathFromRoot(virtualFile2, root);
        }
        Object url = virtualFile2.getPresentableUrl();
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir != null && ((String)url).startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            String cont = ((String)url).substring(projectHomeUrl.length());
            if (cont.isEmpty()) {
                return null;
            }
            url = "..." + cont;
        }
        return url;
    }

    @Nullable
    public static VirtualFile getAnyRoot(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        ProjectFileIndex index;
        VirtualFile root;
        if (virtualFile2 == null) {
            GotoFileCellRenderer.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            GotoFileCellRenderer.$$$reportNull$$$0(1);
        }
        if ((root = (index = ProjectFileIndex.getInstance(project2)).getContentRootForFile(virtualFile2)) == null) {
            root = index.getClassRootForFile(virtualFile2);
        }
        if (root == null) {
            root = index.getSourceRootForFile(virtualFile2);
        }
        return root;
    }

    @NotNull
    static String getRelativePathFromRoot(@NotNull VirtualFile file2, @NotNull VirtualFile root) {
        if (file2 == null) {
            GotoFileCellRenderer.$$$reportNull$$$0(2);
        }
        if (root == null) {
            GotoFileCellRenderer.$$$reportNull$$$0(3);
        }
        String string2 = root.getName() + File.separatorChar + VfsUtilCore.getRelativePath(file2, root, File.separatorChar);
        if (string2 == null) {
            GotoFileCellRenderer.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, int index, boolean selected, boolean hasFocus) {
        return GotoFileCellRenderer.doCustomizeNonPsiElementLeftRenderer(renderer, list2, value, this.getNavigationItemAttributes(value));
    }

    public static boolean doCustomizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, TextAttributes attributes) {
        if (!(value instanceof NavigationItem)) {
            return false;
        }
        NavigationItem item = (NavigationItem)value;
        SimpleTextAttributes nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
        Color color = list2.getForeground();
        if (nameAttributes == null) {
            nameAttributes = new SimpleTextAttributes(0, color);
        }
        ItemPresentation presentation2 = Objects.requireNonNull(item.getPresentation());
        renderer.append(presentation2.getPresentableText() + " ", nameAttributes);
        renderer.setIcon(presentation2.getIcon(true));
        String locationString = presentation2.getLocationString();
        if (!StringUtil.isEmpty(locationString)) {
            renderer.append(locationString, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
        }
        return true;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoFileCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoFileCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePathFromRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnyRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathFromRoot";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

