/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.BundleBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.RegistryTextOptionDescriptor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.GotoActionAliasMatcher;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.MatchMode;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.HtmlToSimpleColoredComponentConverter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.render.IconCompOptionalCompPanel;
import com.intellij.ui.render.RendererPanelsUtils;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GotoActionModel
implements ChooseByNameModel,
Comparator<Object>,
DumbAware {
    private static final Logger LOG = Logger.getInstance(GotoActionModel.class);
    private static final Pattern INNER_GROUP_WITH_IDS = Pattern.compile("(.*) \\(\\d+\\)");
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_16;
    @Nullable
    private final Project myProject;
    @Nullable
    private final WeakReference<Editor> myEditor;
    private final DataContext myDataContext;
    private volatile UpdateSession myUpdateSession;
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final Map<AnAction, GroupMapping> myActionGroups = new ConcurrentHashMap<AnAction, GroupMapping>();
    private final NotNullLazyValue<Map<@NonNls String, @NlsContexts.ConfigurableName String>> myConfigurablesNames = NotNullLazyValue.volatileLazy(() -> {
        if (SwingUtilities.isEventDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Configurable names must not be loaded on EDT");
        }
        HashMap<@NonNls String, @NlsContexts.ConfigurableName String> map2 = new HashMap<String, String>();
        for (Configurable configurable2 : ShowSettingsUtilImpl.getConfigurables((Project)this.getProject(), (boolean)true)) {
            if (!(configurable2 instanceof SearchableConfigurable)) continue;
            map2.put(((SearchableConfigurable)configurable2).getId(), configurable2.getDisplayName());
        }
        return map2;
    });

    public GotoActionModel(@Nullable Project project2, @Nullable Component component2, @Nullable Editor editor2) {
        this.myProject = project2;
        this.myEditor = new WeakReference<Editor>(editor2);
        this.myDataContext = Utils.wrapDataContext((DataContext)DataManager.getInstance().getDataContext(component2));
        this.myUpdateSession = this.newUpdateSession();
    }

    @NotNull
    private UpdateSession newUpdateSession() {
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"GoToAction", null, (DataContext)this.myDataContext);
        UpdateSession updateSession = Utils.getOrCreateUpdateSession((AnActionEvent)event);
        if (updateSession == null) {
            GotoActionModel.$$$reportNull$$$0(0);
        }
        return updateSession;
    }

    void buildGroupMappings() {
        if (!this.myActionGroups.isEmpty()) {
            return;
        }
        ActionGroup mainMenu = Objects.requireNonNull((ActionGroup)this.myActionManager.getActionOrStub("MainMenu"));
        ActionGroup keymapOthers = Objects.requireNonNull((ActionGroup)this.myActionManager.getActionOrStub("Other.KeymapGroup"));
        HashMap mainGroups = new HashMap();
        this.collectActions(mainGroups, mainMenu, Collections.emptyList(), false);
        HashMap<AnAction, GroupMapping> otherGroups = new HashMap<AnAction, GroupMapping>();
        this.collectActions(otherGroups, keymapOthers, Collections.emptyList(), true);
        this.myActionGroups.putAll(mainGroups);
        otherGroups.forEach(this.myActionGroups::putIfAbsent);
    }

    @NotNull
    Map<String, ApplyIntentionAction> getAvailableIntentions() {
        Editor editor2;
        TreeMap<String, ApplyIntentionAction> map2 = new TreeMap<String, ApplyIntentionAction>();
        Editor editor3 = editor2 = this.myEditor != null ? (Editor)this.myEditor.get() : null;
        if (!(this.myProject == null || this.myProject.isDisposed() || DumbService.isDumb(this.myProject) || editor2 == null || editor2.isDisposed())) {
            ApplyIntentionAction[] children2;
            PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(editor2.getDocument());
            ApplyIntentionAction[] applyIntentionActionArray = children2 = file2 == null ? null : ApplyIntentionAction.getAvailableIntentions(editor2, file2);
            if (children2 != null) {
                for (ApplyIntentionAction action2 : children2) {
                    map2.put(action2.getName(), action2);
                }
            }
        }
        TreeMap<String, ApplyIntentionAction> treeMap = map2;
        if (treeMap == null) {
            GotoActionModel.$$$reportNull$$$0(1);
        }
        return treeMap;
    }

    @Override
    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getCheckBoxName() {
        String string2 = IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
        if (string2 == null) {
            GotoActionModel.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getNotInMessage() {
        String string2 = IdeBundle.message((String)"label.no.enabled.actions.found", (Object[])new Object[0]);
        if (string2 == null) {
            GotoActionModel.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getNotFoundMessage() {
        String string2 = IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
        if (string2 == null) {
            GotoActionModel.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    public boolean loadInitialCheckBoxState() {
        return false;
    }

    @Override
    public void saveInitialCheckBoxState(boolean state) {
    }

    @ApiStatus.Internal
    public void clearCaches() {
        this.myActionGroups.clear();
        this.myUpdateSession = this.newUpdateSession();
    }

    @Override
    @NotNull
    public ListCellRenderer<?> getListCellRenderer() {
        return new GotoActionListCellRenderer(this::getGroupName);
    }

    @NotNull
    private static LayeredIcon createLayeredIcon(@Nullable Icon icon2, boolean disabled) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon2 == null) {
            LayeredIcon layeredIcon2 = layeredIcon;
            if (layeredIcon2 == null) {
                GotoActionModel.$$$reportNull$$$0(5);
            }
            return layeredIcon2;
        }
        int width = icon2.getIconWidth();
        int height = icon2.getIconHeight();
        int emptyIconWidth = EMPTY_ICON.getIconWidth();
        int emptyIconHeight = EMPTY_ICON.getIconHeight();
        if (width <= emptyIconWidth && height <= emptyIconHeight) {
            layeredIcon.setIcon(disabled && IconLoader.isGoodSize(icon2) ? IconLoader.getDisabledIcon(icon2) : icon2, 1, (emptyIconWidth - width) / 2, (emptyIconHeight - height) / 2);
        }
        LayeredIcon layeredIcon3 = layeredIcon;
        if (layeredIcon3 == null) {
            GotoActionModel.$$$reportNull$$$0(6);
        }
        return layeredIcon3;
    }

    @Override
    public int compare(@NotNull Object o1, @NotNull Object o2) {
        if (o1 == null) {
            GotoActionModel.$$$reportNull$$$0(7);
        }
        if (o2 == null) {
            GotoActionModel.$$$reportNull$$$0(8);
        }
        if ("...".equals(o1)) {
            return 1;
        }
        if ("...".equals(o2)) {
            return -1;
        }
        return ((MatchedValue)o1).compareWeights((MatchedValue)o2);
    }

    public static Color defaultActionForeground(boolean isSelected, boolean hasFocus, @Nullable Presentation presentation2) {
        if (isSelected) {
            return UIUtil.getListSelectionForeground(hasFocus);
        }
        if (presentation2 != null && !presentation2.isEnabledAndVisible()) {
            return UIUtil.getInactiveTextColor();
        }
        return UIUtil.getListForeground();
    }

    @Override
    public String @NotNull [] getNames(boolean checkBoxState) {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(9);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public Object @NotNull [] getElementsByName(@NotNull String id2, boolean checkBoxState, @NotNull String pattern) {
        if (id2 == null) {
            GotoActionModel.$$$reportNull$$$0(10);
        }
        if (pattern == null) {
            GotoActionModel.$$$reportNull$$$0(11);
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(12);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Nls
    @NotNull
    public String getGroupName(@NotNull OptionDescription description) {
        String settings;
        if (description == null) {
            GotoActionModel.$$$reportNull$$$0(13);
        }
        if (description instanceof RegistryTextOptionDescriptor) {
            String string2 = LangBundle.message("group.registry", new Object[0]);
            if (string2 == null) {
                GotoActionModel.$$$reportNull$$$0(14);
            }
            return string2;
        }
        String groupName = description.getGroupName();
        String string3 = settings = SystemInfo.isMac ? LangBundle.message("group.preferences", new Object[0]) : LangBundle.message("group.settings", new Object[0]);
        if (groupName == null || groupName.equals(description.getHit())) {
            String string4 = settings;
            if (string4 == null) {
                GotoActionModel.$$$reportNull$$$0(15);
            }
            return string4;
        }
        String string5 = settings + " > " + groupName;
        if (string5 == null) {
            GotoActionModel.$$$reportNull$$$0(16);
        }
        return string5;
    }

    @NotNull Map<@NonNls String, @NlsContexts.ConfigurableName String> getConfigurablesNames() {
        Map<String, String> map2 = this.myConfigurablesNames.getValue();
        if (map2 == null) {
            GotoActionModel.$$$reportNull$$$0(17);
        }
        return map2;
    }

    private void collectActions(@NotNull Map<? super AnAction, GroupMapping> actionGroups, @NotNull ActionGroup group, @NotNull List<ActionGroup> path2, boolean showNonPopupGroups) {
        if (actionGroups == null) {
            GotoActionModel.$$$reportNull$$$0(18);
        }
        if (group == null) {
            GotoActionModel.$$$reportNull$$$0(19);
        }
        if (path2 == null) {
            GotoActionModel.$$$reportNull$$$0(20);
        }
        if (actionGroups.containsKey(group)) {
            return;
        }
        AnAction[] actions2 = group instanceof DefaultActionGroup ? group.getChildren(null, ActionManager.getInstance()) : AnAction.EMPTY_ARRAY;
        boolean hasRegisteredChild = ContainerUtil.exists(actions2, action2 -> this.myActionManager.getId(action2) != null);
        if (!hasRegisteredChild) {
            GroupMapping mapping = actionGroups.computeIfAbsent((AnAction)group, __ -> new GroupMapping(showNonPopupGroups));
            mapping.addPath(path2);
        }
        List<ActionGroup> newPath = ContainerUtil.append(path2, group);
        for (AnAction action3 : actions2) {
            if (action3 == null || action3 instanceof Separator) continue;
            if (action3 instanceof ActionGroup) {
                this.collectActions(actionGroups, (ActionGroup)action3, newPath, showNonPopupGroups);
                continue;
            }
            GroupMapping mapping = actionGroups.computeIfAbsent((AnAction)action3, __ -> new GroupMapping(showNonPopupGroups));
            mapping.addPath(newPath);
        }
    }

    @Nullable
    GroupMapping getGroupMapping(@NotNull AnAction action2) {
        if (action2 == null) {
            GotoActionModel.$$$reportNull$$$0(21);
        }
        return this.myActionGroups.get(action2);
    }

    @Override
    @Nullable
    public String getFullName(@NotNull Object element2) {
        if (element2 == null) {
            GotoActionModel.$$$reportNull$$$0(22);
        }
        return this.getElementName(element2);
    }

    @Override
    @NonNls
    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    @Override
    public String @NotNull [] getSeparators() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(23);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    @Nullable
    public String getElementName(@NotNull Object mv) {
        if (mv == null) {
            GotoActionModel.$$$reportNull$$$0(24);
        }
        return ((MatchedValue)mv).getValueText();
    }

    @NotNull
    MatchMode actionMatches(@NotNull String pattern, com.intellij.util.text.Matcher matcher, @NotNull AnAction anAction) {
        if (pattern == null) {
            GotoActionModel.$$$reportNull$$$0(25);
        }
        if (anAction == null) {
            GotoActionModel.$$$reportNull$$$0(26);
        }
        Presentation presentation2 = anAction.getTemplatePresentation().clone();
        anAction.applyTextOverride("GoToAction", presentation2);
        String text2 = presentation2.getText();
        String description = presentation2.getDescription();
        if (text2 != null && matcher.matches(text2)) {
            MatchMode matchMode = MatchMode.NAME;
            if (matchMode == null) {
                GotoActionModel.$$$reportNull$$$0(27);
            }
            return matchMode;
        }
        for (Supplier synonym : anAction.getSynonyms()) {
            if (!matcher.matches((String)synonym.get())) continue;
            MatchMode matchMode = MatchMode.SYNONYM;
            if (matchMode == null) {
                GotoActionModel.$$$reportNull$$$0(28);
            }
            return matchMode;
        }
        if (description != null && !description.equals(text2) && new WordPrefixMatcher(pattern).matches(description)) {
            MatchMode matchMode = MatchMode.DESCRIPTION;
            if (matchMode == null) {
                GotoActionModel.$$$reportNull$$$0(29);
            }
            return matchMode;
        }
        if (text2 == null) {
            MatchMode matchMode = MatchMode.NONE;
            if (matchMode == null) {
                GotoActionModel.$$$reportNull$$$0(30);
            }
            return matchMode;
        }
        GroupMapping groupMapping = this.myActionGroups.get(anAction);
        if (groupMapping != null) {
            for (String groupName : groupMapping.getAllGroupNames()) {
                if (matcher.matches(groupName + " " + text2)) {
                    MatchMode matchMode = anAction instanceof ToggleAction ? MatchMode.NAME : MatchMode.GROUP;
                    if (matchMode == null) {
                        GotoActionModel.$$$reportNull$$$0(31);
                    }
                    return matchMode;
                }
                if (!matcher.matches(text2 + " " + groupName)) continue;
                MatchMode matchMode = MatchMode.GROUP;
                if (matchMode == null) {
                    GotoActionModel.$$$reportNull$$$0(32);
                }
                return matchMode;
            }
        }
        for (GotoActionAliasMatcher m : GotoActionAliasMatcher.EP_NAME.getExtensions()) {
            MatchMode match = m.matchAction(anAction, pattern);
            if (match == MatchMode.NONE) continue;
            MatchMode matchMode = match;
            if (matchMode == null) {
                GotoActionModel.$$$reportNull$$$0(33);
            }
            return matchMode;
        }
        MatchMode matchMode = MatchMode.NONE;
        if (matchMode == null) {
            GotoActionModel.$$$reportNull$$$0(34);
        }
        return matchMode;
    }

    @Nullable
    Project getProject() {
        return this.myProject;
    }

    @NotNull
    DataContext getDataContext() {
        DataContext dataContext = this.myDataContext;
        if (dataContext == null) {
            GotoActionModel.$$$reportNull$$$0(35);
        }
        return dataContext;
    }

    @NotNull
    private UpdateSession getUpdateSession() {
        UpdateSession updateSession = this.myUpdateSession;
        if (updateSession == null) {
            GotoActionModel.$$$reportNull$$$0(36);
        }
        return updateSession;
    }

    @NotNull
    public SortedSet<Object> sortItems(@NotNull Set<Object> elements) {
        if (elements == null) {
            GotoActionModel.$$$reportNull$$$0(37);
        }
        TreeSet<Object> objects = new TreeSet<Object>(this);
        objects.addAll(elements);
        TreeSet<Object> treeSet = objects;
        if (treeSet == null) {
            GotoActionModel.$$$reportNull$$$0(38);
        }
        return treeSet;
    }

    @Override
    public boolean willOpenEditor() {
        return false;
    }

    @Override
    public boolean useMiddleMatching() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 37: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroups";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newUpdateSession";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayeredIcon";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurablesNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "actionMatches";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateSession";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "sortItems";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectActions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getGroupMapping";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "actionMatches";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sortItems";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 37: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @DirtyUI
    public static class GotoActionListCellRenderer
    extends DefaultListCellRenderer {
        public static final Border TOGGLE_BUTTON_BORDER = JBUI.Borders.empty(0, 2);
        private final Function<? super OptionDescription, @NlsActions.ActionText String> myGroupNamer;
        private final boolean myUseListFont;

        public GotoActionListCellRenderer(Function<? super OptionDescription, String> groupNamer) {
            this(groupNamer, false);
        }

        public GotoActionListCellRenderer(Function<? super OptionDescription, String> groupNamer, boolean useListFont) {
            this.myGroupNamer = groupNamer;
            this.myUseListFont = useListFont;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object matchedValue, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(0);
            }
            final SimpleColoredComponent nameComponent = new SimpleColoredComponent();
            boolean showIcon = UISettings.getInstance().getShowIconsInMenus();
            IconCompOptionalCompPanel<SimpleColoredComponent> panel2 = new IconCompOptionalCompPanel<SimpleColoredComponent>(nameComponent){

                public AccessibleContext getAccessibleContext() {
                    return nameComponent.getAccessibleContext();
                }
            };
            panel2.setBorder(JBUI.Borders.empty(2));
            panel2.setOpaque(true);
            Color bg = UIUtil.getListBackground(isSelected, cellHasFocus);
            panel2.setBackground(bg);
            if (this.myUseListFont) {
                nameComponent.setFont(list2.getFont());
            }
            nameComponent.setOpaque(false);
            if (matchedValue instanceof String) {
                if (showIcon) {
                    panel2.setIcon(EMPTY_ICON);
                }
                String str = GotoActionListCellRenderer.cutName((String)matchedValue, null, list2, panel2);
                nameComponent.append(str, new SimpleTextAttributes(0, GotoActionModel.defaultActionForeground(isSelected, cellHasFocus, null)));
                IconCompOptionalCompPanel<SimpleColoredComponent> iconCompOptionalCompPanel = panel2;
                if (iconCompOptionalCompPanel == null) {
                    GotoActionListCellRenderer.$$$reportNull$$$0(1);
                }
                return iconCompOptionalCompPanel;
            }
            Color groupFg = isSelected ? UIUtil.getListSelectionForeground(true) : UIUtil.getInactiveTextColor();
            Object value = ((MatchedValue)matchedValue).value;
            String pattern = ((MatchedValue)matchedValue).pattern;
            JBEmptyBorder eastBorder = JBUI.Borders.emptyRight(2);
            if (value instanceof ActionWrapper) {
                boolean disabled;
                ActionWrapper actionWithParentGroup = (ActionWrapper)value;
                AnAction anAction = actionWithParentGroup.getAction();
                boolean toggle = anAction instanceof ToggleAction;
                String groupName = actionWithParentGroup.getAction() instanceof ApplyIntentionAction ? null : actionWithParentGroup.getGroupName();
                Presentation presentation2 = actionWithParentGroup.getPresentation();
                Color fg = GotoActionModel.defaultActionForeground(isSelected, cellHasFocus, presentation2);
                boolean bl = disabled = !isSelected && !presentation2.isEnabledAndVisible();
                if (disabled) {
                    groupFg = UIUtil.getLabelDisabledForeground();
                }
                if (showIcon) {
                    Icon icon2 = presentation2.getIcon();
                    panel2.setIcon((Icon)GotoActionModel.createLayeredIcon(icon2, disabled));
                }
                if (toggle) {
                    DataContext dataContext = actionWithParentGroup.myModel.getDataContext();
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
                    boolean selected = ((ToggleAction)anAction).isSelected(event);
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else if (groupName != null) {
                    JLabel groupLabel = new JLabel(groupName);
                    groupLabel.setBackground(bg);
                    groupLabel.setBorder(eastBorder);
                    groupLabel.setForeground(groupFg);
                    panel2.setRight((JComponent)groupLabel);
                }
                panel2.setToolTipText(presentation2.getDescription());
                @NlsSafe String actionId = ActionManager.getInstance().getId(anAction);
                Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts();
                String shortcutText = KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts);
                String name2 = GotoActionListCellRenderer.getName(presentation2.getText(), groupName, toggle);
                name2 = GotoActionListCellRenderer.cutName(name2, shortcutText, list2, panel2);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, name2, pattern, fg, isSelected);
                if (UISettings.getInstance().getShowInplaceCommentsInternal() && actionId != null) {
                    nameComponent.append(" " + actionId + " ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                if (StringUtil.isNotEmpty(shortcutText)) {
                    nameComponent.append(" " + shortcutText, new SimpleTextAttributes(129, groupFg));
                }
            } else if (value instanceof OptionDescription) {
                if (!isSelected && !(value instanceof BooleanOptionDescription)) {
                    Color descriptorBg = StartupUiUtil.isUnderDarcula() ? ColorUtil.brighter(UIUtil.getListBackground(), 1) : JBUI.CurrentTheme.BigPopup.LIST_SETTINGS_BACKGROUND;
                    panel2.setBackground(descriptorBg);
                    nameComponent.setBackground(descriptorBg);
                }
                String hit = GotoActionListCellRenderer.calcHit((OptionDescription)value);
                Color fg = UIUtil.getListForeground(isSelected, cellHasFocus);
                if (showIcon) {
                    panel2.setIcon(EMPTY_ICON);
                }
                if (value instanceof BooleanOptionDescription) {
                    boolean selected = ((BooleanOptionDescription)value).isOptionEnabled();
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else {
                    JLabel settingsLabel = new JLabel(this.myGroupNamer.fun((OptionDescription)((OptionDescription)value)));
                    settingsLabel.setForeground(groupFg);
                    settingsLabel.setBackground(bg);
                    settingsLabel.setBorder(eastBorder);
                    panel2.setRight((JComponent)settingsLabel);
                }
                String name3 = GotoActionListCellRenderer.cutName(hit, null, list2, panel2);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, name3, pattern, fg, isSelected);
            }
            IconCompOptionalCompPanel<SimpleColoredComponent> iconCompOptionalCompPanel = panel2;
            if (iconCompOptionalCompPanel == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(2);
            }
            return iconCompOptionalCompPanel;
        }

        @NlsActions.ActionText
        @NotNull
        private static String calcHit(@NotNull OptionDescription value) {
            if (value == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(3);
            }
            if (value instanceof RegistryTextOptionDescriptor) {
                String string2 = value.getHit() + " = " + value.getValue();
                if (string2 == null) {
                    GotoActionListCellRenderer.$$$reportNull$$$0(4);
                }
                return string2;
            }
            String hit = StringUtil.defaultIfEmpty(value.getHit(), value.getOption());
            String string3 = StringUtil.unescapeXmlEntities(StringUtil.notNullize(hit)).replace(BundleBase.MNEMONIC_STRING, "").replace("  ", " ");
            if (string3 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(5);
            }
            return string3;
        }

        @NlsActions.ActionText
        private static String cutName(@NlsActions.ActionText String name2, @NlsSafe String shortcutText, JList<?> list2, IconCompOptionalCompPanel<SimpleColoredComponent> panel2) {
            if (!list2.isShowing() || list2.getWidth() <= 0) {
                return StringUtil.first(name2, 60, true);
            }
            if (name2.length() < 40) {
                return name2;
            }
            int freeSpace = GotoActionListCellRenderer.calcFreeSpace(list2, panel2, shortcutText);
            if (freeSpace <= 0) {
                return name2;
            }
            SimpleColoredComponent nameComponent = (SimpleColoredComponent)panel2.getCenter();
            FontMetrics fm = nameComponent.getFontMetrics(nameComponent.getFont());
            int strWidth = fm.stringWidth(name2);
            if (strWidth <= freeSpace) {
                return name2;
            }
            int cutSymbolIndex = (int)(((double)freeSpace - (double)fm.stringWidth("...")) / (double)strWidth * (double)name2.length());
            cutSymbolIndex = Integer.max(1, cutSymbolIndex);
            name2 = name2.substring(0, cutSymbolIndex);
            while (fm.stringWidth(name2 + "...") > freeSpace && name2.length() > 1) {
                name2 = name2.substring(0, name2.length() - 1);
            }
            return name2.trim() + "...";
        }

        private static int calcFreeSpace(JList<?> list2, IconCompOptionalCompPanel<SimpleColoredComponent> panel2, String shortcutText) {
            SimpleColoredComponent nameComponent = (SimpleColoredComponent)panel2.getCenter();
            Insets insets = nameComponent.getInsets();
            Insets ipad = nameComponent.getIpad();
            int freeSpace = list2.getWidth() - (list2.getInsets().right + list2.getInsets().left) - RendererPanelsUtils.calculateNonResizeableWidth(panel2) - (insets.right + insets.left) - (ipad.right + ipad.left);
            if (StringUtil.isNotEmpty(shortcutText)) {
                FontMetrics fm = nameComponent.getFontMetrics(nameComponent.getFont().deriveFont(1));
                freeSpace -= fm.stringWidth(" " + shortcutText);
            }
            return freeSpace;
        }

        private static void addOnOffButton(@NotNull IconCompOptionalCompPanel<SimpleColoredComponent> panel2, boolean selected) {
            if (panel2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(6);
            }
            OnOffButton button2 = new OnOffButton();
            button2.setSelected(selected);
            panel2.setRight((JComponent)button2);
            panel2.setBorder(TOGGLE_BUTTON_BORDER);
        }

        @NlsActions.ActionText
        @NotNull
        private static String getName(@Nullable @NlsActions.ActionText String text2, @Nullable @NlsActions.ActionText String groupName, boolean toggle) {
            Object object = toggle && StringUtil.isNotEmpty(groupName) ? (StringUtil.isNotEmpty(text2) ? groupName + ": " + text2 : groupName) : StringUtil.notNullize(text2);
            if (object == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(7);
            }
            return object;
        }

        private static void appendWithColoredMatches(SimpleColoredComponent nameComponent, @NotNull @NlsActions.ActionText String name2, @NotNull @NlsSafe String pattern, Color fg, boolean selected) {
            int matchStart;
            if (name2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(8);
            }
            if (pattern == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(9);
            }
            SimpleTextAttributes plain = new SimpleTextAttributes(0, fg);
            if (name2.startsWith("<html>")) {
                new HtmlToSimpleColoredComponentConverter(HtmlToSimpleColoredComponentConverter.DEFAULT_TAG_HANDLER).appendHtml(nameComponent, name2, plain);
                name2 = nameComponent.getCharSequence(false).toString();
            } else {
                nameComponent.append(name2, plain);
            }
            nameComponent.setDynamicSearchMatchHighlighting(false);
            if (selected && (matchStart = StringUtil.indexOfIgnoreCase(name2, pattern, 0)) >= 0) {
                nameComponent.setDynamicSearchMatchHighlighting(true);
                List<TextRange> fragments = Collections.singletonList(TextRange.from(matchStart, pattern.length()));
                SpeedSearchUtil.applySpeedSearchHighlighting((SimpleColoredComponent)nameComponent, fragments, (boolean)true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcHit";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "calcHit";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addOnOffButton";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "appendWithColoredMatches";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionWrapper {
        @NotNull
        private final AnAction myAction;
        @NotNull
        private final MatchMode myMode;
        @Nullable
        private final GroupMapping myGroupMapping;
        private final GotoActionModel myModel;
        private final Presentation myPresentation;
        private final String myActionText;

        public ActionWrapper(@NotNull AnAction action2, @Nullable GroupMapping groupMapping, @NotNull MatchMode mode, @NotNull GotoActionModel model2) {
            if (action2 == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            if (model2 == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            this.myAction = action2;
            this.myMode = mode;
            this.myGroupMapping = groupMapping;
            this.myModel = model2;
            this.myPresentation = ReadAction.nonBlocking(() -> {
                if (this.myGroupMapping != null) {
                    this.myGroupMapping.updateBeforeShow(this.myModel.getUpdateSession());
                }
                return this.myModel.getUpdateSession().presentation(this.myAction);
            }).executeSynchronously();
            this.myActionText = GotoActionItemProvider.getActionText(action2);
        }

        public String getActionText() {
            return this.myActionText;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            return anAction;
        }

        @NotNull
        public MatchMode getMode() {
            MatchMode matchMode = this.myMode;
            if (matchMode == null) {
                ActionWrapper.$$$reportNull$$$0(4);
            }
            return matchMode;
        }

        @Nullable
        public GroupMapping getGroupMapping() {
            return this.myGroupMapping;
        }

        public int compareWeights(@NotNull ActionWrapper o) {
            int compared;
            if (o == null) {
                ActionWrapper.$$$reportNull$$$0(5);
            }
            if ((compared = this.myMode.compareTo(o.getMode())) != 0) {
                return compared;
            }
            Presentation myPresentation = this.myAction.getTemplatePresentation();
            Presentation oPresentation = o.getAction().getTemplatePresentation();
            String myText = StringUtil.notNullize(this.myActionText);
            String oText = StringUtil.notNullize(o.getActionText());
            int byText = StringUtil.compare(StringUtil.trimEnd(myText, "..."), StringUtil.trimEnd(oText, "..."), true);
            if (byText != 0) {
                return byText;
            }
            int byTextLength = StringUtil.notNullize(myText).length() - StringUtil.notNullize(oText).length();
            if (byTextLength != 0) {
                return byTextLength;
            }
            int byGroup = Comparing.compare(this.myGroupMapping, o.myGroupMapping);
            if (byGroup != 0) {
                return byGroup;
            }
            int byDesc = StringUtil.compare(myPresentation.getDescription(), oPresentation.getDescription(), true);
            if (byDesc != 0) {
                return byDesc;
            }
            int byClassHashCode = Comparing.compare(this.myAction.getClass().hashCode(), o.myAction.getClass().hashCode());
            if (byClassHashCode != 0) {
                return byClassHashCode;
            }
            int byInstanceHashCode = Comparing.compare(this.myAction.hashCode(), o.myAction.hashCode());
            if (byInstanceHashCode != 0) {
                return byInstanceHashCode;
            }
            return 0;
        }

        public boolean isAvailable() {
            return this.getPresentation().isEnabledAndVisible();
        }

        @NotNull
        public Presentation getPresentation() {
            Presentation presentation2 = this.myPresentation;
            if (presentation2 == null) {
                ActionWrapper.$$$reportNull$$$0(6);
            }
            return presentation2;
        }

        public boolean hasPresentation() {
            return this.myPresentation != null;
        }

        @NlsActions.ActionText
        @Nullable
        public String getGroupName() {
            if (this.myGroupMapping == null) {
                return null;
            }
            String groupName = this.myGroupMapping.getBestGroupName();
            if (this.myAction instanceof ActionGroup && Objects.equals(this.myAction.getTemplatePresentation().getText(), groupName)) {
                return null;
            }
            return groupName;
        }

        public boolean isGroupAction() {
            return this.myAction instanceof ActionGroup;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActionWrapper && this.myAction.equals(((ActionWrapper)obj).myAction);
        }

        public int hashCode() {
            String text2 = this.myAction.getTemplatePresentation().getText();
            return text2 != null ? text2.hashCode() : 0;
        }

        public String toString() {
            return this.myAction.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareWeights";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GroupMapping
    implements Comparable<GroupMapping> {
        private final boolean myShowNonPopupGroups;
        private final List<List<ActionGroup>> myPaths = new ArrayList<List<ActionGroup>>();
        @Nullable
        private @NlsActions.ActionText String myBestGroupName;
        private boolean myBestNameComputed;

        public GroupMapping() {
            this(false);
        }

        public GroupMapping(boolean showNonPopupGroups) {
            this.myShowNonPopupGroups = showNonPopupGroups;
        }

        @NotNull
        public static GroupMapping createFromText(@NlsActions.ActionText String text2, boolean showGroupText) {
            GroupMapping mapping = new GroupMapping(showGroupText);
            mapping.addPath(Collections.singletonList(new DefaultActionGroup(text2, false)));
            GroupMapping groupMapping = mapping;
            if (groupMapping == null) {
                GroupMapping.$$$reportNull$$$0(0);
            }
            return groupMapping;
        }

        private void addPath(@NotNull List<ActionGroup> path2) {
            if (path2 == null) {
                GroupMapping.$$$reportNull$$$0(1);
            }
            this.myPaths.add(path2);
        }

        @Override
        public int compareTo(@NotNull GroupMapping o) {
            if (o == null) {
                GroupMapping.$$$reportNull$$$0(2);
            }
            return Comparing.compare(this.getFirstGroupName(), o.getFirstGroupName());
        }

        @NlsActions.ActionText
        @Nullable
        public String getBestGroupName() {
            if (this.myBestNameComputed) {
                return this.myBestGroupName;
            }
            return this.getFirstGroupName();
        }

        @Nullable
        public List<ActionGroup> getFirstGroup() {
            return ContainerUtil.getFirstItem(this.myPaths);
        }

        @Nls
        @Nullable
        private String getFirstGroupName() {
            List<ActionGroup> path2 = this.getFirstGroup();
            return path2 != null ? this.getPathName(path2) : null;
        }

        private void updateBeforeShow(@NotNull UpdateSession session) {
            if (session == null) {
                GroupMapping.$$$reportNull$$$0(3);
            }
            if (this.myBestNameComputed) {
                return;
            }
            this.myBestNameComputed = true;
            for (List<ActionGroup> path2 : this.myPaths) {
                String name2 = this.getActualPathName(path2, session);
                if (name2 == null) continue;
                this.myBestGroupName = name2;
                return;
            }
        }

        @NotNull
        public List<String> getAllGroupNames() {
            List<String> list2 = ContainerUtil.map(this.myPaths, path2 -> this.getPathName((List<? extends ActionGroup>)path2));
            if (list2 == null) {
                GroupMapping.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Nls
        @Nullable
        private String getPathName(@NotNull List<? extends ActionGroup> path2) {
            if (path2 == null) {
                GroupMapping.$$$reportNull$$$0(5);
            }
            String name2 = "";
            for (ActionGroup actionGroup : path2) {
                name2 = this.appendGroupName(name2, actionGroup, actionGroup.getTemplatePresentation());
            }
            return StringUtil.nullize(name2);
        }

        @Nls
        @Nullable
        private String getActualPathName(@NotNull List<? extends ActionGroup> path2, @NotNull UpdateSession session) {
            if (path2 == null) {
                GroupMapping.$$$reportNull$$$0(6);
            }
            if (session == null) {
                GroupMapping.$$$reportNull$$$0(7);
            }
            String name2 = "";
            for (ActionGroup actionGroup : path2) {
                Presentation presentation2 = session.presentation((AnAction)actionGroup);
                if (!presentation2.isVisible()) {
                    return null;
                }
                name2 = this.appendGroupName(name2, actionGroup, presentation2);
            }
            return StringUtil.nullize(name2);
        }

        @Nls
        @NotNull
        private String appendGroupName(@NotNull @Nls String prefix, @NotNull ActionGroup group, @NotNull Presentation presentation2) {
            String groupName;
            if (prefix == null) {
                GroupMapping.$$$reportNull$$$0(8);
            }
            if (group == null) {
                GroupMapping.$$$reportNull$$$0(9);
            }
            if (presentation2 == null) {
                GroupMapping.$$$reportNull$$$0(10);
            }
            if ((group.isPopup() || this.myShowNonPopupGroups) && !StringUtil.isEmptyOrSpaces(groupName = GroupMapping.getActionGroupName(presentation2))) {
                Object object = prefix.isEmpty() ? groupName : prefix + " | " + groupName;
                if (object == null) {
                    GroupMapping.$$$reportNull$$$0(11);
                }
                return object;
            }
            String string2 = prefix;
            if (string2 == null) {
                GroupMapping.$$$reportNull$$$0(12);
            }
            return string2;
        }

        @NlsActions.ActionText
        @Nullable
        private static String getActionGroupName(@NotNull Presentation presentation2) {
            String text2;
            if (presentation2 == null) {
                GroupMapping.$$$reportNull$$$0(13);
            }
            if ((text2 = presentation2.getText()) == null) {
                return null;
            }
            Matcher matcher = INNER_GROUP_WITH_IDS.matcher(text2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$GroupMapping";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFromText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$GroupMapping";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllGroupNames";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendGroupName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBeforeShow";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualPathName";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "appendGroupName";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionGroupName";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MatchedValue {
        @NotNull
        public final Object value;
        @NotNull
        final MatchedValueType type;
        @NotNull
        final String pattern;
        final int matchingDegree;

        MatchedValue(@NotNull Object value, @NotNull String pattern, @NotNull MatchedValueType type) {
            if (value == null) {
                MatchedValue.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                MatchedValue.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MatchedValue.$$$reportNull$$$0(2);
            }
            assert (value instanceof OptionDescription || value instanceof ActionWrapper);
            this.value = value;
            this.pattern = pattern;
            this.matchingDegree = this.calcMatchingDegree();
            this.type = type;
        }

        MatchedValue(@NotNull Object value, @NotNull String pattern, int degree, @NotNull MatchedValueType type) {
            if (value == null) {
                MatchedValue.$$$reportNull$$$0(3);
            }
            if (pattern == null) {
                MatchedValue.$$$reportNull$$$0(4);
            }
            if (type == null) {
                MatchedValue.$$$reportNull$$$0(5);
            }
            assert (value instanceof OptionDescription || value instanceof ActionWrapper);
            this.value = value;
            this.pattern = pattern;
            this.matchingDegree = degree;
            this.type = type;
        }

        @Nullable
        @VisibleForTesting
        public String getValueText() {
            return GotoActionItemProvider.getActionText(this.value);
        }

        @Nullable
        public String toString() {
            return this.getMatchingDegree() + " " + this.getValueText();
        }

        public int getMatchingDegree() {
            return this.matchingDegree;
        }

        @NotNull
        public MatchedValueType getType() {
            MatchedValueType matchedValueType = this.type;
            if (matchedValueType == null) {
                MatchedValue.$$$reportNull$$$0(6);
            }
            return matchedValueType;
        }

        public int getValueTypeWeight() {
            return MatchedValue.getTypeWeight(this.value);
        }

        private int calcMatchingDegree() {
            String text2 = this.getValueText();
            if (text2 != null) {
                int degree = this.getRank(text2);
                return this.value instanceof ActionWrapper && !((ActionWrapper)this.value).isGroupAction() ? degree + 1 : degree;
            }
            return 0;
        }

        private int getRank(@NotNull String text2) {
            if (text2 == null) {
                MatchedValue.$$$reportNull$$$0(7);
            }
            if (StringUtil.equalsIgnoreCase(StringUtil.trimEnd(text2, "..."), this.pattern)) {
                return 3;
            }
            if (StringUtil.startsWithIgnoreCase(text2, this.pattern)) {
                return 2;
            }
            if (StringUtil.containsIgnoreCase(text2, this.pattern)) {
                return 1;
            }
            return 0;
        }

        public int compareWeights(@NotNull MatchedValue o) {
            ActionWrapper value2;
            ActionWrapper value1;
            int compared;
            if (o == null) {
                MatchedValue.$$$reportNull$$$0(8);
            }
            if (o == this) {
                return 0;
            }
            int diff = o.getMatchingDegree() - this.getMatchingDegree();
            if (diff != 0) {
                return diff;
            }
            diff = MatchedValue.getTypeWeight(o.value) - MatchedValue.getTypeWeight(this.value);
            if (diff != 0) {
                return diff;
            }
            if (this.value instanceof ActionWrapper && o.value instanceof ActionWrapper && (compared = (value1 = (ActionWrapper)this.value).compareWeights(value2 = (ActionWrapper)o.value)) != 0) {
                return compared;
            }
            diff = StringUtil.notNullize(this.getValueText()).length() - StringUtil.notNullize(o.getValueText()).length();
            if (diff != 0) {
                return diff;
            }
            if (this.value instanceof OptionDescription && o.value instanceof OptionDescription && (diff = (value1 = (OptionDescription)this.value).compareTo((OptionDescription)(value2 = (OptionDescription)o.value))) != 0) {
                return diff;
            }
            return o.hashCode() - this.hashCode();
        }

        private static int getTypeWeight(@NotNull Object value) {
            if (value == null) {
                MatchedValue.$$$reportNull$$$0(9);
            }
            if (value instanceof ActionWrapper) {
                ActionWrapper actionWrapper = (ActionWrapper)value;
                if ((ApplicationManager.getApplication().isDispatchThread() || actionWrapper.hasPresentation()) && actionWrapper.isAvailable()) {
                    return 0;
                }
                return 2;
            }
            if (value instanceof OptionDescription) {
                if (value instanceof BooleanOptionDescription) {
                    return 1;
                }
                return 3;
            }
            throw new IllegalArgumentException(value.getClass() + " - " + value);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MatchedValue)) {
                return false;
            }
            MatchedValue value1 = (MatchedValue)o;
            return Objects.equals(this.value, value1.value) && Objects.equals(this.pattern, value1.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getRank";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "compareWeights";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeWeight";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum MatchedValueType {
        ABBREVIATION,
        INTENTION,
        TOP_HIT,
        OPTION,
        ACTION;

    }
}

