/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ChooseByNameWeightedItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ide.util.gotoByName.MatchMode;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.CollectConsumer;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.Processor;
import com.intellij.util.text.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GotoActionItemProvider
implements ChooseByNameWeightedItemProvider {
    private static final int BONUS_FOR_SPACE_IN_PATTERN = 100;
    private static final int SETTINGS_PENALTY = 100;
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final GotoActionModel myModel;
    private final ClearableLazyValue<Map<String, ApplyIntentionAction>> myIntentions;
    private static final Logger LOG = Logger.getInstance(GotoActionItemProvider.class);

    public GotoActionItemProvider(GotoActionModel model2) {
        this.myModel = model2;
        this.myIntentions = ClearableLazyValue.create(() -> ReadAction.nonBlocking(() -> this.myModel.getAvailableIntentions()).executeSynchronously());
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameViewModel base, String @NotNull [] names, @NotNull String pattern) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(1);
        }
        if (names == null) {
            GotoActionItemProvider.$$$reportNull$$$0(2);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(5);
        }
        if (cancelled == null) {
            GotoActionItemProvider.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            GotoActionItemProvider.$$$reportNull$$$0(7);
        }
        return this.filterElementsWithWeights(base, pattern, everywhere, cancelled, descriptor -> consumer.process(descriptor.getItem()));
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(8);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            GotoActionItemProvider.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            GotoActionItemProvider.$$$reportNull$$$0(11);
        }
        return this.filterElements(pattern, value -> {
            if (!everywhere && value.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)value.value).isAvailable()) {
                return true;
            }
            return consumer.process(new FoundItemDescriptor<GotoActionModel.MatchedValue>((GotoActionModel.MatchedValue)value, value.getMatchingDegree()));
        });
    }

    public boolean filterElements(@NotNull String pattern, @NotNull Predicate<? super GotoActionModel.MatchedValue> consumer) {
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            GotoActionItemProvider.$$$reportNull$$$0(13);
        }
        this.myModel.buildGroupMappings();
        return this.processAbbreviations(pattern, consumer) && this.processActions(pattern, consumer) && this.processTopHits(pattern, consumer) && this.processIntentions(pattern, consumer) && this.processOptions(pattern, consumer);
    }

    private boolean processAbbreviations(@NotNull String pattern, Predicate<? super GotoActionModel.MatchedValue> consumer) {
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(14);
        }
        MinusculeMatcher matcher = GotoActionItemProvider.buildWeightMatcher(pattern);
        List actionIds = AbbreviationManager.getInstance().findActions(pattern);
        Stream<1> wrappers = actionIds.stream().map(actionId -> {
            AnAction action2 = this.myActionManager.getAction(actionId);
            if (action2 == null) {
                return null;
            }
            GotoActionModel.ActionWrapper wrapper2 = this.wrapAnAction(action2);
            int degree = matcher.matchingDegree(pattern);
            return new GotoActionModel.MatchedValue(wrapper2, pattern, degree, GotoActionModel.MatchedValueType.ABBREVIATION){

                @Override
                @NotNull
                public String getValueText() {
                    String string2 = this.pattern;
                    if (string2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionItemProvider$1", "getValueText"));
                }
            };
        }).filter(Objects::nonNull);
        return GotoActionItemProvider.processItems(pattern, GotoActionModel.MatchedValueType.ABBREVIATION, wrappers, consumer);
    }

    private boolean processTopHits(String pattern, Predicate<? super GotoActionModel.MatchedValue> consumer) {
        Project project2 = this.myModel.getProject();
        CollectConsumer collector2 = new CollectConsumer();
        String commandAccelerator = SearchTopHitProvider.getTopHitAccelerator();
        for (SearchTopHitProvider provider2 : SearchTopHitProvider.EP_NAME.getExtensionList()) {
            if (provider2 instanceof OptionsTopHitProvider.CoveredByToggleActions) continue;
            if (provider2 instanceof OptionsSearchTopHitProvider && !pattern.startsWith(commandAccelerator)) {
                String prefix = commandAccelerator + ((OptionsSearchTopHitProvider)provider2).getId() + " ";
                provider2.consumeTopHits(prefix + pattern, collector2, project2);
            } else if (project2 != null && provider2 instanceof OptionsTopHitProvider.ProjectLevelProvidersAdapter) {
                ((OptionsTopHitProvider.ProjectLevelProvidersAdapter)provider2).consumeAllTopHits(pattern, collector2, project2);
            }
            provider2.consumeTopHits(pattern, collector2, project2);
        }
        Collection result2 = collector2.getResult();
        Stream<Object> wrappers = result2.stream().map(object -> object instanceof AnAction ? this.wrapAnAction((AnAction)object) : object);
        return GotoActionItemProvider.processItems(pattern, GotoActionModel.MatchedValueType.TOP_HIT, wrappers, consumer);
    }

    private boolean processOptions(String pattern, Predicate<? super GotoActionModel.MatchedValue> consumer) {
        Map<@NonNls String, @NlsContexts.ConfigurableName String> map2 = this.myModel.getConfigurablesNames();
        SearchableOptionsRegistrarImpl registrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        ArrayList<GotoActionModel.ActionWrapper> options = new ArrayList<GotoActionModel.ActionWrapper>();
        Set words = registrar.getProcessedWords(pattern);
        Set<OptionDescription> optionDescriptions = null;
        boolean filterOutInspections = Registry.is("go.to.action.filter.out.inspections", true);
        for (Object word : words) {
            Set set2 = Objects.requireNonNullElse(registrar.getAcceptableDescriptions((String)word), new HashSet());
            set2.removeIf(description -> "ActionManager".equals(description.getPath()) || filterOutInspections && "Inspections".equals(description.getGroupName()));
            if (!set2.isEmpty()) {
                if (optionDescriptions == null) {
                    optionDescriptions = set2;
                    continue;
                }
                optionDescriptions.retainAll(set2);
                continue;
            }
            optionDescriptions = null;
            break;
        }
        if (!Strings.isEmptyOrSpaces(pattern)) {
            Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
            if (optionDescriptions == null) {
                optionDescriptions = new HashSet();
            }
            for (Map.Entry entry : map2.entrySet()) {
                if (!matcher.matches((String)entry.getValue())) continue;
                optionDescriptions.add(new OptionDescription(null, (String)entry.getKey(), (String)entry.getValue(), null, (String)entry.getValue()));
            }
        }
        if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
            HashSet<String> currentHits = new HashSet<String>();
            Iterator iterator = optionDescriptions.iterator();
            while (iterator.hasNext()) {
                OptionDescription optionDescription = (OptionDescription)iterator.next();
                String hit = optionDescription.getHit();
                if (hit != null && currentHits.add(hit.trim())) continue;
                iterator.remove();
            }
            for (OptionDescription optionDescription : optionDescriptions) {
                for (ActionFromOptionDescriptorProvider converter : ActionFromOptionDescriptorProvider.EP.getExtensionList()) {
                    AnAction action2 = converter.provide(optionDescription);
                    if (action2 == null) continue;
                    options.add(new GotoActionModel.ActionWrapper(action2, null, MatchMode.NAME, this.myModel));
                }
                options.add((GotoActionModel.ActionWrapper)optionDescription);
            }
        }
        return GotoActionItemProvider.processItems(pattern, GotoActionModel.MatchedValueType.OPTION, options.stream(), consumer);
    }

    private boolean processActions(String pattern, Predicate<? super GotoActionModel.MatchedValue> consumer) {
        Set ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
        Stream<AnAction> actions2 = ids.stream().map(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0)).filter(Objects::nonNull);
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        QuickActionProvider provider2 = (QuickActionProvider)this.myModel.getDataContext().getData(QuickActionProvider.KEY);
        if (provider2 != null) {
            actions2 = Stream.concat(actions2, provider2.getActions(true).stream());
        }
        Stream<GotoActionModel.ActionWrapper> actionWrappers = actions2.distinct().map(action2 -> {
            if (action2 instanceof ActionGroup && !((ActionGroup)action2).isSearchable()) {
                return null;
            }
            MatchMode mode = this.myModel.actionMatches(pattern, matcher, (AnAction)action2);
            if (mode == MatchMode.NONE) {
                return null;
            }
            return new GotoActionModel.ActionWrapper((AnAction)action2, this.myModel.getGroupMapping((AnAction)action2), mode, this.myModel);
        }).filter(Objects::nonNull);
        return GotoActionItemProvider.processItems(pattern, GotoActionModel.MatchedValueType.ACTION, actionWrappers, consumer);
    }

    public void clearIntentions() {
        this.myIntentions.drop();
    }

    @NotNull
    static Matcher buildMatcher(String pattern) {
        Object object = pattern.contains(" ") ? new WordPrefixMatcher(pattern) : NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (object == null) {
            GotoActionItemProvider.$$$reportNull$$$0(15);
        }
        return object;
    }

    private boolean processIntentions(String pattern, Predicate<? super GotoActionModel.MatchedValue> consumer) {
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        Map<@NlsActions.ActionText String, ApplyIntentionAction> intentionMap = this.myIntentions.getValue();
        Stream<GotoActionModel.ActionWrapper> intentions = intentionMap.keySet().stream().map(intentionText -> {
            ApplyIntentionAction intentionAction = (ApplyIntentionAction)((Object)((Object)intentionMap.get(intentionText)));
            if (this.myModel.actionMatches(pattern, matcher, intentionAction) == MatchMode.NONE) {
                return null;
            }
            GotoActionModel.GroupMapping groupMapping = GotoActionModel.GroupMapping.createFromText(intentionText, false);
            return new GotoActionModel.ActionWrapper(intentionAction, groupMapping, MatchMode.INTENTION, this.myModel);
        }).filter(Objects::nonNull);
        return GotoActionItemProvider.processItems(pattern, GotoActionModel.MatchedValueType.INTENTION, intentions, consumer);
    }

    @NotNull
    private GotoActionModel.ActionWrapper wrapAnAction(@NotNull AnAction action2) {
        if (action2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(16);
        }
        return new GotoActionModel.ActionWrapper(action2, this.myModel.getGroupMapping(action2), MatchMode.NAME, this.myModel);
    }

    private static boolean processItems(String pattern, @NotNull GotoActionModel.MatchedValueType type, @NotNull Stream<?> items, Predicate<? super GotoActionModel.MatchedValue> consumer) {
        if (type == null) {
            GotoActionItemProvider.$$$reportNull$$$0(17);
        }
        if (items == null) {
            GotoActionItemProvider.$$$reportNull$$$0(18);
        }
        MinusculeMatcher matcher = GotoActionItemProvider.buildWeightMatcher(pattern);
        List matched = items.map(o -> {
            if (o instanceof GotoActionModel.MatchedValue) {
                return (GotoActionModel.MatchedValue)o;
            }
            Integer weight = GotoActionItemProvider.calcElementWeight(o, pattern, matcher);
            return weight == null ? new GotoActionModel.MatchedValue(o, pattern, type) : new GotoActionModel.MatchedValue(o, pattern, weight, type);
        }).collect(Collectors.toList());
        try {
            matched.sort((o1, o2) -> o1.compareWeights((GotoActionModel.MatchedValue)o2));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Comparison method violates its general contract with pattern '" + pattern + "'", e);
        }
        for (GotoActionModel.MatchedValue t : matched) {
            if (consumer.test(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Integer calcElementWeight(Object element2, String pattern, MinusculeMatcher matcher) {
        Integer degree = GotoActionItemProvider.calculateDegree(matcher, GotoActionItemProvider.getActionText(element2));
        if (degree == null) {
            return null;
        }
        if (degree == 0 && (degree = GotoActionItemProvider.calculateDegree(matcher, DefaultBundleService.getInstance().compute(() -> GotoActionItemProvider.getAnActionOriginalText(GotoActionItemProvider.getAction(element2))))) == null) {
            return null;
        }
        if (pattern.trim().contains(" ")) {
            degree = degree + 100;
        }
        if (element2 instanceof OptionDescription && degree > 0) {
            degree = degree - 100;
        }
        return Math.max(degree, 0);
    }

    @Nullable
    private static Integer calculateDegree(MinusculeMatcher matcher, @Nullable String text2) {
        if (text2 == null) {
            return null;
        }
        return matcher.matchingDegree(text2);
    }

    private static MinusculeMatcher buildWeightMatcher(String pattern) {
        return NameUtil.buildMatcher((String)("*" + pattern)).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE).preferringStartMatches().build();
    }

    @Nullable
    @Nls
    public static String getActionText(Object value) {
        if (value instanceof OptionDescription) {
            return ((OptionDescription)value).getHit();
        }
        if (value instanceof AnAction) {
            return GotoActionItemProvider.getAnActionText((AnAction)value);
        }
        if (value instanceof GotoActionModel.ActionWrapper) {
            return GotoActionItemProvider.getAnActionText(((GotoActionModel.ActionWrapper)value).getAction());
        }
        return null;
    }

    @Nullable
    private static AnAction getAction(Object value) {
        if (value instanceof AnAction) {
            return (AnAction)value;
        }
        if (value instanceof GotoActionModel.ActionWrapper) {
            return ((GotoActionModel.ActionWrapper)value).getAction();
        }
        return null;
    }

    @Nullable
    @Nls
    private static String getAnActionText(AnAction value) {
        Presentation presentation2 = value.getTemplatePresentation().clone();
        value.applyTextOverride("GoToAction", presentation2);
        return presentation2.getText();
    }

    @Nullable
    private static String getAnActionOriginalText(@Nullable AnAction value) {
        if (value == null) {
            return null;
        }
        Presentation presentation2 = value.getTemplatePresentation().clone();
        value.applyTextOverride("GoToAction", presentation2);
        TextWithMnemonic mnemonic = (TextWithMnemonic)presentation2.getTextWithPossibleMnemonic().get();
        if (mnemonic == null) {
            return null;
        }
        return mnemonic.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 3: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterElementsWithWeights";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processAbbreviations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wrapAnAction";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processItems";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

