/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteNameDescriptionLocation;
import com.intellij.ide.util.DeleteTypeDescriptionLocation;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FactoryMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public final class DeleteUtil {
    private DeleteUtil() {
    }

    @NlsContexts.DialogMessage
    public static String generateWarningMessage(@PropertyKey(resourceBundle="messages.IdeBundle") @PropertyKey(resourceBundle="messages.IdeBundle") String key, PsiElement @NotNull [] elements) {
        if (elements == null) {
            DeleteUtil.$$$reportNull$$$0(0);
        }
        if (elements.length == 1) {
            String name2 = ElementDescriptionUtil.getElementDescription(elements[0], DeleteNameDescriptionLocation.INSTANCE);
            String type = ElementDescriptionUtil.getElementDescription(elements[0], DeleteTypeDescriptionLocation.SINGULAR);
            return IdeBundle.message((String)key, (Object[])new Object[]{type + (String)(StringUtil.isEmptyOrSpaces(name2) ? "" : " \"" + name2 + "\"")});
        }
        Map<String, Integer> countMap = FactoryMap.create(k -> 0);
        HashMap<String, String> pluralToSingular = new HashMap<String, String>();
        int directoryCount = 0;
        String containerType = null;
        for (PsiElement elementToDelete : elements) {
            String type = ElementDescriptionUtil.getElementDescription(elementToDelete, DeleteTypeDescriptionLocation.PLURAL);
            pluralToSingular.put(type, ElementDescriptionUtil.getElementDescription(elementToDelete, DeleteTypeDescriptionLocation.SINGULAR));
            int oldCount = countMap.get(type);
            countMap.put(type, oldCount + 1);
            if (!(elementToDelete instanceof PsiDirectoryContainer)) continue;
            containerType = type;
            directoryCount += ((PsiDirectoryContainer)elementToDelete).getDirectories().length;
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            if (buffer.length() > 0) {
                buffer.append(" ").append(IdeBundle.message((String)"prompt.delete.and", (Object[])new Object[0])).append(" ");
            }
            int count2 = entry.getValue();
            buffer.append(count2).append(" ");
            if (count2 == 1) {
                buffer.append((String)pluralToSingular.get(entry.getKey()));
            } else {
                buffer.append(entry.getKey());
            }
            if (!entry.getKey().equals(containerType)) continue;
            buffer.append(" ").append(IdeBundle.message((String)"prompt.delete.directory.paren", (Object[])new Object[]{directoryCount}));
        }
        return IdeBundle.message((String)key, (Object[])new Object[]{buffer.toString()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/DeleteUtil", "generateWarningMessage"));
    }
}

