/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.TextWithIcon;
import java.io.File;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
public class DefaultModuleRendererFactory
extends ModuleRendererFactory {
    @Override
    @Nullable
    public final TextWithIcon getModuleTextWithIcon(Object element2) {
        if (element2 instanceof PsiElement && ((PsiElement)element2).isValid()) {
            return this.elementLocation((PsiElement)element2);
        }
        return null;
    }

    @Nullable
    private TextWithIcon elementLocation(@NotNull PsiElement element2) {
        if (element2 == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(0);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(element2.getProject()).getFileIndex();
        VirtualFile vFile = PsiUtilCore.getVirtualFile(element2);
        if (vFile != null && fileIndex.isInLibrary(vFile)) {
            return this.libraryLocation(fileIndex, vFile);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(element2);
        if (module != null) {
            return DefaultModuleRendererFactory.projectLocation(vFile, module, fileIndex);
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static TextWithIcon projectLocation(@Nullable VirtualFile vFile, @NotNull Module module, @NotNull ProjectFileIndex fileIndex) {
        String path2;
        boolean inTestSource;
        if (module == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(1);
        }
        if (fileIndex == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(2);
        }
        boolean bl = inTestSource = vFile != null && fileIndex.isInTestSourceContent(vFile);
        String text2 = Registry.is("ide.show.folder.name.instead.of.module.name") ? (StringUtil.isEmpty(path2 = ModuleUtilCore.getModuleDirPath(module)) ? module.getName() : new File(path2).getName()) : module.getName();
        Icon icon2 = inTestSource ? AllIcons.Nodes.TestSourceFolder : ModuleType.get((Module)module).getIcon();
        return new TextWithIcon(text2, icon2);
    }

    @ApiStatus.Internal
    @NotNull
    public TextWithIcon libraryLocation(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        Object text2;
        if (fileIndex == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(3);
        }
        if (vFile == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(text2 = this.orderEntryText(fileIndex, vFile))) && Registry.is("index.run.configuration.jre")) {
            for (Sdk sdk2 : ProjectJdkTable.getInstance().getAllJdks()) {
                Set roots2 = StreamEx.of((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)).append((Object[])sdk2.getRootProvider().getFiles(OrderRootType.SOURCES)).toSet();
                if (!VfsUtilCore.isUnder(vFile, roots2)) continue;
                text2 = "< " + sdk2.getName() + " >";
                break;
            }
        }
        text2 = ((String)text2).substring(((String)text2).lastIndexOf(File.separatorChar) + 1);
        VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(vFile);
        if (jar != null && !((String)text2).equals(jar.getName())) {
            text2 = (String)text2 + " (" + jar.getName() + ")";
        }
        return new TextWithIcon((String)text2, AllIcons.Nodes.PpLibFolder);
    }

    @Nls
    @NotNull
    private String orderEntryText(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        if (fileIndex == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(5);
        }
        if (vFile == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(6);
        }
        for (OrderEntry order : fileIndex.getOrderEntriesForFile(vFile)) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            String string2 = this.getPresentableName(order, vFile);
            if (string2 == null) {
                DefaultModuleRendererFactory.$$$reportNull$$$0(7);
            }
            return string2;
        }
        return "";
    }

    @Nls
    @NotNull
    protected String getPresentableName(OrderEntry order, VirtualFile vFile) {
        String string2 = order.getPresentableName();
        if (string2 == null) {
            DefaultModuleRendererFactory.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/DefaultModuleRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/DefaultModuleRendererFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "orderEntryText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "elementLocation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "projectLocation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "libraryLocation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "orderEntryText";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

