/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TodoTreeHelper {
    private final Project myProject;

    public static TodoTreeHelper getInstance(Project project2) {
        return project2.getService(TodoTreeHelper.class);
    }

    public TodoTreeHelper(Project project2) {
        this.myProject = project2;
    }

    public void addPackagesToChildren(ArrayList<? super AbstractTreeNode<?>> children2, Module module, TodoTreeBuilder builder2) {
        this.addDirsToChildren(this.collectContentRoots(module), children2, builder2);
    }

    protected List<VirtualFile> collectContentRoots(Module module) {
        ArrayList<VirtualFile> roots2 = new ArrayList<VirtualFile>();
        if (module == null) {
            ContainerUtil.addAll(roots2, ProjectRootManager.getInstance(this.myProject).getContentRoots());
        } else {
            ContainerUtil.addAll(roots2, ModuleRootManager.getInstance(module).getContentRoots());
        }
        return roots2;
    }

    protected void addDirsToChildren(List<? extends VirtualFile> roots2, ArrayList<? super AbstractTreeNode<?>> children2, TodoTreeBuilder builder2) {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        for (VirtualFile virtualFile2 : roots2) {
            TodoDirNode dirNode;
            Iterator<PsiFile> files2;
            PsiDirectory directory = psiManager.findDirectory(virtualFile2);
            if (directory == null || !(files2 = builder2.getFiles(directory)).hasNext() || children2.contains(dirNode = new TodoDirNode(this.myProject, directory, builder2))) continue;
            children2.add(dirNode);
        }
    }

    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, TodoTreeBuilder builder2, boolean isFlatten) {
        ArrayList children2 = new ArrayList();
        if (!isFlatten || !this.skipDirectory(psiDirectory)) {
            Iterator<PsiFile> iterator = builder2.getFiles(psiDirectory);
            block0: while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                if (psiDirectory.equals(containingDirectory) && !children2.contains(todoFileNode)) {
                    children2.add(todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null && !this.skipDirectory(_dir)) {
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (parentDirectory != null && psiDirectory.equals(parentDirectory) && !children2.contains(todoDirNode)) {
                        children2.add(todoDirNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
            if (parentDirectory == null || !this.skipDirectory(parentDirectory) || !ProjectRootManager.getInstance(this.getProject()).getFileIndex().isInContent(parentDirectory.getVirtualFile())) {
                Iterator<PsiFile> iterator = builder2.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (psiDirectory.equals(psiFile.getContainingDirectory()) && !children2.contains(todoFileNode)) {
                        children2.add(todoFileNode);
                        continue;
                    }
                    PsiDirectory _dir = psiFile.getContainingDirectory();
                    if (_dir == null || this.skipDirectory(_dir)) continue;
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (!PsiTreeUtil.isAncestor(psiDirectory, _dir, true) || children2.contains(todoDirNode) || builder2.isDirectoryEmpty(_dir)) continue;
                    children2.add(todoDirNode);
                }
            } else {
                Iterator<PsiFile> iterator = builder2.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (!psiDirectory.equals(containingDirectory) || children2.contains(todoFileNode)) continue;
                    children2.add(todoFileNode);
                }
            }
        }
        children2.sort(TodoFileDirAndModuleComparator.INSTANCE);
        return children2;
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return false;
    }

    @Nullable
    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoDirNode) {
            TodoDirNode descriptor = (TodoDirNode)userObject;
            return (PsiElement)descriptor.getValue();
        }
        if (userObject instanceof TodoFileNode) {
            TodoFileNode descriptor = (TodoFileNode)userObject;
            return (PsiElement)descriptor.getValue();
        }
        return null;
    }

    public boolean contains(ProjectViewNode node2, Object element2) {
        return false;
    }

    public Project getProject() {
        return this.myProject;
    }
}

