/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.todo.ToDoSettings;
import com.intellij.ide.todo.ToDoSummary;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoPattern;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TodoTreeStructure
extends AbstractTreeStructureBase
implements ToDoSettings {
    protected TodoTreeBuilder myBuilder;
    protected AbstractTreeNode myRootElement;
    protected final ToDoSummary mySummaryElement = new ToDoSummary();
    private boolean myFlattenPackages;
    protected boolean myArePackagesShown = true;
    private boolean myAreModulesShown;
    protected final PsiTodoSearchHelper mySearchHelper;
    protected TodoFilter myTodoFilter;

    public TodoTreeStructure(Project project2) {
        super(project2);
        this.mySearchHelper = PsiTodoSearchHelper.getInstance((Project)project2);
    }

    final void setTreeBuilder(TodoTreeBuilder builder2) {
        this.myBuilder = builder2;
        this.myRootElement = this.createRootElement();
    }

    protected abstract AbstractTreeNode createRootElement();

    public abstract boolean accept(PsiFile var1);

    protected void validateCache() {
    }

    public final boolean isPackagesShown() {
        return this.myArePackagesShown;
    }

    final void setShownPackages(boolean state) {
        this.myArePackagesShown = state;
    }

    public final boolean areFlattenPackages() {
        return this.myFlattenPackages;
    }

    public final void setFlattenPackages(boolean state) {
        this.myFlattenPackages = state;
    }

    final void setTodoFilter(TodoFilter todoFilter) {
        this.myTodoFilter = todoFilter;
    }

    abstract Object getFirstSelectableElement();

    public final int getTodoItemCount(PsiFile psiFile) {
        int count2 = 0;
        if (psiFile != null) {
            if (this.myTodoFilter != null) {
                for (TodoPattern pattern : this.myTodoFilter) {
                    count2 += this.getSearchHelper().getTodoItemsCount(psiFile, pattern);
                }
            } else {
                count2 = this.getSearchHelper().getTodoItemsCount(psiFile);
            }
        }
        return count2;
    }

    boolean isAutoExpandNode(NodeDescriptor descriptor) {
        Object element2 = descriptor.getElement();
        if (element2 instanceof AbstractTreeNode) {
            element2 = ((AbstractTreeNode)element2).getValue();
        }
        return element2 == this.getRootElement() || element2 == this.mySummaryElement && (this.myAreModulesShown || this.myArePackagesShown);
    }

    public final void commit() {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance(this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = TodoTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            TodoTreeStructure.$$$reportNull$$$0(0);
        }
        return actionCallback;
    }

    @NotNull
    public final Object getRootElement() {
        AbstractTreeNode abstractTreeNode = this.myRootElement;
        if (abstractTreeNode == null) {
            TodoTreeStructure.$$$reportNull$$$0(1);
        }
        return abstractTreeNode;
    }

    public boolean getIsFlattenPackages() {
        return this.myFlattenPackages;
    }

    public PsiTodoSearchHelper getSearchHelper() {
        return this.mySearchHelper;
    }

    public TodoFilter getTodoFilter() {
        return this.myTodoFilter;
    }

    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    void setShownModules(boolean state) {
        this.myAreModulesShown = state;
    }

    @Override
    public boolean isModulesShown() {
        return this.myAreModulesShown;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/todo/TodoTreeStructure";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

