/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SmartTodoItemPointer {
    private final TodoItem myTodoItem;
    private final Document myDocument;
    private final RangeMarker myRangeMarker;
    private final List<RangeMarker> myAdditionalRangeMarkers;

    public SmartTodoItemPointer(@NotNull TodoItem todoItem, @NotNull Document document) {
        if (todoItem == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(0);
        }
        if (document == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(1);
        }
        this.myTodoItem = todoItem;
        this.myDocument = document;
        TextRange textRange = this.myTodoItem.getTextRange();
        this.myRangeMarker = document.createRangeMarker(textRange);
        this.myAdditionalRangeMarkers = ContainerUtil.map(todoItem.getAdditionalTextRanges(), document::createRangeMarker);
    }

    public TodoItem getTodoItem() {
        return this.myTodoItem;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    @NotNull
    public List<RangeMarker> getAdditionalRangeMarkers() {
        List<RangeMarker> list2 = this.myAdditionalRangeMarkers;
        if (list2 == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmartTodoItemPointer)) {
            return false;
        }
        SmartTodoItemPointer pointer = (SmartTodoItemPointer)obj;
        if (!this.myTodoItem.getFile().equals(pointer.myTodoItem.getFile()) || this.myRangeMarker.getStartOffset() != pointer.myRangeMarker.getStartOffset() || this.myRangeMarker.getEndOffset() != pointer.myRangeMarker.getEndOffset() || !this.myTodoItem.getPattern().equals((Object)pointer.myTodoItem.getPattern()) || this.myAdditionalRangeMarkers.size() != pointer.myAdditionalRangeMarkers.size()) {
            return false;
        }
        for (int i = 0; i < this.myAdditionalRangeMarkers.size(); ++i) {
            RangeMarker m1 = this.myAdditionalRangeMarkers.get(i);
            RangeMarker m2 = pointer.myAdditionalRangeMarkers.get(i);
            if (m1.getStartOffset() == m2.getStartOffset() && m1.getEndOffset() == m2.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myTodoItem.getFile().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/SmartTodoItemPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/SmartTodoItemPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRangeMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

