/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final VirtualFile myVirtualFile;
    private final Project myProject;

    @NotNull
    public static TemplateLanguageStructureViewBuilder create(@NotNull PsiFile psiFile, final @Nullable PairFunction<? super PsiFile, ? super Editor, ? extends StructureViewModel> modelFactory) {
        if (psiFile == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(0);
        }
        return new TemplateLanguageStructureViewBuilder(psiFile){

            @Override
            protected TreeBasedStructureViewBuilder createMainBuilder(final @NotNull PsiFile psi) {
                if (psi == null) {
                    1.$$$reportNull$$$0(0);
                }
                return modelFactory == null ? null : new TreeBasedStructureViewBuilder(){

                    public boolean isRootNodeShown() {
                        return false;
                    }

                    @NotNull
                    public StructureViewModel createStructureViewModel(@Nullable Editor editor2) {
                        StructureViewModel structureViewModel = (StructureViewModel)modelFactory.fun(psi, editor2);
                        if (structureViewModel == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return structureViewModel;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder$1$1", "createStructureViewModel"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder$1", "createMainBuilder"));
            }
        };
    }

    protected TemplateLanguageStructureViewBuilder(PsiElement psiElement) {
        this.myProject = psiElement.getProject();
        this.myVirtualFile = psiElement.getContainingFile().getVirtualFile();
    }

    public boolean isRootNodeShown() {
        return false;
    }

    @NotNull
    public StructureView createStructureView(final FileEditor fileEditor, final @NotNull Project project2) {
        if (project2 == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        VirtualFile file2 = fileEditor == null ? null : fileEditor.getFile();
        PsiFile psiFile = file2 == null || !file2.isValid() ? null : PsiManager.getInstance(project2).findFile(file2);
        final List<Language> languages = this.getLanguages(psiFile).toList();
        for (Language language : languages) {
            StructureViewBuilder builder2 = this.getBuilder(Objects.requireNonNull(psiFile), language);
            if (builder2 == null) continue;
            StructureView structureView = builder2.createStructureView(fileEditor, project2);
            String title = language.getDisplayName();
            Icon icon2 = ObjectUtils.notNull(LanguageUtil.getLanguageFileType(language), FileTypes.UNKNOWN).getIcon();
            viewDescriptors.add(new StructureViewComposite.StructureViewDescriptor(title, structureView, icon2));
        }
        StructureViewComposite.StructureViewDescriptor[] array = viewDescriptors.toArray(new StructureViewComposite.StructureViewDescriptor[0]);
        return new StructureViewComposite(array){

            public boolean isOutdated() {
                VirtualFile file2 = fileEditor == null ? null : fileEditor.getFile();
                PsiFile psiFile = file2 == null || !file2.isValid() ? null : PsiManager.getInstance(project2).findFile(file2);
                List<Language> newLanguages = TemplateLanguageStructureViewBuilder.this.getLanguages(psiFile).toList();
                return !Comparing.equal(languages, newLanguages);
            }
        };
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor2) {
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        PsiFile psiFile = Objects.requireNonNull(PsiManager.getInstance(this.myProject).findFile(this.myVirtualFile));
        for (Language language : this.getLanguages(psiFile)) {
            StructureViewBuilder builder2 = this.getBuilder(psiFile, language);
            if (!(builder2 instanceof TreeBasedStructureViewBuilder)) continue;
            StructureViewModel model2 = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(editor2);
            String title = language.getDisplayName();
            Icon icon2 = ObjectUtils.notNull(LanguageUtil.getLanguageFileType(language), FileTypes.UNKNOWN).getIcon();
            viewDescriptors.add(new StructureViewComposite.StructureViewDescriptor(title, model2, icon2));
        }
        return new StructureViewCompositeModel(psiFile, editor2, viewDescriptors);
    }

    @NotNull
    private JBIterable<Language> getLanguages(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            JBIterable<Language> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Language baseLanguage = viewProvider.getBaseLanguage();
        Language dataLanguage = viewProvider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage() : null;
        JBIterable<Language> jBIterable = JBIterable.of(baseLanguage).append(dataLanguage).append((Language)((Object)viewProvider.getLanguages())).unique().filter(language -> {
            PsiFile psi = viewProvider.getPsi((Language)language);
            return psi != null && (language == baseLanguage || this.isAcceptableBaseLanguageFile(psi));
        });
        if (jBIterable == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Nullable
    private StructureViewBuilder getBuilder(@NotNull PsiFile psiFile, @NotNull Language language) {
        if (psiFile == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(4);
        }
        if (language == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(5);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Language baseLanguage = viewProvider.getBaseLanguage();
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            return null;
        }
        if (language == baseLanguage) {
            return this.createMainBuilder(psi);
        }
        PsiStructureViewFactory factory2 = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
        return factory2 == null ? null : factory2.getStructureViewBuilder(psi);
    }

    protected boolean isAcceptableBaseLanguageFile(PsiFile dataFile) {
        return true;
    }

    @Nullable
    protected abstract TreeBasedStructureViewBuilder createMainBuilder(@NotNull PsiFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStructureView";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBuilder";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

