/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.NewActionGroup;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchImplUtil;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue("ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @NotNull
    static ScratchFileCreationHelper.Context createContext(@NotNull AnActionEvent e) {
        if (e == null) {
            ScratchFileActions.$$$reportNull$$$0(0);
        }
        Project project2 = Objects.requireNonNull(e.getProject());
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file2 == null && editor2 != null) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        }
        return ScratchFileActions.createContext(project2, file2, editor2, e.getDataContext());
    }

    @NotNull
    static ScratchFileCreationHelper.Context createContext(@NotNull Project project2, @Nullable PsiFile file2, @Nullable Editor editor2, @NotNull DataContext dataContext) {
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(2);
        }
        ScratchFileCreationHelper.Context context2 = new ScratchFileCreationHelper.Context();
        context2.text = StringUtil.notNullize(ScratchFileActions.getSelectionText(editor2));
        if (StringUtil.isNotEmpty(context2.text)) {
            ScratchFileActions.initLanguageFromCaret(project2, editor2, file2, context2, dataContext);
        }
        context2.ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        ScratchFileCreationHelper.Context context3 = context2;
        if (context3 == null) {
            ScratchFileActions.$$$reportNull$$$0(3);
        }
        return context3;
    }

    @Nullable
    static PsiFile doCreateNewScratch(@NotNull Project project2, @NotNull ScratchFileCreationHelper.Context context2) {
        LanguageFileType fileType;
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(5);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        if (context2.fileExtension == null && context2.language != null && (fileType = context2.language.getAssociatedFileType()) != null) {
            context2.fileExtension = ScratchImplUtil.getFileTypeExtensions(fileType, true, FileTypeManager.getInstance()).first();
        }
        if (context2.language != null) {
            ScratchFileCreationHelper helper = ScratchFileCreationHelper.EXTENSION.forLanguage(context2.language);
            if (StringUtil.isEmpty(context2.text)) {
                helper.prepareText(project2, context2, DataContext.EMPTY_CONTEXT);
            }
            helper.beforeCreate(project2, context2);
        }
        VirtualFile dir = context2.ideView != null ? PsiUtilCore.getVirtualFile(ArrayUtil.getFirstElement(context2.ideView.getDirectories())) : null;
        RootType rootType = dir == null ? null : ScratchFileService.findRootType(dir);
        String relativePath = rootType != ScratchRootType.getInstance() ? "" : FileUtil.getRelativePath(ScratchFileService.getInstance().getRootPath(rootType), dir.getPath(), '/');
        String fileName = (String)(StringUtil.isEmpty(relativePath) ? "" : relativePath + "/") + PathUtil.makeFileName(ObjectUtils.notNull(context2.filePrefix, "scratch") + (Serializable)(context2.fileCounter != null ? (Serializable)context2.fileCounter.create() : ""), context2.fileExtension);
        VirtualFile file2 = ScratchRootType.getInstance().createScratchFile(project2, fileName, context2.language, context2.text, context2.createOption);
        if (file2 == null) {
            return null;
        }
        Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(project2, file2, context2.caretOffset);
        navigatable.navigate(!LaterInvocator.isInModalContextForProject(project2));
        PsiFile psiFile = PsiManager.getInstance(project2).findFile(file2);
        if (context2.ideView != null && psiFile != null) {
            context2.ideView.selectElement((PsiElement)psiFile);
        }
        return psiFile;
    }

    private static void checkLanguageAndTryToFixText(@NotNull Project project2, @NotNull ScratchFileCreationHelper.Context context2, @NotNull DataContext dataContext) {
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(8);
        }
        if (context2.language == null) {
            return;
        }
        ScratchFileCreationHelper handler = ScratchFileCreationHelper.EXTENSION.forLanguage(context2.language);
        if (handler.prepareText(project2, context2, dataContext)) {
            return;
        }
        PsiFile psiFile = ScratchFileCreationHelper.parseHeader(project2, context2.language, context2.text);
        PsiErrorElement firstError = SyntaxTraverser.psiTraverser(psiFile).traverse().filter(PsiErrorElement.class).first();
        if (firstError != null && firstError.getParent() == psiFile) {
            context2.language = null;
        }
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor2) {
        if (editor2 == null) {
            return null;
        }
        return editor2.getSelectionModel().getSelectedText(true);
    }

    private static void initLanguageFromCaret(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile, @NotNull ScratchFileCreationHelper.Context context2, @NotNull DataContext dataContext) {
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(11);
        }
        if (editor2 == null || psiFile == null) {
            return;
        }
        Caret caret = editor2.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element2 = InjectedLanguageManager.getInstance(project2).findInjectedElementAt(psiFile, offset);
        PsiFile file2 = element2 != null ? element2.getContainingFile() : psiFile;
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType fileType = ScratchImplUtil.getFileTypeFromName(file2.getName(), fileTypeManager);
        Language language = context2.language = fileType instanceof LanguageFileType ? file2.getLanguage() : null;
        if (fileType != null) {
            context2.fileExtension = ScratchImplUtil.getFileTypeExtensions(fileType, true, fileTypeManager).first();
        }
        if (context2.language == PlainTextLanguage.INSTANCE && file2.getFileType() instanceof InternalFileType) {
            context2.language = StdLanguages.XML;
        }
        ScratchFileActions.checkLanguageAndTryToFixText(project2, context2, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateNewScratch";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkLanguageAndTryToFixText";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initLanguageFromCaret";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExportToScratchAction
    extends DumbAwareAction {
        public ExportToScratchAction() {
            this.setEnabledInModalContext(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ExportToScratchAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExportToScratchAction.$$$reportNull$$$0(1);
            }
            Project project2 = e.getProject();
            Component c = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            ScratchImplUtil.TextExtractor extractor = ScratchImplUtil.getTextExtractor(c);
            boolean isFileEditor = EditorUtil.isRealFileEditor((Editor)((Editor)e.getData(CommonDataKeys.EDITOR)));
            e.getPresentation().setEnabled(project2 != null && extractor != null && !isFileEditor);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String text2;
            Project project2;
            if (e == null) {
                ExportToScratchAction.$$$reportNull$$$0(2);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            ScratchImplUtil.TextExtractor extractor = ScratchImplUtil.getTextExtractor((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
            String string2 = text2 = extractor == null ? null : extractor.extractText();
            if (text2 == null) {
                return;
            }
            ScratchFileCreationHelper.Context context2 = new ScratchFileCreationHelper.Context();
            context2.text = text2;
            context2.fileExtension = PlainTextFileType.INSTANCE.getDefaultExtension();
            ScratchFileActions.doCreateNewScratch(project2, context2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$ExportToScratchAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$ExportToScratchAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ShowFilesPopupAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(2);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            RecentLocationsAction.showPopup((Project)project2, (boolean)false, (String)LangBundle.message("scratch.file.popup.title", new Object[0]), (String)LangBundle.message("scratch.file.popup.changed.title", new Object[0]), (String)LangBundle.message("scratch.file.popup.title.empty.text", new Object[0]), changed2 -> ShowFilesPopupAction.getPlaces(project2, changed2), toRemove2 -> ShowFilesPopupAction.removePlaces(project2, toRemove2));
        }

        @NotNull
        private static List<IdeDocumentHistoryImpl.PlaceInfo> getPlaces(@NotNull Project project2, boolean changed2) {
            Condition<Object> condition;
            if (project2 == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(3);
            }
            String path2 = ScratchFileService.getInstance().getRootPath(ScratchRootType.getInstance());
            VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(path2);
            if (rootDir == null || !rootDir.exists() || !rootDir.isDirectory()) {
                List<IdeDocumentHistoryImpl.PlaceInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    ShowFilesPopupAction.$$$reportNull$$$0(4);
                }
                return list2;
            }
            if (!changed2) {
                condition = Conditions.alwaysTrue();
            } else {
                Set<VirtualFile> files2 = JBIterable.from(IdeDocumentHistory.getInstance((Project)project2).getChangePlaces()).map(o -> o.getFile()).toSet();
                condition = files2::contains;
            }
            final ArrayList<IdeDocumentHistoryImpl.PlaceInfo> result2 = new ArrayList<IdeDocumentHistoryImpl.PlaceInfo>();
            VfsUtilCore.visitChildrenRecursively(rootDir, new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

                @Override
                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2.isDirectory() || !file2.isValid() || !condition.value(file2)) {
                        return true;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    if (document == null) {
                        return true;
                    }
                    RangeMarker caret = document.createRangeMarker(0, 0);
                    result2.add(new IdeDocumentHistoryImpl.PlaceInfo(file2, (FileEditorState)new TextEditorState(), "text-editor", null, caret));
                    return result2.size() < 1000;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileActions$ShowFilesPopupAction$1", "visitFile"));
                }
            });
            Collections.sort(result2, Comparator.comparing(o -> o.getFile().getName(), NaturalComparator.INSTANCE));
            ArrayList<IdeDocumentHistoryImpl.PlaceInfo> arrayList = result2;
            if (arrayList == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static void removePlaces(@NotNull Project project2, @NotNull List<IdeDocumentHistoryImpl.PlaceInfo> toRemove2) {
            if (project2 == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(6);
            }
            if (toRemove2 == null) {
                ShowFilesPopupAction.$$$reportNull$$$0(7);
            }
            PsiManager psiManager = PsiManager.getInstance(project2);
            List<PsiFile> files2 = ContainerUtil.mapNotNull(toRemove2, o -> psiManager.findFile(o.getFile()));
            DeleteHandler.deletePsiElement(files2.toArray(PsiElement.EMPTY_ARRAY), project2, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$ShowFilesPopupAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toRemove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$ShowFilesPopupAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPlaces";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removePlaces";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ChangeLanguageAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ChangeLanguageAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeLanguageAction.$$$reportNull$$$0(1);
            }
            Project project2 = e.getProject();
            JBIterable<VirtualFile> files2 = JBIterable.of((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
            if (project2 == null || files2.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Condition<VirtualFile> isScratch = this.fileFilter(project2);
            if (!files2.filter(Conditions.not(isScratch)).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            Set<String> languages = files2.filter(isScratch).map(file2 -> {
                Language language;
                Language language2 = language = LanguageUtil.getFileLanguage(file2) == null ? null : this.fileLanguage(project2, (VirtualFile)file2);
                if (language != null) {
                    return language.getDisplayName();
                }
                return fileTypeManager.getFileTypeByFileName(file2.getName()).getDisplayName();
            }).toSet();
            String langName = languages.size() == 1 ? languages.iterator().next() : LangBundle.message("scratch.file.actions.0.different.languages.number", languages.size());
            e.getPresentation().setText(this.getChangeLanguageActionName(langName));
            e.getPresentation().setEnabledAndVisible(true);
        }

        @NotNull
        @Nls
        protected String getChangeLanguageActionName(@NotNull String languageName) {
            if (languageName == null) {
                ChangeLanguageAction.$$$reportNull$$$0(2);
            }
            String string2 = LangBundle.message("scratch.file.action.change.language.action", languageName);
            if (string2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @NotNull
        @Nls
        protected String getChangeLanguageTitle() {
            String string2 = LangBundle.message("scratch.file.action.change.language.title", new Object[0]);
            if (string2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                ChangeLanguageAction.$$$reportNull$$$0(5);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            JBIterable<VirtualFile> files2 = JBIterable.of((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)).filter(this.fileFilter(project2));
            if (files2.isEmpty()) {
                return;
            }
            this.actionPerformedImpl(e, project2, this.getChangeLanguageTitle(), files2);
        }

        @NotNull
        protected Condition<VirtualFile> fileFilter(@NotNull Project project2) {
            if (project2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(6);
            }
            Condition<VirtualFile> condition = file2 -> !file2.isDirectory() && ScratchRootType.getInstance().containsFile((VirtualFile)file2);
            if (condition == null) {
                ChangeLanguageAction.$$$reportNull$$$0(7);
            }
            return condition;
        }

        @Nullable
        protected Language fileLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
            Language lang;
            if (project2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(8);
            }
            if (file2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(9);
            }
            return (lang = ScratchFileService.getInstance().getScratchesMapping().getMapping(file2)) != null ? lang : LanguageUtil.getLanguageForPsi(project2, file2);
        }

        protected void actionPerformedImpl(@NotNull AnActionEvent e, @NotNull Project project2, @NotNull @NlsContexts.PopupTitle String title, @NotNull JBIterable<? extends VirtualFile> files2) {
            if (e == null) {
                ChangeLanguageAction.$$$reportNull$$$0(10);
            }
            if (project2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(11);
            }
            if (title == null) {
                ChangeLanguageAction.$$$reportNull$$$0(12);
            }
            if (files2 == null) {
                ChangeLanguageAction.$$$reportNull$$$0(13);
            }
            ScratchFileService fileService = ScratchFileService.getInstance();
            PerFileMappings<Language> mapping = fileService.getScratchesMapping();
            VirtualFile[] filesCopy = VfsUtilCore.toVirtualFileArray(JBIterable.from(files2).toList());
            Arrays.sort(filesCopy, (o1, o2) -> StringUtil.compare(o1.getName(), o2.getName(), !o1.isCaseSensitive()));
            ScratchImplUtil.buildLanguagesPopup(project2, title).onChosen(item -> {
                try {
                    WriteCommandAction.writeCommandAction(project2).withName(LangBundle.message("command.name.change.language", new Object[0])).run(() -> ScratchImplUtil.changeLanguageWithUndo(project2, item, filesCopy, mapping));
                }
                catch (UnexpectedUndoException e1) {
                    ExceptionUtil.rethrowUnchecked(e1);
                }
            }).buildPopup().showCenteredInCurrentWindow(project2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$ChangeLanguageAction";
                    break;
                }
                case 1: 
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageName";
                    break;
                }
                case 6: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$ChangeLanguageAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeLanguageActionName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeLanguageTitle";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getChangeLanguageActionName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fileFilter";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "fileLanguage";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformedImpl";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NewBufferAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(1);
            }
            boolean enabled = e.getProject() != null && Registry.intValue("ide.scratch.buffers") > 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(2);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            ScratchFileCreationHelper.Context context2 = new ScratchFileCreationHelper.Context();
            context2.filePrefix = "buffer";
            context2.createOption = ScratchFileService.Option.create_if_missing;
            context2.fileCounter = () -> ScratchFileActions.nextBufferIndex();
            context2.language = PlainTextLanguage.INSTANCE;
            ScratchFileActions.doCreateNewScratch(project2, context2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NewFileAction
    extends DumbAwareAction {
        private static final Icon ICON = LayeredIcon.create((Icon)AllIcons.FileTypes.Text, (Icon)AllIcons.Actions.Scratch);
        private static final String ACTION_ID = "NewScratchFile";
        private final NotNullLazyValue<@Nls String> myActionText = NotNullLazyValue.lazy(() -> NewActionGroup.isActionInNewPopupMenu((AnAction)this) ? ActionsBundle.actionText((String)ACTION_ID) : ActionsBundle.message((String)"action.NewScratchFile.text.with.new", (Object[])new Object[0]));

        public NewFileAction() {
            this.getTemplatePresentation().setIcon(ICON);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NewFileAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(1);
            }
            this.getTemplatePresentation().setText(this.myActionText.getValue());
            Project project2 = e.getProject();
            String place = e.getPlace();
            boolean enabled = project2 != null && (e.isFromActionToolbar() || ActionPlaces.isMainMenuOrActionSearch((String)place) || ActionPlaces.isPopupPlace((String)place) && e.getData(LangDataKeys.IDE_VIEW) != null);
            e.getPresentation().setEnabledAndVisible(enabled);
            this.updatePresentationTextAndIcon(e, e.getPresentation());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(2);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            Component component2 = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            ScratchFileCreationHelper.Context context2 = ScratchFileActions.createContext(e);
            ScratchImplUtil.LanguageItem selectionItem = context2.language != null ? ScratchImplUtil.LanguageItem.fromLanguage(context2.language) : (context2.fileExtension != null ? new ScratchImplUtil.LanguageItem(null, FileTypeManager.getInstance().getFileTypeByExtension(context2.fileExtension), context2.fileExtension) : (StringUtil.isNotEmpty(context2.text) ? new ScratchImplUtil.LanguageItem(null, PlainTextFileType.INSTANCE, PlainTextFileType.INSTANCE.getDefaultExtension()) : null));
            ScratchImplUtil.TextExtractor textExtractor = selectionItem == null ? ScratchImplUtil.getTextExtractor(component2) : null;
            ScratchImplUtil.LanguageItem extractItem = textExtractor != null && StringUtil.isEmpty(context2.text) && !EditorUtil.isRealFileEditor((Editor)((Editor)e.getData(CommonDataKeys.EDITOR))) ? new ScratchImplUtil.LanguageItem(null, PlainTextFileType.INSTANCE, PlainTextFileType.INSTANCE.getDefaultExtension()) : null;
            Consumer<ScratchImplUtil.LanguageItem> consumer = o -> {
                context2.language = o.language;
                context2.fileExtension = o.fileExtension;
                if (o == extractItem) {
                    context2.text = StringUtil.notNullize(textExtractor.extractText());
                    context2.caretOffset = 0;
                } else if (o != selectionItem) {
                    context2.text = "";
                    context2.caretOffset = 0;
                }
                ScratchFileActions.doCreateNewScratch(project2, context2);
            };
            if (selectionItem != null && ApplicationManager.getApplication().isUnitTestMode()) {
                consumer.consume(selectionItem);
                return;
            }
            LRUPopupBuilder<ScratchImplUtil.LanguageItem> builder2 = ScratchImplUtil.buildLanguagesPopup(project2, ActionsBundle.message((String)"action.NewScratchFile.text.with.new", (Object[])new Object[0]));
            if (selectionItem != null) {
                String displayName = LangBundle.message("scratch.file.action.new.from.selection", selectionItem.fileType.getDisplayName());
                builder2.withExtraTopValue(selectionItem, displayName, EmptyIcon.ICON_16);
            } else if (extractItem != null) {
                String displayName = LangBundle.message("scratch.file.action.new.from.ui", new Object[0]);
                if (textExtractor.hasSelection()) {
                    builder2.withExtraTopValue(extractItem, displayName, EmptyIcon.ICON_16);
                } else {
                    builder2.withExtraMiddleValue(extractItem, displayName, EmptyIcon.ICON_16);
                }
            }
            builder2.onChosen(consumer).buildPopup().showCenteredInCurrentWindow(project2);
        }

        private void updatePresentationTextAndIcon(@NotNull AnActionEvent e, @NotNull Presentation presentation2) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(3);
            }
            if (presentation2 == null) {
                NewFileAction.$$$reportNull$$$0(4);
            }
            presentation2.setText(this.myActionText.getValue());
            presentation2.setIcon(ICON);
            if ("MainMenu".equals(e.getPlace()) && !NewActionGroup.isActionInNewPopupMenu((AnAction)this)) {
                presentation2.setIcon(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$NewFileAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewFileAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePresentationTextAndIcon";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

