/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.JBDateFormat;
import com.intellij.util.ui.tree.TreeUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJB\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/projectView/impl/ProjectViewRenderer;", "Lcom/intellij/ide/util/treeView/NodeRenderer;", "()V", "appendInplaceComments", "", "node", "Lcom/intellij/ide/projectView/ProjectViewNode;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "customizeCellRenderer", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.platform.lang.impl"})
public class ProjectViewRenderer
extends NodeRenderer {
    public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        Object userObject = TreeUtil.getUserObject((Object)value);
        if (userObject instanceof ProjectViewNode && UISettings.Companion.getInstance().getShowInplaceComments()) {
            this.appendInplaceComments((ProjectViewNode)((Object)userObject));
        }
    }

    public final void appendInplaceComments(@Nullable Project project2, @Nullable VirtualFile file2) {
        BasicFileAttributes basicFileAttributes;
        Path ioFile = file2 == null || file2.isDirectory() || !file2.isInLocalFileSystem() ? null : file2.toNioPath();
        try {
            basicFileAttributes = ioFile == null ? null : Files.readAttributes(ioFile, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception ignored) {
            basicFileAttributes = null;
        }
        BasicFileAttributes fileAttributes = basicFileAttributes;
        if (fileAttributes != null) {
            this.append("  ");
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
            this.append(JBDateFormat.getFormatter().formatDateTime(fileAttributes.lastModifiedTime().toMillis()), attributes);
            this.append(", " + StringUtil.formatFileSize(fileAttributes.size()), attributes);
        }
        if (Registry.is("show.last.visited.timestamps") && file2 != null && project2 != null) {
            IdeDocumentHistoryImpl.appendTimestamp((Project)project2, (SimpleColoredComponent)((SimpleColoredComponent)this), (VirtualFile)file2);
        }
    }

    private final void appendInplaceComments(ProjectViewNode<?> node2) {
        AbstractTreeNode parentNode = node2.getParent();
        Object content2 = node2.getValue();
        if (content2 instanceof PsiFileSystemItem || !(content2 instanceof PsiElement) || parentNode != null && parentNode.getValue() instanceof PsiDirectory) {
            this.appendInplaceComments(node2.getProject(), node2.getVirtualFile());
        }
    }

    public ProjectViewRenderer() {
        this.setOpaque(false);
        this.setIconOpaque(false);
        this.setTransparentIconBackground(true);
    }
}

